package org.gcube.execution.rr.bridge;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;

import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.RRContext.DatastoreType;
import gr.uoa.di.madgik.rr.bridge.IRegistryProvider;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.config.StaticConfigurationDao;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadata;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadataDao;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.FieldDao;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.PresentableDao;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import gr.uoa.di.madgik.rr.element.search.SearchableDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainerDao;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;
import gr.uoa.di.madgik.rr.RRContext;

public class GCubeRepositoryProvider implements IRegistryProvider
{
	private static Logger logger=Logger.getLogger(GCubeRepositoryProvider.class.getName());
	
	public static String RRModelGenericResourceNameDef = "ResourceRegistryModel";
	public static String RRModelGenericResourceSecondaryTypeDef = "ResourceRegistryModel";

	public static String RRModelGenericResourceName = RRModelGenericResourceNameDef;
	public static String RRModelGenericResourceSecondaryType = RRModelGenericResourceSecondaryTypeDef;

	public Set<Class<?>> inMemoryTargets = new HashSet<Class<?>>();
	
	static 
	{
		BridgeHelper.initializeIndexTypes();
	}
	
	@Override
	public void readConfiguration(Properties config)
	{
		if(config == null) return;
		boolean defaultUsed = true;
		String value = null;
		
		if((value = config.getProperty("modelGenericResourceSecondaryType")) != null)
		{
			String secTypeValue = value;
			if((value = config.getProperty("modelGenericResourceName")) != null)
			{
				GCubeRepositoryProvider.RRModelGenericResourceSecondaryType = secTypeValue;
				GCubeRepositoryProvider.RRModelGenericResourceName = value;
				defaultUsed = false;
				logger.log(Level.INFO, "Using Model Generic Resource secondary type: " + GCubeRepositoryProvider.RRModelGenericResourceSecondaryType);
				logger.log(Level.INFO, "Using Model Generic Resource name: " + GCubeRepositoryProvider.RRModelGenericResourceName);
			}
		}
		if(defaultUsed)
		{
			logger.log(Level.INFO, "Using default Model Generic Resource secondary type: " + GCubeRepositoryProvider.RRModelGenericResourceSecondaryType);
			logger.log(Level.INFO, "Using default Model Generic Resource name: " + GCubeRepositoryProvider.RRModelGenericResourceName);
		}
		
//		if((value = config.getProperty("updateFieldsOnDataSourceRefresh")) != null)
//		{
//			if(value.equalsIgnoreCase("true")) GCubeRepositoryProvider.UpdateFieldsOnDataSourceRefresh = true;
//			else GCubeRepositoryProvider.UpdateFieldsOnDataSourceRefresh = false;
//		}
		try
		{
			BridgeHelper.initializeIndexTypes(config);
		}catch(ResourceRegistryException e)
		{
			logger.log(Level.WARNING, "Could not initialize index types. Defaults will be used", e);
			BridgeHelper.initializeIndexTypes();
		}
	}
	
	@Override
	public boolean isReadPolicySupported(RRContext.ReadPolicy policy) throws ResourceRegistryException
	{
		switch(policy)
		{
			case READ_LOCAL:
			{
				return false;
			}
			case READ_THROUGH:
			{
				return false;
			}
			case REFRESH_AHEAD:
			{
				return ResourceRegistry.getContext().isDatastoreSupported(DatastoreType.LOCAL) && ResourceRegistry.getContext().isDatastoreSupported(DatastoreType.LOCALBUFFER);
			}
			default:
				return false;
		}
	}
	
	@Override
	public boolean isWritePolicySupported(RRContext.WritePolicy policy) throws ResourceRegistryException
	{
		switch(policy)
		{
			case WRITE_THROUGH:
			{
				return false; 
			}
			case WRITE_LOCAL:
			{
				return false;
			}
			case WRITE_BEHIND: 
			{
				return ResourceRegistry.getContext().isDatastoreSupported(DatastoreType.LOCAL) && ResourceRegistry.getContext().isDatastoreSupported(DatastoreType.LOCALBUFFER);
			}
			default:
				return false;
		}
	}
	
	@Override
	public void setInMemoryTargets(Set<Class<?>> items)
	{
		this.inMemoryTargets = items;
	}
	
	@Override
	public void persistDirect(Class<?> item, String id) throws ResourceRegistryException
	{
		throw new ResourceRegistryException("Operation not supported");
	}
	
	@Override
	public void persistDirect(Class<?> items) throws ResourceRegistryException
	{
		throw new ResourceRegistryException("Operation not supported");
	}
	
	@Override
	public void persist(Set<Class<?>> items) throws ResourceRegistryException
	{
		logger.log(Level.INFO, "starting aligning");
		this.alignOutgoing(items);
		logger.log(Level.INFO,"starting persisting");
		this.bridgeOutgoing(items);
		logger.log(Level.INFO,"finished persisting");
	}

	@Override
	public void retrieve(Set<Class<?>> items) throws ResourceRegistryException
	{
		logger.log(Level.INFO,"starting retrieving");
		this.bridgeIncoming(items);
		logger.log(Level.INFO,"starting aligning");
		this.alignIncoming(items);
		logger.log(Level.INFO,"finished retrieving");
	}
	
	@Override
	public void retrieveDirect(Class<?> item, String id) throws ResourceRegistryException
	{
		throw new ResourceRegistryException("Operation not supported");
	}
	
	public void retrieveDirect(Class<?> item) throws ResourceRegistryException
	{
		throw new ResourceRegistryException("Operation not supported");
	}
	
	@Override
	public void prefetchInMemoryItems() throws ResourceRegistryException
	{
		BridgeHelper.prefetchInMemoryItems(this.inMemoryTargets);
	}
	
	private void bridgeIncoming(Set<Class<?>> targets) throws ResourceRegistryException
	{
		try
		{
			BridgeHelper.retrieveScopes();
			FieldModel.retrieve();
			for(Class<?> include : targets)
			{
				logger.log(Level.INFO, "retrieving info from IS for element "+include.getName());
				Set<IDaoElement> items=BridgeHelper.getElement(include);
				logger.log(Level.INFO, "buffering information retrieved for element "+include.getName());
				DatastoreHelper.bufferItems(items);
			}
		}catch(Exception ex)
		{
			throw new ResourceRegistryException("could not bridge incoming elements", ex);
		}
	}
	
	private void alignIncoming(Set<Class<?>> targets) throws ResourceRegistryException
	{
		boolean locked = false;
		Lock writeLock = ResourceRegistry.getContext().getExclusiveLock();
		try
		{
			boolean updateMode = !(targets.contains(FieldDao.class) &&
			targets.contains(SearchableDao.class) && targets.contains(PresentableDao.class));
			//boolean updateFieldsOnDSRefresh = GCubeRepositoryProvider.UpdateFieldsOnDataSourceRefresh && updateMode;
			RRContext.DatastoreType datastoreType = ResourceRegistry.isInitialBridgingComplete() && updateMode ? RRContext.DatastoreType.LOCAL : RRContext.DatastoreType.LOCALBUFFER;
			List<Field> allFields = Field.getAll(true, DatastoreType.LOCALBUFFER);
			List<DataSource> allDataSources = DataSource.getAll(false, DatastoreType.LOCALBUFFER);
			Set<IDaoElement> allMetadata = DatastoreHelper.getItems(DatastoreType.LOCALBUFFER, ElementMetadataDao.class);
			
			writeLock.lock(); locked = true;
			List<ElementMetadata> updatedFieldsMetadata = ElementMetadata.getUpdatedFieldsMetadata(true);
			for(ElementMetadata m : updatedFieldsMetadata)
				m.delete(true, DatastoreType.LOCAL);
			writeLock.unlock(); locked = false;
			
			//Replace field names in FieldIndexContainer with field ids, for all published fields
			if(targets.contains(FieldIndexContainerDao.class))
			{
				Set<IDaoElement> elems = DatastoreHelper.retrieveAll(RRContext.DatastoreType.LOCALBUFFER, FieldIndexContainerDao.class);
				HashSet<Class<?>> purge=new HashSet<Class<?>>();
				purge.add(FieldIndexContainerDao.class);
				DatastoreHelper.clear(RRContext.DatastoreType.LOCALBUFFER, purge);
				for(IDaoElement el : elems)
				{
					if(!(el instanceof FieldIndexContainerDao)) continue;
				//	List<Field> fs = Field.getFieldsWithName(false, ((FieldIndexContainerDao)el).getField());
					Field f = null;
					for(Field field: allFields)
					{
						if(field.getName().equals(((FieldIndexContainerDao)el).getField()))
						{
							f = field;
							break;
						}
					}
					if(f!=null)
					{
						((FieldIndexContainerDao)el).setField(f.getID());
					}
					//Field updatedField = null;
					//if(updateFieldsOnDSRefresh) 
					//{
					//	updatedField = updateField(f, (FieldIndexContainerDao)el, allFields, allDataSources, allMetadata, datastoreType);
					//	if(f==null && updatedField != null) ((FieldIndexContainerDao)el).setField(updatedField.getID());
					//}
				}
				DatastoreHelper.bufferItems(elems);
			}
			
			for(Field f : allFields)
			{
				for(Searchable s : f.getSearchables()) {
					DataSource ds = null;
					for(DataSource d : allDataSources)
					{
						if(d.getID().equals(s.getLocator()))
						{
							ds = d;
							break;
						}
					}
					if(ds != null) s.getDatasourceScopes().addAll(ds.getScopes());
				//	s.delete(true, datastoreType);
					Searchable item=new Searchable();
					item.setID(s.getID());
					item.setCollection(s.getCollection());
					item.setField(s.getField());
					item.setLocator(s.getLocator());
					item.setExpression(s.getExpression());
					item.setOrder(s.isOrder());
					item.getCapabilities().addAll(s.getCapabilities());
					item.setDatasourceScopes(s.getDatasourceScopes());
					item.store(true, datastoreType);
				}
				
				for(Presentable p : f.getPresentables()) {
					DataSource ds = null;
					for(DataSource d : allDataSources)
					{
						if(d.getID().equals(p.getLocator()))
						{
							ds = d;
							break;
						}
					}
					if(ds != null) p.getDatasourceScopes().addAll(ds.getScopes());
				//	s.delete(true, datastoreType);
					Presentable item=new Presentable();
					item.setID(p.getID());
					item.setCollection(p.getCollection());
					item.setField(p.getField());
					item.setLocator(p.getLocator());
					item.setExpression(p.getExpression());
					item.setOrder(p.isOrder());
					item.setPresentationInfo(p.getPresentationInfo());
					item.setDatasourceScopes(p.getDatasourceScopes());
					item.store(true, datastoreType);
				}
			}
			
		}catch(Exception ex)
		{
			throw new ResourceRegistryException("could not align incoming elements", ex);
		}finally
		{
			if(locked) writeLock.unlock();
		}
	}
	
	private void alignOutgoing(Set<Class<?>> targets) throws ResourceRegistryException
	{
		
		
	}
	
	private void bridgeOutgoing(Set<Class<?>> targets) throws ResourceRegistryException
	{
		try 
		{
			logger.log(Level.INFO, "retrieving field info from local");
			Set<IDaoElement> fields = new HashSet<IDaoElement>();
			Set<IDaoElement> searchables = new HashSet<IDaoElement>();
			Set<IDaoElement> presentables = new HashSet<IDaoElement>();
			Set<IDaoElement> metadata = new HashSet<IDaoElement>();
			IDaoElement staticConfig = null;
			
			boolean updateFields = false;
			boolean updateSearchables = false;
			boolean updatePresentables = false;
			boolean updateMetadata = false;
			boolean updateConfig = false;
			if(targets.contains(FieldDao.class))
			{
				logger.log(Level.INFO,"retrieving info for "+FieldDao.class.getName());
				fields = DatastoreHelper.retrieveAll(RRContext.DatastoreType.LOCAL, FieldDao.class);
				logger.log(Level.INFO,"done retrieving info for "+ fields.size() +" "+FieldDao.class.getName());
				updateFields = true;
			}
			if(targets.contains(SearchableDao.class))
			{
				logger.log(Level.INFO,"retrieving info for "+SearchableDao.class.getName());
				searchables = DatastoreHelper.retrieveAll(RRContext.DatastoreType.LOCAL, SearchableDao.class);
				logger.log(Level.INFO,"done retrieving info for "+ searchables.size() +" "+SearchableDao.class.getName());
				updateSearchables = true;
			}
			if(targets.contains(PresentableDao.class))
			{
				logger.log(Level.INFO,"retrieving info for "+PresentableDao.class.getName());
				presentables = DatastoreHelper.retrieveAll(RRContext.DatastoreType.LOCAL, PresentableDao.class);
				logger.log(Level.INFO,"done retrieving info for "+ presentables.size() +" "+PresentableDao.class.getName());
				updatePresentables = true;
			}
			if(targets.contains(ElementMetadataDao.class))
			{
				logger.log(Level.INFO,"retrieving info for "+ElementMetadataDao.class.getName());
				metadata = DatastoreHelper.retrieveAll(RRContext.DatastoreType.LOCAL, ElementMetadataDao.class);
				logger.log(Level.INFO,"done retrieving info for "+ metadata.size() +" "+ElementMetadataDao.class.getName());
				updateMetadata = true;
			}
			if(targets.contains(StaticConfigurationDao.class))
			{
				logger.log(Level.INFO,"retrieving info for " +StaticConfigurationDao.class.getName());
				Set<IDaoElement> staticConfigs = DatastoreHelper.retrieveAll(RRContext.DatastoreType.LOCAL, StaticConfigurationDao.class);
				logger.log(Level.INFO,"done retrieving info for " + staticConfigs.size() + " "+StaticConfigurationDao.class.getName());
				if(staticConfigs.size()>1) throw new ResourceRegistryException("Multiple static configuration elements were found");
				if(!staticConfigs.isEmpty()) staticConfig = staticConfigs.iterator().next();
				updateConfig = true;
			}
			
			if(!updateFields && !updateSearchables && !updatePresentables && !updateMetadata && !updateConfig)  return;
			
			logger.log(Level.INFO, "finished retrieving field info from local");
	
			ResourceRegistryException re = null;
			List<GCUBEGenericResource> resources=null;
			
			if(updateFields)
			{
				logger.log(Level.INFO, "updating field directory gcube generic resource");
				try
				{
					resources=BridgeHelper.getPublishedFieldResources();
				}catch(Exception ex)
				{
					throw new ResourceRegistryException("could not retrieve remote field directory", ex);
				}
				
				logger.log(Level.INFO, "resources      : " + resources);
				if (resources != null)
					logger.log(Level.INFO, "resources size : " + resources.size());
				
				if(resources.size()>0)
				{
					for(GCUBEGenericResource resource : resources)
					{
						logger.log(Level.INFO, "---------------------------------------------------");
						logger.log(Level.INFO, "Adding resource");
						logger.log(Level.INFO, resource.getID());
						logger.log(Level.INFO, resource.getName());
						logger.log(Level.INFO, resource.getDescription());
						logger.log(Level.INFO, resource.getBody());
						logger.log(Level.INFO, "---------------------------------------------------");
						resource.setDescription(Long.toString(new Date().getTime()));
						String serialization=BridgeHelper.buildFieldDirectorySerialization(fields);
						String scopes="(";
						for(GCUBEScope s : BridgeHelper.getFieldModelScopes()) scopes+=s+" ";
						scopes+=")";
						logger.log(Level.FINE, "updating field directory resource serialization in scope "+scopes+" to :\n"+serialization);
						resource.setBody(serialization);
						try
						{
							BridgeHelper.publishFieldResource(resource, false);
						}catch(Exception ex)
						{
							throw new ResourceRegistryException("could not publish remote field profile", ex);
						}
					}
				}
				else
				{
					GCUBEGenericResource resource =null;
					try
					{
						resource =GHNContext.getImplementation(GCUBEGenericResource.class);
					}catch(Exception ex)
					{
						throw new ResourceRegistryException("could not retrieve generic resource instance", ex);
					}
					resource.addScope(BridgeHelper.getFieldModelScopes());
					resource.setName(RRModelGenericResourceName);
					resource.setSecondaryType(RRModelGenericResourceSecondaryType);
					resource.setDescription(Long.toString(new Date().getTime()));
					String serialization=BridgeHelper.buildFieldDirectorySerialization(fields);
					String scopes="(";
					for(GCUBEScope s : BridgeHelper.getFieldModelScopes()) scopes+=s+" ";
					scopes+=")";
					logger.log(Level.FINE, "adding field directory resource serialization in scope "+scopes+" to :\n"+serialization);
					resource.setBody(serialization);
					try
					{
						logger.log(Level.INFO, "Adding NEW resource : " + resource);
						BridgeHelper.publishFieldResource(resource, true);
						logger.log(Level.INFO, "Adding NEW resource done ");
					}catch(Exception ex)
					{
						throw new ResourceRegistryException("could not publish remote field profile", ex);
					}
				}
				logger.log(Level.INFO, "finished updating field directory gcube generic resource");
		
				List<ElementMetadata> deletedFieldsMetadata = ElementMetadata.getDeletedFieldsMetadata(true);
				Set<String> deletedFieldIds = new HashSet<String>();
				for(ElementMetadata m : deletedFieldsMetadata)
				{
					try
					{
						resources=null;
						try
						{
							resources=BridgeHelper.getPublishedFieldResourcesForField(m.getProperties().get("id"));
						}catch(Exception ex)
						{
							throw new ResourceRegistryException("could not retrieve remote field profile", ex);
						}
						if(resources.size()>0)
						{
							for(GCUBEGenericResource resource : resources)
							{
								String scopes="(";
								for(GCUBEScope s : BridgeHelper.getFieldModelScopes()) scopes+=s+" ";
								scopes+=")";
								logger.log(Level.FINE, "deleting resource for field " + m.getProperties().get("id") + " in scope "+ scopes);
								try
								{
									BridgeHelper.deleteFieldResource(resource);
									deletedFieldIds.add(m.getProperties().get("id"));
								}catch(Exception ex)
								{
									throw new ResourceRegistryException("could not delete remote field profile", ex);
								}
							}
						}
						m.delete(true, DatastoreType.LOCAL);
					}catch(ResourceRegistryException e)
					{
						logger.log(Level.WARNING, "Could not delete remote field profiles");
						re = e;
					}
				}
			
				List<ElementMetadata> updatedFieldsMetadata = ElementMetadata.getUpdatedFieldsMetadata(true);
				Set<String> updatedFieldIds = new HashSet<String>();
				for(ElementMetadata m : updatedFieldsMetadata)
					updatedFieldIds.add(m.getProperties().get("id"));
				
				
				logger.log(Level.INFO, "Updating fields");
				logger.log(Level.INFO, "updatedFieldIds " + updatedFieldIds);
				
				for(IDaoElement f : fields)
				{
					try 
					{
						FieldDao field = (FieldDao)f;
						logger.log(Level.INFO, "1. updating gcube generic resource for field " + field.getName() + " (" + field.getID() + ")");
						// if(!updatedFieldIds.contains(field.getID())) continue; //field has not been updated, ignore
						if(deletedFieldIds.contains(f.getID())) continue;      //field has been deleted
						logger.log(Level.INFO, "2. updating gcube generic resource for field " + field.getName() + " (" + field.getID() + ")");
						resources=null;
						try
						{
							resources=BridgeHelper.getPublishedFieldResourcesForField(field.getID());
						}catch(Exception ex)
						{
							throw new ResourceRegistryException("could not retrieve remote field profile", ex);
						}
						
						logger.log(Level.INFO, "resources      : " + resources);
						if (resources != null)
							logger.log(Level.INFO, "resources size : " + resources.size());
						
						if(resources.size()>0)
						{
							for(GCUBEGenericResource resource : resources)
							{
								resource.setDescription(Long.toString(new Date().getTime()));
								String serialization=BridgeHelper.updateFieldSerialization(resource.getBody(), field,  searchables, presentables,
										updateFields, updateSearchables, updatePresentables);
								
								logger.log(Level.INFO, "1.####################################");
								logger.log(Level.INFO, "field ID   : " + field.getID());
								logger.log(Level.INFO, "field Name : " + field.getName());
								logger.log(Level.INFO, serialization);
								logger.log(Level.INFO, "field Searchables  : " + field.getSearchables());
								logger.log(Level.INFO, "field Presentables : " + field.getPresentables());
								logger.log(Level.INFO, "searchables  : " + searchables);
								logger.log(Level.INFO, "presentables : " + presentables);
								logger.log(Level.INFO, "updateFields  : " + updateFields);
								logger.log(Level.INFO, "updateSearchables : " + updateSearchables);
								logger.log(Level.INFO, "updatePresentables : " + updatePresentables);
								
								logger.log(Level.INFO, "1.####################################");
								
								String scopes="(";
								for(GCUBEScope s : BridgeHelper.getFieldModelScopes()) scopes+=s+" ";
								scopes+=")";
								logger.log(Level.FINE, "updating resource serialization for field " + field.getName() + " (" + field.getID() + ")" + " in scope "+scopes+" to :\n"+serialization);
								resource.setBody(serialization);
								try
								{
									BridgeHelper.publishFieldResource(resource, false);
								}catch(Exception ex)
								{
									throw new ResourceRegistryException("could not publish remote field profile", ex);
								}
							}
						}
						else
						{
							GCUBEGenericResource resource =null;
							try
							{
								resource =GHNContext.getImplementation(GCUBEGenericResource.class);
							}catch(Exception ex)
							{
								throw new ResourceRegistryException("could not retrieve generic resource instance", ex);
							}
							resource.addScope(BridgeHelper.getFieldModelScopes());
							resource.setName(RRModelGenericResourceName+"."+field.getID());
							resource.setSecondaryType(RRModelGenericResourceSecondaryType);
							resource.setDescription(Long.toString(new Date().getTime()));
							String serialization=BridgeHelper.buildFieldSerialization(field,searchables,presentables);
							
							
							logger.log(Level.INFO, "2.####################################");
							logger.log(Level.INFO, "field ID   : " + field.getID());
							logger.log(Level.INFO, "field Name : " + field.getName());
							logger.log(Level.INFO, serialization);
							logger.log(Level.INFO, "field Searchables  : " + field.getSearchables());
							logger.log(Level.INFO, "field Presentables : " + field.getPresentables());
							logger.log(Level.INFO, "searchables  : " + searchables);
							logger.log(Level.INFO, "presentables : " + presentables);
							logger.log(Level.INFO, "updateFields  : " + updateFields);
							logger.log(Level.INFO, "updateSearchables : " + updateSearchables);
							logger.log(Level.INFO, "updatePresentables : " + updatePresentables);
							logger.log(Level.INFO, "2.####################################");
							
							
							String scopes="(";
							for(GCUBEScope s : BridgeHelper.getFieldModelScopes()) scopes+=s+" ";
							scopes+=")";
							logger.log(Level.FINE, "adding resource serialization for field " + field.getName() + " (" + field.getID() + ")" + " in scope "+scopes+" to :\n"+serialization);
							resource.setBody(serialization);
							try
							{
								BridgeHelper.publishFieldResource(resource, true);
							}catch(Exception ex)
							{
								throw new ResourceRegistryException("could not publish remote field profile", ex);
							}
						}
						logger.log(Level.INFO, "finished updating gcube generic resource");
					}
					catch(ResourceRegistryException e) 
					{ 
						re = e;
						logger.log(Level.WARNING, "Error creating/updating gcube generic resource for field " + ((FieldDao)f).getName() + "(" + ((FieldDao)f).getID() + ")");  
					}
				}
			}
			
			if(updateMetadata)
			{
				logger.log(Level.INFO, "updating element metadata gcube generic resource");
				resources=null;
				try
				{
					resources=BridgeHelper.getPublishedMetadataResources();
				}catch(Exception ex)
				{
					throw new ResourceRegistryException("could not retrieve remote element metadata", ex);
				}
				if(resources.size()>0)
				{
					for(GCUBEGenericResource resource : resources)
					{
						resource.setDescription(Long.toString(new Date().getTime()));
						String serialization=BridgeHelper.buildElementMetadataSerialization(metadata);
						String scopes="(";
						for(GCUBEScope s : BridgeHelper.getFieldModelScopes()) scopes+=s+" ";
						scopes+=")";
						logger.log(Level.FINE, "updating element metadata resource serialization in scope "+scopes+" to :\n"+serialization);
						resource.setBody(serialization);
						try
						{
							BridgeHelper.publishFieldResource(resource, false);
						}catch(Exception ex)
						{
							throw new ResourceRegistryException("could not publish remote element metadata", ex);
						}
					}
				}
				else
				{
					GCUBEGenericResource resource =null;
					try
					{
						resource =GHNContext.getImplementation(GCUBEGenericResource.class);
					}catch(Exception ex)
					{
						throw new ResourceRegistryException("could not retrieve generic resource instance", ex);
					}
					resource.addScope(BridgeHelper.getFieldModelScopes());
					resource.setName(RRModelGenericResourceName+".Metadata");
					resource.setSecondaryType(RRModelGenericResourceSecondaryType);
					resource.setDescription(Long.toString(new Date().getTime()));
					String serialization=BridgeHelper.buildElementMetadataSerialization(metadata);
					String scopes="(";
					for(GCUBEScope s : BridgeHelper.getFieldModelScopes()) scopes+=s+" ";
					scopes+=")";
					logger.log(Level.FINE, "adding element metadata resource serialization in scope "+scopes+" to :\n"+serialization);
					resource.setBody(serialization);
					try
					{
						BridgeHelper.publishFieldResource(resource, true);
					}catch(Exception ex)
					{
						throw new ResourceRegistryException("could not publish remote field profiles", ex);
					}
				}
				logger.log(Level.INFO, "finished updating element metadata gcube generic resource");	
				
			}
			
			if(updateConfig)
			{
				logger.log(Level.INFO, "updating static configuration gcube generic resource");
				resources=null;
				try
				{
					resources=BridgeHelper.getPublishedStaticConfigResources();
				}catch(Exception ex)
				{
					throw new ResourceRegistryException("could not retrieve remote static configuration", ex);
				}
				if(resources.size()>0)
				{
					for(GCUBEGenericResource resource : resources)
					{
						resource.setDescription(Long.toString(new Date().getTime()));
						String serialization=BridgeHelper.buildStaticConfigSerialization(staticConfig);
						String scopes="(";
						for(GCUBEScope s : BridgeHelper.getFieldModelScopes()) scopes+=s+" ";
						scopes+=")";
						logger.log(Level.FINE, "updating static configuration resource serialization in scope "+scopes+" to :\n"+serialization);
						resource.setBody(serialization);
						try
						{
							BridgeHelper.publishFieldResource(resource, false);
						}catch(Exception ex)
						{
							throw new ResourceRegistryException("could not publish remote element metadata", ex);
						}
					}
				}
				else
				{
					GCUBEGenericResource resource =null;
					try
					{
						resource =GHNContext.getImplementation(GCUBEGenericResource.class);
					}catch(Exception ex)
					{
						throw new ResourceRegistryException("could not retrieve generic resource instance", ex);
					}
					resource.addScope(BridgeHelper.getFieldModelScopes());
					resource.setName(RRModelGenericResourceName+".StaticConfig");
					resource.setSecondaryType(RRModelGenericResourceSecondaryType);
					resource.setDescription(Long.toString(new Date().getTime()));
					String serialization=BridgeHelper.buildStaticConfigSerialization(staticConfig);
					String scopes="(";
					for(GCUBEScope s : BridgeHelper.getFieldModelScopes()) scopes+=s+" ";
					scopes+=")";
					logger.log(Level.FINE, "adding static configuration resource serialization in scope "+scopes+" to :\n"+serialization);
					resource.setBody(serialization);
					try
					{
						BridgeHelper.publishFieldResource(resource, true);
					}catch(Exception ex)
					{
						throw new ResourceRegistryException("could not publish remote static configuration", ex);
					}
				}
				logger.log(Level.INFO, "finished updating static configuration gcube generic resource");	
				
			}
			
			
			if(re!=null)
				throw re;
		}catch(Exception ex)
		{
			throw new ResourceRegistryException("could not bridge outgoing elements", ex);
		}
	}
}
