/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.rr.bridge;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.execution.rr.bridge.BridgeHelper;
import org.gcube.execution.rr.bridge.GCubeRepositoryProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FieldModel {
    private static Logger logger = Logger.getLogger(FieldModel.class.getName());
    private static GenericResource mainResource;
    private static Map<String, GenericResource> fieldResources;
    private static GenericResource metadataResource;
    private static GenericResource staticConfigResource;
    private static Set<String> fieldIds;

    private static GenericResource getMostRecentResource(List<GenericResource> resources) throws Exception {
        long mostRecentTime = -1L;
        GenericResource mostRecentResource = null;
        for (GenericResource resource : resources) {
            long updateTime = 0L;
            try {
                updateTime = Long.parseLong(resource.profile().description());
            }
            catch (Exception ex) {
                continue;
            }
            if (updateTime <= mostRecentTime) continue;
            mostRecentResource = resource;
        }
        return mostRecentResource;
    }

    private static void processResources(Map<String, Map<String, GenericResource>> resources) throws Exception {
        HashSet<String> fieldResourceIds = new HashSet<String>();
        HashSet<String> fieldIdsInDirectory = new HashSet<String>();
        ArrayList<GenericResource> mainResources = new ArrayList<GenericResource>();
        for (Map<String, GenericResource> resourcesInScope : resources.values()) {
            GenericResource mainResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName);
            if (mainResource == null) continue;
            mainResources.add(mainResource);
        }
        mainResource = FieldModel.getMostRecentResource(mainResources);
        boolean foundDirectory = false;
        Document fieldsDOM = null;
        if (mainResource != null && FieldModel.getStringOfElement(mainResource.profile().body()) != null && FieldModel.getStringOfElement(mainResource.profile().body()).trim().length() != 0) {
            fieldsDOM = XMLUtils.Deserialize((String)FieldModel.getStringOfElement(mainResource.profile().body()));
            foundDirectory = true;
        }
        if (foundDirectory) {
            boolean flatModel = false;
            List xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fields"), (String)"field");
            if (xmlObjs.size() != 0) {
                flatModel = true;
            } else {
                xmlObjs = XMLUtils.GetChildElementsWithName((Node)XMLUtils.GetChildElementWithName((Node)fieldsDOM.getDocumentElement(), (String)"fields"), (String)"fieldId");
            }
            for (Element element : xmlObjs) {
                if (!flatModel) {
                    fieldIdsInDirectory.add(element.getFirstChild().getNodeValue());
                    continue;
                }
                fieldIdsInDirectory.add(XMLUtils.GetChildElementWithName((Node)element, (String)"id").getFirstChild().getNodeValue());
            }
            fieldIds.addAll(fieldIdsInDirectory);
        }
        ArrayList<GenericResource> metadataResources = new ArrayList<GenericResource>();
        for (Map<String, GenericResource> resourcesInScope : resources.values()) {
            GenericResource genericResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName + ".Metadata");
            if (genericResource == null) continue;
            metadataResources.add(genericResource);
        }
        metadataResource = FieldModel.getMostRecentResource(metadataResources);
        ArrayList<GenericResource> staticConfigResources = new ArrayList<GenericResource>();
        for (Map map : resources.values()) {
            GenericResource staticConfigResource = (GenericResource)map.get(GCubeRepositoryProvider.RRModelGenericResourceName + ".StaticConfig");
            if (staticConfigResource == null) continue;
            staticConfigResources.add(staticConfigResource);
        }
        logger.info("found : " + staticConfigResources.size() + " staticconfig resources ");
        staticConfigResource = FieldModel.getMostRecentResource(staticConfigResources);
        if (foundDirectory) {
            for (Map map : resources.values()) {
                for (Map.Entry r : map.entrySet()) {
                    if (!((String)r.getKey()).startsWith(GCubeRepositoryProvider.RRModelGenericResourceName + ".")) continue;
                    fieldResourceIds.add(((GenericResource)r.getValue()).profile().name().substring(((GenericResource)r.getValue()).profile().name().indexOf(".") + 1));
                }
            }
            for (String string : fieldResourceIds) {
                if (!fieldIdsInDirectory.contains(string)) continue;
                ArrayList<GenericResource> fieldResources = new ArrayList<GenericResource>();
                for (Map<String, GenericResource> resourcesInScope : resources.values()) {
                    GenericResource fieldResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName + "." + string);
                    if (fieldResource == null) continue;
                    fieldResources.add(fieldResource);
                }
                GenericResource fr = FieldModel.getMostRecentResource(fieldResources);
                if (fr == null) continue;
                FieldModel.fieldResources.put(string, fr);
            }
        }
    }

    public static void retrieve() throws Exception {
        mainResource = null;
        fieldResources = new HashMap<String, GenericResource>();
        metadataResource = null;
        staticConfigResource = null;
        fieldIds = new HashSet<String>();
        List<String> scopes = BridgeHelper.getFieldModelScopes();
        HashMap<String, Map<String, GenericResource>> resources = new HashMap<String, Map<String, GenericResource>>();
        for (String scope : scopes) {
            logger.info("Retrieving field model generic resources in scope " + scope.toString());
            ScopeProvider.instance.set(scope.toString());
            XQuery query = ICFactory.queryFor(GenericResource.class);
            query.addCondition("$resource/Profile/SecondaryType/text() eq '" + GCubeRepositoryProvider.RRModelGenericResourceName + "'");
            DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
            List res = client.submit((Query)query);
            if (!resources.containsKey(scope.toString())) {
                resources.put(scope.toString(), new HashMap());
            }
            for (GenericResource r : res) {
                ((Map)resources.get(scope.toString())).put(r.profile().name(), r);
            }
        }
        FieldModel.processResources(resources);
        logger.info("Processed field model generic resources: " + (mainResource != null ? "1" : "0") + " field directory resources containing " + fieldIds.size() + " field references, " + fieldResources.keySet().size() + " field resources, " + (metadataResource != null ? "1" : "0") + " element metadata resources, " + (staticConfigResource != null ? "1" : "0") + " static configuration resources.");
    }

    public static String getMainResource() {
        if (mainResource == null || FieldModel.getStringOfElement(mainResource.profile().body()) == null || FieldModel.getStringOfElement(mainResource.profile().body()).trim().length() == 0) {
            return null;
        }
        return FieldModel.getStringOfElement(mainResource.profile().body());
    }

    public static String getMetadataResource() {
        if (metadataResource == null || FieldModel.getStringOfElement(metadataResource.profile().body()) == null || FieldModel.getStringOfElement(metadataResource.profile().body()).trim().length() == 0) {
            return null;
        }
        return FieldModel.getStringOfElement(metadataResource.profile().body());
    }

    public static String getStaticConfigResource() {
        if (staticConfigResource == null || FieldModel.getStringOfElement(staticConfigResource.profile().body()) == null || FieldModel.getStringOfElement(staticConfigResource.profile().body()).trim().length() == 0) {
            return null;
        }
        return FieldModel.getStringOfElement(staticConfigResource.profile().body());
    }

    public static Set<String> getFieldIds() {
        return fieldIds;
    }

    public static String getFieldResource(String id) {
        GenericResource fieldResource = fieldResources.get(id);
        if (fieldResource == null || FieldModel.getStringOfElement(fieldResource.profile().body()) == null || FieldModel.getStringOfElement(fieldResource.profile().body()).trim().length() == 0) {
            return null;
        }
        return FieldModel.getStringOfElement(fieldResource.profile().body());
    }

    public static String getStringOfElement(Element el) {
        XPathHelper xpath = new XPathHelper((Node)el);
        String text = (String)xpath.evaluate("/").get(0);
        text = text.substring("<doc>".length());
        text = text.substring(0, text.length() - "</doc>".length());
        return text;
    }

    static {
        fieldResources = new HashMap<String, GenericResource>();
        fieldIds = new HashSet<String>();
    }
}

