package org.gcube.execution.rr.bridge;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;
import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.rr.RRContext.DatastoreType;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.access.InMemoryStore;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.config.StaticConfigurationDao;
import gr.uoa.di.madgik.rr.element.data.DataCollection;
import gr.uoa.di.madgik.rr.element.data.DataCollectionDao;
import gr.uoa.di.madgik.rr.element.data.DataLanguage;
import gr.uoa.di.madgik.rr.element.execution.ExecutionServerDao;
import gr.uoa.di.madgik.rr.element.execution.ExecutionServiceDao;
import gr.uoa.di.madgik.rr.element.execution.SearchServiceDao;
import gr.uoa.di.madgik.rr.element.execution.WorkflowServiceDao;
import gr.uoa.di.madgik.rr.element.functionality.Functionality;
import gr.uoa.di.madgik.rr.element.functionality.FunctionalityDao;
import gr.uoa.di.madgik.rr.element.infra.HostingNode;
import gr.uoa.di.madgik.rr.element.infra.HostingNodeDao;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadata;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadataDao;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.FieldDao;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.PresentableDao;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import gr.uoa.di.madgik.rr.element.search.SearchableDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceService;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.FTIndex;
import gr.uoa.di.madgik.rr.element.search.index.FTIndexDao;
import gr.uoa.di.madgik.rr.element.search.index.FTIndexService;
import gr.uoa.di.madgik.rr.element.search.index.FTIndexServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainer;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainerDao;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSource;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceDao;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceService;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceServiceDao;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.commons.lang.StringEscapeUtils;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GCoreEndpoint.Profile.Endpoint;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.HostingNode.Profile.DeployedPackage;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceInstance;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.resources.gcore.utils.XPathHelper;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.execution.rr.configuration.ConfigurationProviderLoader;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BridgeHelper
{
	private static Logger logger=Logger.getLogger(BridgeHelper.class.getName());
	
	private static List<String> scopes = null;
	private static List<String> searchSystemScopes = null;
	private static Set<IDaoElement> searchSystemServices = null;
	
	public static void initializeIndexTypes()
	{
		DataSource.clearSubTypes();
		DataSource.addSubType(DataSource.Type.FullTextIndex, FTIndex.class, FTIndexDao.class);
//		DataSource.addSubType(DataSource.Type.ForwardIndex, FWIndex.class, FWIndexDao.class);
//		DataSource.addSubType(DataSource.Type.GeoIndex, GeoIndex.class, GeoIndexDao.class);
		DataSource.addSubType(DataSource.Type.OpenSearch, OpenSearchDataSource.class, OpenSearchDataSourceDao.class);
		
		DataSourceService.clearSubTypes();
		DataSourceService.addSubType(DataSourceService.Type.FullTextIndex, FTIndexService.class, FTIndexServiceDao.class);
//		DataSourceService.addSubType(DataSourceService.Type.ForwardIndex, FWIndexService.class, FWIndexServiceDao.class);
//		DataSourceService.addSubType(DataSourceService.Type.GeoIndex, GeoIndexService.class, GeoIndexServiceDao.class);
		DataSourceService.addSubType(DataSourceService.Type.OpenSearch, OpenSearchDataSourceService.class, OpenSearchDataSourceServiceDao.class);
	}
	
	public static void initializeIndexTypes(Properties config) throws ResourceRegistryException
	{
		try 
		{
			int count=Integer.parseInt(config.getProperty("dataSourceSubTypesCount","0"));
			if(count!=0) 
			{
				DataSource.clearSubTypes();
				Set<String> res=new HashSet<String>(count);
				for(int i=0;i<count;i+=1)
				{
					String type, key, value;
					if((type = config.getProperty("dataSourceSubTypesType."+i)) == null) throw new ResourceRegistryException("Could not read datasource type #"+i);
					if((key = config.getProperty("dataSourceSubTypesKey."+i)) == null) throw new ResourceRegistryException("Could not read datasource class name #"+i);
					if((value = config.getProperty("dataSourceSubTypesValue."+i)) ==  null) throw new ResourceRegistryException("Could not read datasource dao class name #"+i);
					DataSource.addSubType(DataSource.Type.valueOf(type), (Class<? extends DataSource>)Class.forName(key), 
					(Class<? extends DataSourceDao>)Class.forName(value));
					logger.log(Level.INFO, "Adding DataSource type: " + type + "-" + key + "-" + value);
				}
			}
			count=Integer.parseInt(config.getProperty("dataSourceServiceSubTypesCount", "0"));
			if(count!=0)
			{
				DataSourceService.clearSubTypes();
				Set<String> res=new HashSet<String>(count);
				for(int i=0;i<count;i+=1)
				{
					String type, key, value;
					if((type = config.getProperty("dataSourceServiceSubTypesType."+i)) == null) throw new ResourceRegistryException("Could not read datasource service type #"+i);
					if((key = config.getProperty("dataSourceServiceSubTypesKey."+i)) == null) throw new ResourceRegistryException("Could not read datasource service class name #"+i);
					if((value = config.getProperty("dataSourceServiceSubTypesValue."+i)) ==  null) throw new ResourceRegistryException("Could not read datasource service dao class name #"+i);
					DataSourceService.addSubType(DataSourceService.Type.valueOf(type), (Class<? extends DataSourceService>)Class.forName(key), 
					(Class<? extends DataSourceServiceDao>)Class.forName(value));
					logger.log(Level.INFO, "Adding DataSource service type: " + type + "-" + key + "-" + value);
				}
			}
		}catch(Exception e)
		{
			throw new ResourceRegistryException("Error while initializing datasource types", e);
		}
	}
	
	public static void retrieveScopes() throws Exception
	{		
		if(isClientMode())
			retrieveScopesOffline();
		else
			retrieveScopesOnline();
		
		if(logger.isLoggable(Level.INFO))
		{
			StringBuilder logScopes = new StringBuilder();
			for(String scope : BridgeHelper.scopes)
			{
				logScopes.append(scope.toString());
				logScopes.append(" ");
			}
			logger.log(Level.INFO, "Scopes: " + logScopes.toString());
		}
		searchSystemServices = retrieveSearchService();
		Set<String> searchSystemScopeSet = new HashSet<String>();
		for(IDaoElement searchSystemService : searchSystemServices)
			searchSystemScopeSet.addAll(((SearchServiceDao)searchSystemService).scopes);
		searchSystemScopes = new ArrayList<String>();
		int i=0;
		logger.log(Level.INFO, "searchSystemScopeSet contains : " + searchSystemScopeSet);
		for(String s : searchSystemScopeSet)
			searchSystemScopes.add(s);
	}
	
	public static List<String> getFieldModelScopes() throws Exception
	{
		Set<String> fieldScopes = new HashSet<String>();
		for(String scope : BridgeHelper.searchSystemScopes)
		{
			ScopeBean bean = new ScopeBean(scope);
			
			if (bean.is(ScopeBean.Type.INFRASTRUCTURE))
			{
				logger.log(Level.INFO, scope + " is infra scope");
				continue;
			}
			if(bean.is(ScopeBean.Type.VO))
				logger.log(Level.INFO, scope + " is a VO scope");
			else if (bean.is(ScopeBean.Type.VRE))
				logger.log(Level.INFO, scope + " is a VRE scope. Will add : " + bean.enclosingScope().toString());
				
			if(bean.is(ScopeBean.Type.VO))
				fieldScopes.add(scope);
			else if(bean.is(ScopeBean.Type.VRE))
				fieldScopes.add(bean.enclosingScope().toString());
		}
		List<String> gCubeScopes = new ArrayList<String>();
		
		logger.log(Level.FINE, "#### searchSystemScopes : " + BridgeHelper.searchSystemScopes);
		logger.log(Level.FINE, "#### FieldModelScopes   : " + fieldScopes);
		
		for(String scope : fieldScopes)
			gCubeScopes.add(scope);
		//if(gCubeScopes.size()==0) return BridgeHelper.scopes;
		return gCubeScopes;
	}
	
	private static void retrieveScopesOnline() throws Exception
	{
		List<String> tmpScopes = getGHNContextScopes();

		logger.log(Level.INFO, "retrieveScopesOnline : " + tmpScopes);
		
		List<String> toKeepScopes = new ArrayList<String>();
		for(String scope : tmpScopes)
		{
			ScopeBean bean = new ScopeBean(scope);
			
			if(!bean.is(ScopeBean.Type.INFRASTRUCTURE))
				toKeepScopes.add(scope);
		}
		
		logger.log(Level.INFO, "retrieveScopesOnline after additions : " + toKeepScopes);
		BridgeHelper.scopes = new ArrayList<String>(toKeepScopes);// toKeepScopes.toArray(new GCUBEScope[0]);
	}
	
	private static void retrieveScopesOffline() throws Exception
	{
		List<String> scopes = getGHNContextStartScopes();
		
		logger.log(Level.INFO, "retrieveScopesOffline : " + scopes);
		List<GenericResource> resources = BridgeHelper.getPublishedVREResources();
		for(GenericResource resource : resources)
		{
			String retrievedScope = BridgeHelper.getVREScope(resource);
			if(retrievedScope != null)
				scopes.add(retrievedScope);
		}
		
		logger.log(Level.INFO, "retrieveScopesOffline after additions : " + scopes);
	
		BridgeHelper.scopes = new ArrayList<String>(scopes);
	}
	
	private static List<GenericResource> getPublishedVREResources() throws Exception
	{
		
		logger.log(Level.INFO,"Searching for publised VRE resouces");
		
		List<GenericResource> resources = new ArrayList<GenericResource>();
		
		List<String> scopes = getGHNContextStartScopes();

		logger.log(Level.INFO, "getPublishedVREResources : " + scopes);
		
		Set<String> voScopes = getVOScopes(scopes);
		
		for(String scope : voScopes) {
			
			ScopeProvider.instance.set(scope.toString());
			SimpleQuery query = queryFor(GenericResource.class);
			
			query.addCondition("$resource/Profile/SecondaryType/text() eq '" + "VRE" + "'");
			
			
			logger.log(Level.INFO, "query      : " + query.toString());
			logger.log(Level.INFO, "query expr : " + query.expression());
			
			DiscoveryClient<GenericResource> client = clientFor(GenericResource.class);
			 
			resources.addAll(client.submit(query));
			
		
		}

		return resources;
	}
	
	private static String getVREScope(GenericResource resource) throws Exception
	{
		if (resource != null && resource.scopes() != null && resource.scopes().size()>0)
			return (String) resource.scopes().toArray()[0];
		else
			return null;
		
//		Document doc = null;
//		if(resource != null && 
//				resource.getBody()!=null && 
//				resource.getBody().trim().length()!=0) doc = XMLUtils.Deserialize("<root>" + resource.getBody() + "</root>");
//			else return null;
//		
//		    return XMLUtils.GetChildElementWithName(doc.getDocumentElement(), "Scope").getFirstChild().getNodeValue();
	}
	
	public static Set<IDaoElement> getElement(Class<?> type) throws Exception
	{
		if(type.equals(FieldDao.class)) return getFields();
		else if(type.equals(PresentableDao.class)) return getPresentables();
		else if(type.equals(SearchableDao.class)) return getSearchables();
		else if(type.equals(DataCollectionDao.class)) return getAllCollections();
		else if(type.equals(HostingNodeDao.class)) return getHostingNodes();
		else if(type.equals(FunctionalityDao.class)) return getFunctionality();
		else if(type.equals(ExecutionServerDao.class)) return getExecutionServer();
		else if(type.equals(ExecutionServiceDao.class)) return new HashSet<IDaoElement>(); //covered by the server case
		else if(type.equals(WorkflowServiceDao.class)) return getWorkflowService();
		else if(type.equals(FieldIndexContainerDao.class)) return new HashSet<IDaoElement>(); //covered by the Index cases
		else if(type.equals(FTIndexDao.class)) return getDataSourceFT();
//		else if(type.equals(FWIndexDao.class)) return getFWIndex();
//		else if(type.equals(GeoIndexDao.class)) return getGeoIndex();
		else if(type.equals(OpenSearchDataSourceDao.class)) return getOpenSearchDataSource(); //covered by the Index cases
		else if(type.equals(FTIndexServiceDao.class)) return new HashSet<IDaoElement>(); //covered by the Index cases
//		else if(type.equals(FWIndexServiceDao.class)) return new HashSet<IDaoElement>(); //covered by the Index cases
//		else if(type.equals(GeoIndexServiceDao.class)) return new HashSet<IDaoElement>(); //covered by the Index cases
		else if(type.equals(OpenSearchDataSourceServiceDao.class)) return new HashSet<IDaoElement>(); //covered by the Index cases
		else if(type.equals(ElementMetadataDao.class)) return getElementMetadata();
		else if(type.equals(StaticConfigurationDao.class)) return getStaticConfiguration();
		throw new ResourceRegistryException("unrecognized element type "+type);
	}
	
	
	private static Set<IDaoElement> getDataSource(String className, String serviceClassName, String serviceClass, String serviceName, String functionality, 
			DataSource.Type type, String description) throws Exception
	{
		List<String> scopes = BridgeHelper.scopes;
		logger.log(Level.WARNING,"### getting datasources from scopes : " + scopes);
		
		
		Map<String, DataSourceDao> datasourceItems=new HashMap<String, DataSourceDao>();
		Map<String, DataSourceServiceDao> datasourceServiceItems=new HashMap<String, DataSourceServiceDao>();
		
		Set<FieldIndexContainerDao> fieldItems=new HashSet<FieldIndexContainerDao>();
		for(String scope : scopes)
		{
			logger.log(Level.INFO,"Searching for " + description + " indexes in scope "+scope.toString());
			
			ScopeProvider.instance.set(scope.toString());
			SimpleQuery query = queryFor(ServiceInstance.class);
			
			query.addCondition("$resource/Data/gcube:ServiceClass/text() eq '" + serviceClass + "'")
				.addCondition("$resource/Data/gcube:ServiceName/text() eq '" + serviceName + "'");
			
			
			logger.log(Level.INFO, "query      : " + query.toString());
			logger.log(Level.INFO, "query expr : " + query.expression());
			
			DiscoveryClient<ServiceInstance> client = clientFor(ServiceInstance.class);
			 
			List<ServiceInstance> resources = client.submit(query);
			
			
			logger.log(Level.INFO,"found  " + resources.size() + " " + description +  "  in scope "+scope.toString());
			 
			for (ServiceInstance r : resources) {
				logger.log(Level.INFO,"resource key : " + r.key() + " datasourcetimes : " + datasourceItems + " scope : " + scope);
				
				if(r.key()==null) continue;
				String key=r.key();
				
				if(datasourceItems.containsKey(key)) 
				{
					for (String datasourceScope : r.properties().scopes()) {
						logger.log(Level.FINE, "adding scope : " + datasourceScope);
						datasourceItems.get(key).getScopes().add(datasourceScope);
						datasourceServiceItems.get(key).getScopes().add(datasourceScope);
					}
					
					datasourceItems.get(key).getScopes().add(scope.toString()); 
					datasourceServiceItems.get(key).getScopes().add(scope.toString()); //If the IS was queried in VRE scope, it will return all
				}
				else
				{
					
					DataSourceServiceDao ss = (DataSourceServiceDao)Class.forName(serviceClassName).newInstance();
					ss.setID(key);
					ss.setType(type.toString());
					ss.getDataSources().add(key);
					
					logger.log(Level.FINE, "------- endpoint : " + r.endpoint().toString());
					ss.setEndpoint(r.endpoint().toString());
					
					ss.setFunctionality(functionality);
					ss.setHostingNode(r.properties().nodeId());
					
					ss.getScopes().addAll(r.properties().scopes());
					ss.getScopes().add(scope);
					
//					for(GCUBEScope sc : d.getScope()) ss.getScopes().add(sc.toString());
//					ss.getScopes().add(scope.toString()); //If the IS was queried in VRE scope, it will return all
//														  //sources deployed on VO scope, regardless of the fact that
//					 									  //they might not contain the VRE scope. For that
//					 									  //reason, the current scope is added to the source scopes
					ss.setTimestamp(Calendar.getInstance().getTimeInMillis());
					datasourceServiceItems.put(ss.getID(), ss);
					
					DataSourceDao s = (DataSourceDao)Class.forName(className).newInstance();
					//FTIndexServiceDao s=new FTIndexServiceDao();
					s.setID(key);
					s.setType(type.toString());
					s.setFunctionality(functionality);
					if(s.getBoundDataSourceServices() == null) s.setBoundDataSourceServices(new HashSet<String>());
					s.getBoundDataSourceServices().add(key);
					s.setTimestamp(Calendar.getInstance().getTimeInMillis());
				//	s.setHostingNode(d.getGHNID());
					s.getCapabilities().clear();
					
					XPathHelper xpath = new XPathHelper(r.properties().customProperties());
					for (String capability: xpath.evaluate("/doc/*[local-name()='SupportedRelations']/text()")) {
						s.getCapabilities().add(capability);
						
					}
//					NodeList supportedRels = r.properties().customProperties().getElementsByTagName("SupportedRelations");
//					for (int i = 0 ; i < supportedRels.getLength() ; i++ ){
//						String capability = supportedRels.item(i).getTextContent();
//					}
					
					
					//s.getCapabilities().addAll(d.evaluate("//SupportedRelations/text()"));
					
				//	s.getFields().clear();
					
					
					s.getScopes().addAll(r.properties().scopes());
					s.getScopes().add(scope);
//					for(GCUBEScope sc : d.getScope()) s.getScopes().add(sc.toString());
//					s.getScopes().add(scope.toString()); //If the IS was queried in VRE scope, it will return all
//														 //sources deployed on VO scope, regardless of the fact that
//														 //they might not contain the VRE scope. For that
//														 //reason, the current scope is added to the source scopes
//					List<String> ff=d.evaluate("//Fields/text()");
					Set<String> checkDups = new HashSet<String>();
					
					xpath = new XPathHelper(r.properties().customProperties());
					for (String f: xpath.evaluate("/doc/*[local-name()='Fields']/text()"))
					{
					
						logger.log(Level.FINE, "Custom properties f : " + f);
						String []fparts=f.split(":");
						if(fparts.length==6 && fparts[2].equals("s")) fparts[4] += ":" + fparts[5];
						if(fparts.length<4 || fparts.length>6 ) continue;
						if(fparts.length==6 && !fparts[2].equals("s")) continue;
						FieldIndexContainerDao fc=new FieldIndexContainerDao();
						fc.setID(s.getID()+":"+f);
						if(checkDups.contains(fc.getID()))
						{
							logger.log(Level.WARNING, "Duplicate field detected: " + fc.getID()); 
							continue;
						}
						checkDups.add(fc.getID());
						fc.setCollection(fparts[0]);
						fc.setLanguage(fparts[1]);
						
						 
						
						fc.setFieldType(fparts[2]);
						fc.setField(fparts[3]);
						//logger.log(Level.INFO, "Field : " + f + " language " + fparts[1]);
						
						if(fparts.length>=5) fc.setExpression(fparts[4]);
						s.getFields().add(fc.getID());
						fieldItems.add(fc);
					}
					logger.log(Level.INFO, "datasource : " + s.getID());
					logger.log(Level.INFO, "datasource fields : " + s.getFields());
					logger.log(Level.INFO, "datasource scopes : " + s.getScopes());
					
					//System.out.println("datasource scopes : " + s.getScopes());
					datasourceItems.put(s.getID(), s);
				}
			}
		}
			
//		for (DataSourceDao dsd : datasourceItems.values()) {
//			System.out.println(dsd.getScopes());
//		}
			
//			ISClient client =  GHNContext.getImplementation(ISClient.class);
//			WSResourceQuery query=client.getQuery(WSResourceQuery.class);
//			
//			
//			
//			
////			query.addAtomicConditions(new AtomicCondition("/Data/ServiceName","FullTextIndexLookup"));
////			query.addAtomicConditions(new AtomicCondition("/Data/ServiceClass","Index"));
////			query.addGenericCondition("$result/Data/child::*[local-name()='ServiceName']/string() eq 'FullTextIndexLookup' and $result/Data/child::*[local-name()='ServiceClass']/string() eq 'Index'");
//			query.addGenericCondition("$result//Data/child::*[local-name()='ServiceName']/string() eq '" + serviceName + "'");
//			query.addGenericCondition("$result//Data/child::*[local-name()='ServiceClass']/string() eq '" + serviceClass + "'");
//			List<RPDocument> inds=client.execute(query, scope);
			
		Set<IDaoElement> retValue=new HashSet<IDaoElement>();
		retValue.addAll(datasourceItems.values());
		retValue.addAll(datasourceServiceItems.values());
		retValue.addAll(fieldItems);
		return retValue;
	}
	
	
	
	
	
	
	private static Set<IDaoElement> getDataSourceFT() throws Exception
	{
		
		String className = FTIndexDao.class.getName();
		String serviceClassName = FTIndexServiceDao.class.getName();
		
		String functionality = "search.index.ft";
			
		List<String> scopes = BridgeHelper.scopes;
		logger.log(Level.WARNING,"### getting datasources from scopes : " + scopes);
		
		
		Map<String, DataSourceDao> datasourceItems=new HashMap<String, DataSourceDao>();
		Map<String, DataSourceServiceDao> datasourceServiceItems=new HashMap<String, DataSourceServiceDao>();
		
		Set<FieldIndexContainerDao> fieldItems=new HashSet<FieldIndexContainerDao>();
		for(String scope : scopes)
		{
			logger.log(Level.INFO,"Searching for fulltext indexes in scope "+scope.toString());
			
			ScopeProvider.instance.set(scope.toString());
			SimpleQuery query = queryFor(GenericResource.class);
			
			query.addCondition("$resource/Profile/SecondaryType/text() eq 'IndexResources'");
			
			logger.log(Level.INFO, "query      : " + query.toString());
			logger.log(Level.INFO, "query expr : " + query.expression());
			
			DiscoveryClient<GenericResource> client = clientFor(GenericResource.class);
			 
			List<GenericResource> resources = client.submit(query);
			
			
			logger.log(Level.INFO,"found  " + resources.size() + "  in scope "+scope.toString());
			 
			for (GenericResource r : resources) {
				String name = r.profile().name();
				
				String key = name.split("\\.")[1];
				
				logger.log(Level.INFO,"resource key : " + key + " datasourcetimes : " + datasourceItems + " scope : " + scope);
				
				if(key==null) continue;
				
				if(datasourceItems.containsKey(key)) 
				{
					for (String datasourceScope : r.scopes().asCollection()) {
						logger.log(Level.FINE, "adding scope : " + datasourceScope);
						datasourceItems.get(key).getScopes().add(datasourceScope);
						datasourceServiceItems.get(key).getScopes().add(datasourceScope);
					}
					
					datasourceItems.get(key).getScopes().add(scope.toString()); 
					datasourceServiceItems.get(key).getScopes().add(scope.toString()); //If the IS was queried in VRE scope, it will return all
				}
				else
				{
					DataSourceServiceDao ss = (DataSourceServiceDao)Class.forName(serviceClassName).newInstance();
					ss.setID(key);
					ss.setType(DataSource.Type.FullTextIndex.toString());
					ss.getDataSources().add(key);

					
					
					String hostname = null;
					String endpoint= null;
					String hostingnode= null;

					
					Element body = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(r.profile().bodyAsString().getBytes())).getDocumentElement();
					XPathHelper xpath = new XPathHelper(body);
					
					endpoint = getIndexServiceEndpoint(scope, hostname);
					hostingnode = getIndexServiceGHNId(scope, hostname);
					
					if  (xpath.evaluate("//hostname/text()").size() > 0) {
						hostname = xpath.evaluate("//hostname/text()").get(0);
						endpoint = getIndexServiceEndpoint(scope, hostname);
						hostingnode = getIndexServiceGHNId(scope, hostname);
					}
					
					Set<String> resourceScopes = new HashSet<String>();
					for (String resourceScope: xpath.evaluate("//scope/text()")) {
						resourceScopes.add(resourceScope);
					}
					
					logger.log(Level.INFO, "scopes of datasource : " + resourceScopes);
					
					
					logger.log(Level.FINE, "------- endpoint : " + endpoint);
					ss.setEndpoint(endpoint);
					
					ss.setFunctionality(functionality);
					ss.setHostingNode(hostingnode);
					
					ss.getScopes().addAll(resourceScopes);
					ss.getScopes().add(scope);
					ss.setTimestamp(Calendar.getInstance().getTimeInMillis());
					datasourceServiceItems.put(ss.getID(), ss);
					
					
					
					DataSourceDao s = (DataSourceDao)Class.forName(className).newInstance();
					//FTIndexServiceDao s=new FTIndexServiceDao();
					s.setID(key);
					s.setType(DataSource.Type.FullTextIndex.toString());
					s.setFunctionality(functionality);
					if(s.getBoundDataSourceServices() == null) s.setBoundDataSourceServices(new HashSet<String>());
					s.getBoundDataSourceServices().add(key);
					s.setTimestamp(Calendar.getInstance().getTimeInMillis());
				//	s.setHostingNode(d.getGHNID());
					s.getCapabilities().clear();
					for (String capability: xpath.evaluate("//supportedRelations/text()")) {
						capability = StringEscapeUtils.unescapeXml(capability);
						
						logger.log(Level.INFO, "capability found : " + capability);
						s.getCapabilities().add(capability);
						
					}
					
					
					s.getScopes().addAll(resourceScopes);
					s.getScopes().add(scope);
					Set<String> checkDups = new HashSet<String>();
					
					for (String f: xpath.evaluate("//fields/text()"))
					{
					
						logger.log(Level.FINE, "Custom properties f : " + f);
						String []fparts=f.split(":");
						if(fparts.length==6 && fparts[2].equals("s")) fparts[4] += ":" + fparts[5];
						if(fparts.length<4 || fparts.length>6 ) continue;
						if(fparts.length==6 && !fparts[2].equals("s")) continue;
						FieldIndexContainerDao fc=new FieldIndexContainerDao();
						fc.setID(s.getID()+":"+f);
						if(checkDups.contains(fc.getID()))
						{
							logger.log(Level.WARNING, "Duplicate field detected: " + fc.getID()); 
							continue;
						}
						checkDups.add(fc.getID());
						fc.setCollection(fparts[0]);
						fc.setLanguage(fparts[1]);
						
						 
						
						fc.setFieldType(fparts[2]);
						fc.setField(fparts[3]);
						logger.log(Level.INFO, "Field : " + f + " language " + fparts[1] + " collection : " + fparts[0]);
						
						if(fparts.length>=5) fc.setExpression(fparts[4]);
						s.getFields().add(fc.getID());
						fieldItems.add(fc);
					}
					logger.log(Level.INFO, "datasource : " + s.getID());
					logger.log(Level.INFO, "datasource fields : " + s.getFields());
					logger.log(Level.INFO, "datasource scopes : " + s.getScopes());
					
					//System.out.println("datasource scopes : " + s.getScopes());
					datasourceItems.put(s.getID(), s);
				}
			}
		}
			
//		for (DataSourceDao dsd : datasourceItems.values()) {
//			System.out.println(dsd.getScopes());
//		}
			
//			ISClient client =  GHNContext.getImplementation(ISClient.class);
//			WSResourceQuery query=client.getQuery(WSResourceQuery.class);
//			
//			
//			
//			
////			query.addAtomicConditions(new AtomicCondition("/Data/ServiceName","FullTextIndexLookup"));
////			query.addAtomicConditions(new AtomicCondition("/Data/ServiceClass","Index"));
////			query.addGenericCondition("$result/Data/child::*[local-name()='ServiceName']/string() eq 'FullTextIndexLookup' and $result/Data/child::*[local-name()='ServiceClass']/string() eq 'Index'");
//			query.addGenericCondition("$result//Data/child::*[local-name()='ServiceName']/string() eq '" + serviceName + "'");
//			query.addGenericCondition("$result//Data/child::*[local-name()='ServiceClass']/string() eq '" + serviceClass + "'");
//			List<RPDocument> inds=client.execute(query, scope);
			
		Set<IDaoElement> retValue=new HashSet<IDaoElement>();
		retValue.addAll(datasourceItems.values());
		retValue.addAll(datasourceServiceItems.values());
		retValue.addAll(fieldItems);
		return retValue;
	}
	
	
	private static String getIndexServiceEndpoint(String scope, String hostname){
		ScopeProvider.instance.set(scope);
		
		SimpleQuery query = queryFor(GCoreEndpoint.class);
		
		String serviceClass = "Index";
		String serviceName = "FullTextIndexNode";
		
		query.addCondition("$resource/Profile/ServiceClass/text() eq '" + serviceClass + "'")
		.addCondition("$resource/Profile/ServiceName/text() eq '" + serviceName + "'");
	
		logger.log(Level.INFO," query : " + query);
		
		
		DiscoveryClient<GCoreEndpoint> client = clientFor(GCoreEndpoint.class);
		
		List<GCoreEndpoint> insts = client.submit(query);
		
		for (GCoreEndpoint inst :  insts){
			if (inst != null && inst.profile() != null && inst.profile().endpointMap() != null){
				Endpoint epr = inst.profile().endpointMap().get(ENDPOINT_KEY);
				if (epr == null){
					logger.log(Level.INFO,"running instance : " + inst.id() + " has no indexservice epr");
					continue;
				}
				
				String riStatus = inst.profile().deploymentData().status();
				if (!riStatus.equalsIgnoreCase("ready")){
					logger.log(Level.INFO,"running instance : " + inst.id() + " is NOT ready");
					continue;
				}
				
				try {
					if (epr.uri().toASCIIString().toLowerCase().contains(hostname.toLowerCase())){
						
						logger.log(Level.INFO, "found epr for the hostname : " + hostname + " at : " + epr.uri().toASCIIString());
						
						return epr.uri().toASCIIString();
					} 
				} catch (Exception e) {
					logger.log(Level.WARNING, "error comparing the uri to the hostname");
				}
			}
		}
		
		logger.log(Level.WARNING, "not found epr for the hostname : " + hostname);
		
		return null;
	}
	
	private static String getIndexServiceGHNId(String scope, String hostname){
		ScopeProvider.instance.set(scope);
		
		SimpleQuery query = queryFor(GCoreEndpoint.class);
		
		String serviceClass = "Index";
		String serviceName = "FullTextIndexNode";
		
		query.addCondition("$resource/Profile/ServiceClass/text() eq '" + serviceClass + "'")
		.addCondition("$resource/Profile/ServiceName/text() eq '" + serviceName + "'");
	
		logger.log(Level.INFO," query : " + query);
		
		
		DiscoveryClient<GCoreEndpoint> client = clientFor(GCoreEndpoint.class);
		
		List<GCoreEndpoint> insts = client.submit(query);
		
		for (GCoreEndpoint inst :  insts){
			if (inst != null && inst.profile() != null && inst.profile().endpointMap() != null){
				Endpoint epr = inst.profile().endpointMap().get(ENDPOINT_KEY);
				if (epr == null){
					logger.log(Level.INFO,"running instance : " + inst.id() + " has no searchsystemservice epr");
					continue;
				}
				
				String riStatus = inst.profile().deploymentData().status();
				if (!riStatus.equalsIgnoreCase("ready")){
					logger.log(Level.INFO,"running instance : " + inst.id() + " is NOT ready");
					continue;
				}
				
				try {
					if (epr.uri().toASCIIString().toLowerCase().contains(hostname.toLowerCase())){
						
						logger.log(Level.INFO, "found ghnid for the hostname : " + hostname + " at : " + inst.profile().ghnId());
						
						return inst.profile().ghnId();
					}
				} catch (Exception e) {
					logger.log(Level.WARNING, "error comparing the uri to the hostname");
				}
			}
		}
		
		logger.log(Level.WARNING, "not found ghnid for the hostname : " + hostname);
		
		return null;
	}
	
//	private static Set<IDaoElement> getFTIndex() throws Exception
//	{
//		//DataSource.addSubType(DataSource.Type.FullTextIndex, FTIndexService.class, FTIndexServiceDao.class);
//		return getDataSource(FTIndexDao.class.getName(), FTIndexServiceDao.class.getName(), "Index", "FullTextIndexLookup", "search.index.ft", DataSource.Type.FullTextIndex, "full text");
//	}
	
	
	/*
	private static Set<IDaoElement> getFTIndex() throws Exception
	{
		
		logger.log(Level.INFO, "getting fulltext index");
		
		String functionality = "search.index.ft"; 
		DataSource.Type type = DataSource.Type.FullTextIndex;
		String description = "fulltext";
		
		
		List<String> scopes = BridgeHelper.scopes;
		logger.log(Level.WARNING,"### getting datasources from scopes : " + scopes);
		
		
		Map<String, DataSourceDao> datasourceItems=new HashMap<String, DataSourceDao>();
		Map<String, DataSourceServiceDao> datasourceServiceItems=new HashMap<String, DataSourceServiceDao>();
		
		Set<FieldIndexContainerDao> fieldItems=new HashSet<FieldIndexContainerDao>();
		for(String scope : scopes){
			logger.log(Level.WARNING,"### searching fulltext in scope " + scope);
			
			logger.log(Level.WARNING,"### calling ri discoverer " + scope);
			Set<String> endpoints = new RIDiscovererISimpl().discoverRunningInstances("FullTextIndexNode", "Index", "resteasy-servlet" ,scope);
			logger.log(Level.WARNING,"### ri discoverer returned enpoints : " + endpoints);
			
			logger.log(Level.WARNING,"### initializing harvester");
			ResourceHarvester<IndexResource> harvester = new ResourceHarvester<IndexResource>(scope);
			
			
			for (String endpoint : endpoints) {
				logger.log(Level.WARNING,"### getting resources for enpoint : " + endpoint);
				
				if (endpoint.endsWith("/"))
					endpoint = endpoint.substring(0, endpoint.length() - 2);
				
				try {
					Set<IndexResource> resources = harvester.getResources(endpoint, IndexResource.class);
					
					logger.log(Level.WARNING,"### harvester for enpoint : " + endpoint + " returned resources : " + resources.size());
					
					for (IndexResource resource : resources){
						
//							if (!scope.equalsIgnoreCase(resource.getScope())){
//								System.out.println("resource scopes not in given scope " + scope);
//								continue;
//							}
						
						
						String key=resource.getResourceID();
						
						
						if(datasourceItems.containsKey(key)){
							datasourceItems.get(key).getScopes().add(resource.getScope());
							datasourceServiceItems.get(key).getScopes().add(resource.getScope());
						
							datasourceItems.get(key).getScopes().add(scope);
							datasourceServiceItems.get(key).getScopes().add(scope);
						
						
						} else {
							
							DataSourceServiceDao ss = (DataSourceServiceDao)Class.forName(FTIndexServiceDao.class.getName()).newInstance();
							ss.setID(key);
							ss.setType(type.toString());
							ss.getDataSources().add(key);
							
							ss.setEndpoint(endpoint);
							
							ss.setFunctionality(functionality);
							//TODO: how to get HostingNode
							ss.setHostingNode("");
							
							ss.getScopes().add(resource.getScope());
							ss.getScopes().add(scope);
							
							ss.setTimestamp(Calendar.getInstance().getTimeInMillis());
							datasourceServiceItems.put(ss.getID(), ss);
							
							
							
							DataSourceDao s = (DataSourceDao)Class.forName(FTIndexDao.class.getName()).newInstance();
							s.setID(key);
							s.setType(type.toString());
							s.setFunctionality(functionality);
							
							if(s.getBoundDataSourceServices() == null) s.setBoundDataSourceServices(new HashSet<String>());
							s.getBoundDataSourceServices().add(key);
							s.setTimestamp(Calendar.getInstance().getTimeInMillis());
							
							s.getCapabilities().clear();

							
							s.getCapabilities().clear();
							s.getCapabilities().addAll(resource.getSupportedRelations());
							
							s.getScopes().add(scope);
							s.getScopes().add(resource.getScope());
							
							Set<String> checkDups = new HashSet<String>();
							
							for (String f: resource.getFields()){
								logger.log(Level.FINE, "Custom properties f : " + f);
								String []fparts=f.split(":");
								if(fparts.length==6 && fparts[2].equals("s")) fparts[4] += ":" + fparts[5];
								if(fparts.length<4 || fparts.length>6 ) continue;
								if(fparts.length==6 && !fparts[2].equals("s")) continue;
								FieldIndexContainerDao fc=new FieldIndexContainerDao();
								fc.setID(s.getID()+":"+f);
								if(checkDups.contains(fc.getID()))
								{
									logger.log(Level.WARNING, "Duplicate field detected: " + fc.getID()); 
									continue;
								}
								checkDups.add(fc.getID());
								fc.setCollection(fparts[0]);
								fc.setLanguage(fparts[1]);
								
								 
								
								fc.setFieldType(fparts[2]);
								fc.setField(fparts[3]);
								
								//logger.log(Level.INFO, "Field : " + f + " language " + fparts[1]);
								
								if(fparts.length>=5) fc.setExpression(fparts[4]);
								s.getFields().add(fc.getID());
								fieldItems.add(fc);
								
								logger.log(Level.INFO, "datasource : " + s.getID());
								logger.log(Level.INFO, "datasource fields : " + s.getFields());
								logger.log(Level.INFO, "datasource scopes : " + s.getScopes());
								
								//System.out.println("datasource scopes : " + s.getScopes());
								datasourceItems.put(s.getID(), s);
								
							}
							
							
						}
					}
				} catch (Exception e) {
					System.out.println("No resources found for endpoint : " + endpoint);
					logger.log(Level.SEVERE, "No resources found for endpoint : " + endpoint, e);
					e.printStackTrace();
				}
				
				
			}
			
		}
		
		
		
		
		//DataSource.addSubType(DataSource.Type.FullTextIndex, FTIndexService.class, FTIndexServiceDao.class);
//			return getDataSource(FTIndexDao.class.getName(), FTIndexServiceDao.class.getName(), "Index", "FullTextIndexNode", "search.index.ft", DataSource.Type.FullTextIndex, "full text");
		
		
		Set<IDaoElement> retValue=new HashSet<IDaoElement>();
		retValue.addAll(datasourceItems.values());
		retValue.addAll(datasourceServiceItems.values());
		retValue.addAll(fieldItems);
		return retValue;
		
	}*/
	
	private static Set<IDaoElement> getFakeFTIndex() throws Exception
	{
		
		//DataSource.addSubType(DataSource.Type.FullTextIndex, FTIndexService.class, FTIndexServiceDao.class);
		Map<String, DataSourceDao> datasourceItems=new HashMap<String, DataSourceDao>();
		Map<String, DataSourceServiceDao> serviceItems=new HashMap<String, DataSourceServiceDao>();
		Set<FieldIndexContainerDao> fieldItems=new HashSet<FieldIndexContainerDao>();
		
		FTIndexServiceDao ss =  new FTIndexServiceDao();
		ss.setID("1283-5c96-f869-172b");
		ss.setFunctionality("search.index.ft");
		ss.setHostingNode("FTIndexGHNOne");
		ss.setEndpoint("http://nowhere1.com/wsrf/index/fulltext");
		ss.getScopes().add("/no/scope/");
		ss.setTimestamp(Calendar.getInstance().getTimeInMillis());
		ss.setType(DataSource.Type.FullTextIndex.toString());
		serviceItems.put(ss.getID(), ss);
		
		FTIndexDao s = new FTIndexDao();
		s.setID("1283-5c96-f869-172b");
		s.setType(DataSource.Type.FullTextIndex.toString());
		s.setFunctionality("search.index.ft");
		
		s.getCapabilities().clear();
		s.getCapabilities().add("any");
		s.getFields().clear();
		s.getScopes().add("/no/scope/");
		List<String> ff=new ArrayList<String>();
		ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:title");
		ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:title");
		ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:source");
		ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:source");
		for(String f:ff)
		{
			String []fparts=f.split(":");
			if(fparts.length!=4) continue;
			FieldIndexContainerDao fc=new FieldIndexContainerDao();
			fc.setID(s.getID()+":"+f);
			fc.setCollection(fparts[0]);
			fc.setLanguage(fparts[1]);
			fc.setFieldType(fparts[2]);
			fc.setField(fparts[3]);
			s.getFields().add(fc.getID());
			fieldItems.add(fc);
		}
		datasourceItems.put(s.getID(), s);
		
		//////////////
		ss = new FTIndexServiceDao();
		ss.setID("768a-8ab8-1281-9812");
		ss.setType(DataSource.Type.FullTextIndex.toString());
		ss.setHostingNode("FTIndexGHNTwo");
		ss.setEndpoint("http://nowhere2.com/wsrf/index/fulltext");
		serviceItems.put(ss.getID(), ss);
		
		s = new FTIndexDao();
		s.setID("768a-8ab8-1281-9812");
		s.setType(DataSource.Type.FullTextIndex.toString());
		s.setFunctionality("search.index.ft");
		
		s.getCapabilities().clear();
		s.getCapabilities().add("any");
		
		s.getFields().clear();
		s.getScopes().add("/no/scope/");
		ff=new ArrayList<String>();
		ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:type");
		ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:type");
		for(String f:ff)
		{
			String []fparts=f.split(":");
			if(fparts.length!=4) continue;
			FieldIndexContainerDao fc=new FieldIndexContainerDao();
			fc.setID(s.getID()+":"+f);
			fc.setCollection(fparts[0]);
			fc.setLanguage(fparts[1]);
			fc.setFieldType(fparts[2]);
			fc.setField(fparts[3]);
			s.getFields().add(fc.getID());
			fieldItems.add(fc);
		}
		datasourceItems.put(s.getID(), s);
		///////////////////////
		Set<IDaoElement> retValue=new HashSet<IDaoElement>();
		retValue.addAll(datasourceItems.values());
		retValue.addAll(serviceItems.values());
		retValue.addAll(fieldItems);
		return retValue;
	}
	/*
	private static Set<IDaoElement> getFWIndex() throws Exception
	{
		logger.log(Level.INFO, "getting forward index");
		//DataSource.addSubType(DataSource.Type.ForwardIndex, FWIndexService.class, FWIndexServiceDao.class);
		//return getDataSource(FWIndexDao.class.getName(), FWIndexServiceDao.class.getName(),"Index", "ForwardIndexLookup", "search.index.fw",  DataSource.Type.ForwardIndex, "forward");
		return getDataSource(FWIndexDao.class.getName(), FWIndexServiceDao.class.getName(), "Index", "ForwardIndexNode", "search.index.fw", DataSource.Type.ForwardIndex, "forward index");
	}
	
	private static Set<IDaoElement> getGeoIndex() throws Exception
	{
		logger.log(Level.INFO, "getting geo index");
		//DataSource.addSubType(DataSource.Type.GeoIndex, GeoIndexService.class, GeoIndexServiceDao.class);
		return getDataSource(GeoIndexDao.class.getName(), GeoIndexServiceDao.class.getName(), "Index",  "GeoIndexLookup", "search.index.geo", DataSource.Type.GeoIndex, "geo");
	}*/
	
	private static Set<IDaoElement> getOpenSearchDataSource() throws Exception
	{
		logger.log(Level.INFO, "getting opensearch datasource");
		//DataSource.addSubType(DataSource.Type.OpenSearch, OpenSearchService.class, OpenSearchServiceDao.class);
		return getDataSource(OpenSearchDataSourceDao.class.getName(), OpenSearchDataSourceServiceDao.class.getName(),"OpenSearch", "OpenSearchDataSource",  "search.index.opensearch",  DataSource.Type.OpenSearch, "opensearch");
	}
	
	/*
	private static Set<IDaoElement> getFakeFWIndex() throws Exception
	{
		//DataSource.addSubType(DataSource.Type.ForwardIndex, FWIndexService.class, FWIndexServiceDao.class);
		
		Map<String, DataSourceDao> datasourceItems=new HashMap<String, DataSourceDao>();
		Map<String, DataSourceServiceDao> serviceItems=new HashMap<String, DataSourceServiceDao>();
		
		Set<FieldIndexContainerDao> fieldItems=new HashSet<FieldIndexContainerDao>();
		FWIndexServiceDao ss = new FWIndexServiceDao();
		ss.setID("8b77-1111-89b1-c128");
		ss.setType(DataSource.Type.ForwardIndex.toString());
		ss.setFunctionality("search.index.fw");
		ss.setHostingNode("FWIndexGHNOne");
		ss.setEndpoint("http://nowhere3.com/wsrf/index/forward");
		ss.getScopes().add("/no/scope/");
		serviceItems.put(ss.getID(), ss);
		
		FWIndexDao s = new FWIndexDao();
		s.setID("8b77-1111-89b1-c128");
		s.setType(DataSource.Type.ForwardIndex.toString());
		s.setFunctionality("search.index.fw");
		
		s.getCapabilities().clear();
		s.getCapabilities().add("any");
		
		s.getFields().clear();
		s.getScopes().add("/no/scope/");
		List<String> ff=new ArrayList<String>();
		ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:identifier");
		ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:identifier");
		for(String f:ff)
		{
			String []fparts=f.split(":");
			if(fparts.length!=4) continue;
			FieldIndexContainerDao fc=new FieldIndexContainerDao();
			fc.setID(s.getID()+":"+f);
			fc.setCollection(fparts[0]);
			fc.setLanguage(fparts[1]);
			fc.setFieldType(fparts[2]);
			fc.setField(fparts[3]);
			s.getFields().add(fc.getID());
			fieldItems.add(fc);
		}
		datasourceItems.put(s.getID(), s);
		////////////////////
		Set<IDaoElement> retValue=new HashSet<IDaoElement>();
		retValue.addAll(datasourceItems.values());
		retValue.addAll(fieldItems);
		return retValue;
		
		//return getDataSource(FWIndexServiceDao.class.getName(), "ForwardIndexLookup", "Index", "search.index.fw", "forward");
	}*/
	
	
	private static Set<IDaoElement> getWorkflowService() throws Exception 
	{
		List<String> scopes = BridgeHelper.scopes;
		Map<String,WorkflowServiceDao> serviceItems=new HashMap<String,WorkflowServiceDao>();
		
		for(String scope : scopes) {
			ScopeProvider.instance.set(scope.toString());
			SimpleQuery query = queryFor(GCoreEndpoint.class);
			
			String serviceName = "WorkflowEngineService";
			String serviceClass = "Execution";
			
			query.addCondition("$resource/Profile/ServiceClass/text() eq '" + serviceClass + "'")
			.addCondition("$resource/Profile/ServiceName/text() eq '" + serviceName + "'");
			
			
			DiscoveryClient<GCoreEndpoint> client = clientFor(GCoreEndpoint.class);
			
			List<GCoreEndpoint> insts = client.submit(query);
			
			logger.log(Level.INFO,"Found "+insts.size()+" workflow services in scope");
			
			for (GCoreEndpoint inst :  insts){
				Group<org.gcube.common.resources.gcore.GCoreEndpoint.Profile.Endpoint> eprs= inst.profile().endpoints();
				
				if(eprs.size()!=1) continue;
				
				Set<String> instScopes = new HashSet<String>();
				for (Object instSc : inst.scopes().toArray())
					instScopes.add((String) instSc);
				
				if (serviceItems.containsKey(inst.id())){
					serviceItems.get(inst.id()).getScopes().addAll(instScopes);
					
				} else {
					WorkflowServiceDao s=new WorkflowServiceDao();

					org.gcube.common.resources.gcore.GCoreEndpoint.Profile.Endpoint epr =  (Endpoint) eprs.toArray()[0];
					
					logger.log(Level.FINE, "---- WorkflowService uri    : " + epr.uri().toString());
					logger.log(Level.FINE, "---- WorkflowService name   : " + epr.name());
					logger.log(Level.FINE, "---- WorkflowService string : " + epr.toString());
					s.setEndpoint(epr.uri().toString());
					
					s.setFunctionality("execution.workflow");
					s.setID(inst.id());
					s.setHostingNode(inst.profile().ghnId());
					s.getScopes().addAll(new HashSet<String>(instScopes));
					serviceItems.put(s.getID(), s);
				}
			}
		}
		Set<IDaoElement> retValue=new HashSet<IDaoElement>();
		retValue.addAll(serviceItems.values());
		return retValue;
	}
	
	private static Set<IDaoElement> getSearchService()
	{
		return searchSystemServices;
	}
	
	public static final String ENDPOINT_KEY = "resteasy-servlet";
	
	private static Set<IDaoElement> retrieveSearchService() throws Exception 
	{
		List<String> scopes = BridgeHelper.scopes;
		Map<String,SearchServiceDao> serviceItems=new HashMap<String,SearchServiceDao>();
		
		for(String scope : scopes) {
			logger.log(Level.INFO,"Searching for search system services in scope "+scope.toString());
			
			ScopeProvider.instance.set(scope.toString());
			
			logger.log(Level.INFO," scope set : " + ScopeProvider.instance.get());
			
			SimpleQuery query = queryFor(GCoreEndpoint.class);
			
			logger.log(Level.INFO," query : " + query);
			
			String serviceName = "SearchSystemService";
			String serviceClass = "Search";
			
			
			query.addCondition("$resource/Profile/ServiceClass/text() eq '" + serviceClass + "'")
				.addCondition("$resource/Profile/ServiceName/text() eq '" + serviceName + "'");
			
			logger.log(Level.INFO," query : " + query);
			
			
			DiscoveryClient<GCoreEndpoint> client = clientFor(GCoreEndpoint.class);
			
			List<GCoreEndpoint> insts = client.submit(query);
			
			
			logger.log(Level.INFO,"Found "+insts.size()+" search services in scope");
			
			for (GCoreEndpoint inst :  insts){
				Group<org.gcube.common.resources.gcore.GCoreEndpoint.Profile.Endpoint> eprs= inst.profile().endpoints();
				
				if (inst != null && inst.profile() != null && inst.profile().endpointMap() != null){
					Endpoint epr = inst.profile().endpointMap().get(ENDPOINT_KEY);
					if (epr == null){
						logger.log(Level.INFO,"running instance : " + inst.id() + " has no searchsystemservice epr");
						continue;
					}
					
					String riStatus = inst.profile().deploymentData().status();
					if (!riStatus.equalsIgnoreCase("ready")){
						logger.log(Level.INFO,"running instance : " + inst.id() + " is NOT ready");
						continue;
					}
					
					Set<String> instScopes = new HashSet<String>();
					for (Object instSc : inst.scopes().toArray())
						instScopes.add((String) instSc);
					
					
					logger.log(Level.INFO,"Scopes of " + inst.id() + " : " + instScopes);
					
					if (serviceItems.containsKey(inst.id())){
						serviceItems.get(inst.id()).getScopes().addAll(instScopes);
						
					} else {
						SearchServiceDao s=new SearchServiceDao();
						
						s.setEndpoint(epr.uri().toString());
						s.setFunctionality("search.orchestrator");
						s.setID(inst.id());
						s.setHostingNode(inst.profile().ghnId());
						s.getScopes().addAll(new HashSet<String>(instScopes));
						serviceItems.put(s.getID(), s);
					}
					
				}
				
			}
		}
		
		Set<IDaoElement> retValue=new HashSet<IDaoElement>();
		retValue.addAll(serviceItems.values());
		return retValue;
	}
	
	
	private static Set<IDaoElement> getExecutionServer() throws Exception 
	{
		List<String> scopes = BridgeHelper.scopes;
		Map<String,ExecutionServerDao> serverItems=new HashMap<String,ExecutionServerDao>();
		Map<String,ExecutionServiceDao> serviceItems=new HashMap<String,ExecutionServiceDao>();
		for(String scope : scopes)
		{
			logger.log(Level.INFO,"Searching for execution engine services in scope "+scope.toString());
			
			
			ScopeProvider.instance.set(scope.toString());
			SimpleQuery query = queryFor(GCoreEndpoint.class);
			
			String serviceName = "ExecutionEngineService";
			String serviceClass = "Execution";
			
			query.addCondition("$resource/Profile/ServiceClass/text() eq '" + serviceClass + "'")
				.addCondition("$resource/Profile/ServiceName/text() eq '" + serviceName + "'");
			
			DiscoveryClient<GCoreEndpoint> client = clientFor(GCoreEndpoint.class);
			
			List<GCoreEndpoint> insts = client.submit(query);
			
			logger.log(Level.INFO,"Found "+insts.size()+" execution services in scope");
			
			
			for (GCoreEndpoint inst : insts){
				try {
					
					if (inst == null || inst.profile() == null || inst.profile().endpointMap() == null)
						continue;
					
					
					String riStatus = inst.profile().deploymentData().status();
					if (!riStatus.equalsIgnoreCase("ready")){
						logger.log(Level.INFO,"running instance : " + inst.id() + " is NOT ready");
						continue;
					}
					
					
					Endpoint epr = inst.profile().endpointMap().get(ENDPOINT_KEY);
					if (epr == null){
						logger.log(Level.INFO,"running instance : " + inst.id() + " has no execution engine service epr");
						continue;
					}
					
					Set<String> instScopes = new HashSet<String>();
					for (Object instSc : inst.scopes().toArray())
						instScopes.add((String) instSc);
					
					logger.log(Level.INFO,"Scopes of execution engine service with id : " + inst.id() + " : " + instScopes);
					
					if (serviceItems.containsKey(inst.id())){
						serviceItems.get(inst.id()).getScopes().addAll(instScopes);
						
					} else {
						ExecutionServiceDao s=new ExecutionServiceDao();
						
						s.setEndpoint(epr.uri().toString());
						s.setFunctionality("execution.execute");
						s.setID(inst.id());
						s.setHostingNode(inst.profile().ghnId());
						s.getScopes().addAll(new HashSet<String>(instScopes));
						serviceItems.put(s.getID(), s);
					}
					
					
					String sd = null;
					XPathHelper xpath = new XPathHelper(inst.profile().specificData());
					for (String val: xpath.evaluate("/")){
						sd = val;
					}
					
	
					
					if(sd==null || sd.trim().length()==0) continue;
					sd = sd.substring("<doc>".length());
					sd = sd.substring(0, sd.length() - "</doc>".length());
	
					System.out.println(sd);
					Document doc = XMLUtils.Deserialize(sd);
					List<Element> elems=XMLUtils.GetChildElementsWithName(doc.getDocumentElement(), "element");
					String hostname=null;
					String port=null;
					String elemId=null;
					
					
					for(Element el : elems)
					{
						elemId=XMLUtils.GetAttribute(el, "id");
						Element dynElem=XMLUtils.GetChildElementWithName(el, "dynamic");
						List<Element> dynPairs=XMLUtils.GetChildElementsWithName(dynElem, "entry");
						for(Element pair : dynPairs)
						{
							if(!XMLUtils.AttributeExists(pair, "pe2ng.port")) //this is preserved for backward compatibility
							{
								if(!XMLUtils.AttributeExists(pair, "key")) continue;
								String attrVal = XMLUtils.GetAttribute(pair, "key"); 
								if(attrVal != null && attrVal.equals("pe2ng.port"))
									port = XMLUtils.GetChildText(pair);
							}
							else port=XMLUtils.GetAttribute(pair, "pe2ng.port");
							if(!XMLUtils.AttributeExists(pair, "hostname")) //this is preserved for backward compatibility
							{
								if(!XMLUtils.AttributeExists(pair, "key")) continue;
								String attrVal = XMLUtils.GetAttribute(pair, "key"); 
								if(attrVal == null || !attrVal.equals("hostname")) continue;
								hostname = XMLUtils.GetChildText(pair);
							}
							else hostname=XMLUtils.GetAttribute(pair, "hostname");
							break;
						}
						if(port!=null && hostname!=null) break;
					}
					if(port!=null /*&& hostname!=null*/) //TODO see if host name is needed
					{
						if(serverItems.containsKey(elemId)) serverItems.get(elemId).getScopes().addAll(instScopes);
						else
						{
							ExecutionServerDao ss=new ExecutionServerDao();
							ss.setFunctionality("execution.execute");
							ss.setHostingNode(inst.profile().ghnId());
							ss.setID(elemId);
							ss.setHostname(hostname);
							ss.setPort(port);
							ss.getScopes().addAll(instScopes);
							serverItems.put(ss.getID(), ss);
						}
					}
					System.out.println("found execution server at : " + hostname + " : " + port);
					logger.log(Level.INFO, "found execution server at : " + hostname + " : " + port);
				} catch (Exception e) {
					logger.log(Level.WARNING, "Error parsing the running instance : " + inst.id() , e);
				}
			}
			
//			for(GCUBERunningInstance inst : result)
//			{
//				List<Endpoint> eprs= inst.getAccessPoint().getRunningInstanceInterfaces().getEndpoint();
//				if(eprs.size()!=1) continue;
//				if(serviceItems.containsKey(inst.getID())) serviceItems.get(inst.getID()).getScopes().addAll(new HashSet<String>(inst.getScopes().keySet()));
//				else
//				{
//					ExecutionServiceDao s=new ExecutionServiceDao();
//					s.setEndpoint(eprs.get(0).getValue());
//					s.setFunctionality("execution.execute");
//					s.setID(inst.getID());
//					s.setHostingNode(inst.getGHNID());
//					s.getScopes().addAll(new HashSet<String>(inst.getScopes().keySet()));
//					serviceItems.put(s.getID(), s);
//				}
//				String sd = inst.getSpecificData();
//				if(sd==null || sd.trim().length()==0) continue;
//				Document doc = XMLUtils.Deserialize(sd);
//				List<Element> elems=XMLUtils.GetChildElementsWithName(doc.getDocumentElement(), "element");
//				String hostname=null;
//				String port=null;
//				String elemId=null;
				
				
				
				
				
				
//				for(Element el : elems)
//				{
//					elemId=XMLUtils.GetAttribute(el, "id");
//					Element dynElem=XMLUtils.GetChildElementWithName(el, "dynamic");
//					List<Element> dynPairs=XMLUtils.GetChildElementsWithName(dynElem, "entry");
//					for(Element pair : dynPairs)
//					{
//						if(!XMLUtils.AttributeExists(pair, "pe2ng.port")) //this is preserved for backward compatibility
//						{
//							if(!XMLUtils.AttributeExists(pair, "key")) continue;
//							String attrVal = XMLUtils.GetAttribute(pair, "key"); 
//							if(attrVal != null && attrVal.equals("pe2ng.port"))
//								port = XMLUtils.GetChildText(pair);
//						}
//						else port=XMLUtils.GetAttribute(pair, "pe2ng.port");
//						if(!XMLUtils.AttributeExists(pair, "hostname")) //this is preserved for backward compatibility
//						{
//							if(!XMLUtils.AttributeExists(pair, "key")) continue;
//							String attrVal = XMLUtils.GetAttribute(pair, "key"); 
//							if(attrVal == null || !attrVal.equals("hostname")) continue;
//							hostname = XMLUtils.GetChildText(pair);
//						}
//						else hostname=XMLUtils.GetAttribute(pair, "hostname");
//						break;
//					}
//					if(port!=null && hostname!=null) break;
//				}
//				if(port!=null /*&& hostname!=null*/) //TODO see if host name is needed
//				{
//					if(serverItems.containsKey(elemId)) serverItems.get(elemId).getScopes().addAll(new HashSet<String>(inst.getScopes().keySet()));
//					else
//					{
//						ExecutionServerDao ss=new ExecutionServerDao();
//						ss.setFunctionality("execution.execute");
//						ss.setHostingNode(inst.getGHNID());
//						ss.setID(elemId);
//						ss.setHostname(hostname);
//						ss.setPort(port);
//						ss.getScopes().addAll(new HashSet<String>(inst.getScopes().keySet()));
//						serverItems.put(ss.getID(), ss);
//					}
//				}
//			}
		}
		Set<IDaoElement> retValue=new HashSet<IDaoElement>();
		retValue.addAll(serviceItems.values());
		retValue.addAll(serverItems.values());
		logger.log(Level.INFO,"Found "+serverItems.values().size()+" execution servers");
		return retValue;
	}
	
	private static Set<IDaoElement> getFunctionality() throws Exception 
	{
		Set<IDaoElement> items = new HashSet<IDaoElement>();
		FunctionalityDao f=new FunctionalityDao();
		f.setName("execution.execute");
		items.add(f);
		f=new FunctionalityDao();
		f.setName("execution.workflow");
		items.add(f);
		f=new FunctionalityDao();
		f.setName("search.index.ft");
		items.add(f);
		f=new FunctionalityDao();
		f.setName("search.index.fw");
		items.add(f);
		f=new FunctionalityDao();
		f.setName("search.index.geo");
		items.add(f);
		f=new FunctionalityDao();
		f.setName("search.index.opensearch");
		items.add(f);
		return items;
	}
	
	private static Set<IDaoElement> getHostingNodes() throws Exception 
	{
		List<String> scopes = BridgeHelper.scopes;
		HashMap<String, HostingNodeDao> items=new HashMap<String, HostingNodeDao>();
		for(String scope : scopes)
		{
			logger.log(Level.INFO,"Searching for hosting nodes in scope "+scope.toString());
			
			
			ScopeProvider.instance.set(scope.toString());
			SimpleQuery query = queryFor(org.gcube.common.resources.gcore.HostingNode.class);
			
			String serviceName = "WorkflowEngineService";
			String serviceClass = "Execution";
			
			DiscoveryClient<org.gcube.common.resources.gcore.HostingNode> client = clientFor(org.gcube.common.resources.gcore.HostingNode.class);
			
			List<org.gcube.common.resources.gcore.HostingNode> insts = client.submit(query);
			
			logger.log(Level.INFO,"Found "+insts.size()+" nodes in scope");
			
			for(org.gcube.common.resources.gcore.HostingNode node : insts)
			{
				Set<String> nodeScopes = new HashSet<String>();
				for (Object instSc : node.scopes().toArray())
					nodeScopes.add((String) instSc);
				
				if(items.containsKey(node.id()))
				{
					items.get(node.id()).getScopes().addAll(nodeScopes);
					//logger.log(Level.INFO, "updated node of : \n"+items.get(node.getID()).deepToString());
				}
				else
				{			
					HostingNodeDao item=new HostingNodeDao();
					item.setID(node.id());
					item.setScopes(new HashSet<String>(nodeScopes));
					try{item.getPairKeys().add("hn.infrastructure"); item.getPairValues().add("hn.infrastructure"+ HostingNode.KeyValueDelimiter+ node.profile().infrastructure());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.country"); item.getPairValues().add("hn.country"+ HostingNode.KeyValueDelimiter+ node.profile().site().country());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.domain"); item.getPairValues().add("hn.domain"+ HostingNode.KeyValueDelimiter+ node.profile().site().domain());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.latitude"); item.getPairValues().add("hn.latitude"+ HostingNode.KeyValueDelimiter+ node.profile().site().latitude());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.longitude"); item.getPairValues().add("hn.longitude"+ HostingNode.KeyValueDelimiter+ node.profile().site().longitude());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.location"); item.getPairValues().add("hn.location"+ HostingNode.KeyValueDelimiter+ node.profile().site().location());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.architecture.platform"); item.getPairValues().add("hn.architecture.platform"+ HostingNode.KeyValueDelimiter+ node.profile().description().architecture().platformType());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.architecture.smp"); item.getPairValues().add("hn.architecture.smp"+ HostingNode.KeyValueDelimiter+ Long.toString(node.profile().description().architecture().smpSize()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.architecture.smt"); item.getPairValues().add("hn.architecture.smt"+ HostingNode.KeyValueDelimiter+ Long.toString(node.profile().description().architecture().smtSize()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.benchmark.sf00"); item.getPairValues().add("hn.benchmark.sf00"+ HostingNode.KeyValueDelimiter+ Long.toString(node.profile().description().benchmark().sf00()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.benchmark.si00"); item.getPairValues().add("hn.benchmark.si00"+ HostingNode.KeyValueDelimiter+ Long.toString(node.profile().description().benchmark().si00()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.load.one_day"); item.getPairValues().add("hn.load.one_day"+ HostingNode.KeyValueDelimiter+ Double.toString(node.profile().description().historicalLoad().lastDay()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.load.one_hour"); item.getPairValues().add("hn.load.one_hour"+ HostingNode.KeyValueDelimiter+ Double.toString(node.profile().description().historicalLoad().lastHour()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.load.one_week"); item.getPairValues().add("hn.load.one_week"+ HostingNode.KeyValueDelimiter+ Double.toString(node.profile().description().historicalLoad().lastWeek()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.load.one_min"); item.getPairValues().add("hn.load.one_min"+ HostingNode.KeyValueDelimiter+ Double.toString(node.profile().description().load().lastMin()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.load.five_min"); item.getPairValues().add("hn.load.five_min"+ HostingNode.KeyValueDelimiter+ Double.toString(node.profile().description().load().last5Mins()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.load.fifteen_min"); item.getPairValues().add("hn.load.fifteen_min"+ HostingNode.KeyValueDelimiter+ Double.toString(node.profile().description().load().last15Mins()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.disk.size"); item.getPairValues().add("hn.disk.size"+ HostingNode.KeyValueDelimiter+ Long.toString(node.profile().description().localAvailableStorage()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.memory.physical.available"); item.getPairValues().add("hn.memory.physical.available"+ HostingNode.KeyValueDelimiter+ Long.toString(node.profile().description().mainMemory().ramAvailable()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.memory.physical.size"); item.getPairValues().add("hn.memory.physical.size"+ HostingNode.KeyValueDelimiter+ Long.toString(node.profile().description().mainMemory().ramSize()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.memory.virtual.size"); item.getPairValues().add("hn.memory.virtual.size"+ HostingNode.KeyValueDelimiter+ Long.toString(node.profile().description().mainMemory().virtualSize()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.memory.virtual.available"); item.getPairValues().add("hn.memory.virtual.available"+ HostingNode.KeyValueDelimiter+ Long.toString(node.profile().description().mainMemory().virtualAvailable()));}catch(Exception ex){}
					try{item.getPairKeys().add("hostname"); item.getPairValues().add("hostname"+ HostingNode.KeyValueDelimiter+ node.profile().description().name().substring(0, node.profile().description().name().lastIndexOf(':')));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.port"); item.getPairValues().add("hn.port"+ HostingNode.KeyValueDelimiter+ node.profile().description().name().substring(node.profile().description().name().lastIndexOf(':')+1));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.hostname"); item.getPairValues().add("hn.hostname"+ HostingNode.KeyValueDelimiter+ node.profile().description().name());}catch(Exception ex){}
					int count=0;
					try{
						Iterator<org.gcube.common.resources.gcore.HostingNode.Profile.NodeDescription.NetworkAdapter> it = node.profile().description().networkAdapters().iterator();
						
						while (it.hasNext()){
							org.gcube.common.resources.gcore.HostingNode.Profile.NodeDescription.NetworkAdapter nadp = it.next();
							try{item.getPairKeys().add("hn.network.adapter."+count+".inbound.ip"); item.getPairValues().add("hn.network.adapter."+count+".inbound.ip"+ HostingNode.KeyValueDelimiter+ nadp.inboundIP());}catch(Exception ex){}
							try{item.getPairKeys().add("hn.network.adapter."+count+".ip.address"); item.getPairValues().add("hn.network.adapter."+count+".ip.address"+ HostingNode.KeyValueDelimiter+ nadp.ipAddress());}catch(Exception ex){}
							try{item.getPairKeys().add("hn.network.adapter."+count+".mtu"); item.getPairValues().add("hn.network.adapter."+count+".mtu"+ HostingNode.KeyValueDelimiter+ Long.toString(nadp.mtu()));}catch(Exception ex){}
							try{item.getPairKeys().add("hn.network.adapter."+count+".name"); item.getPairValues().add("hn.network.adapter."+count+".name"+ HostingNode.KeyValueDelimiter+ nadp.name());}catch(Exception ex){}
							try{item.getPairKeys().add("hn.network.adapter."+count+".outbound.ip"); item.getPairValues().add("hn.network.adapter."+count+".outbound.ip"+ HostingNode.KeyValueDelimiter+ nadp.outboundIP());}catch(Exception ex){}
							count+=1;
						}
					}catch(Exception ex){}
					try{item.getPairKeys().add("hn.os.name"); item.getPairValues().add("hn.os.name"+ HostingNode.KeyValueDelimiter+ node.profile().description().operatingSystem().name());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.os.release"); item.getPairValues().add("hn.os.release"+ HostingNode.KeyValueDelimiter+ node.profile().description().operatingSystem().release());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.os.version"); item.getPairValues().add("hn.os.version"+ HostingNode.KeyValueDelimiter+ node.profile().description().operatingSystem().version());}catch(Exception ex){}
					count=0;
					try{
						long totalBogoMips = 0;
						long totalClockSpeed = 0;
						
						
						Iterator<org.gcube.common.resources.gcore.HostingNode.Profile.NodeDescription.Processor> it = node.profile().description().processors().iterator();
						while (it.hasNext()) {
							org.gcube.common.resources.gcore.HostingNode.Profile.NodeDescription.Processor pr = it.next();
							
							try{item.getPairKeys().add("hn.processor."+count+".bogomips"); item.getPairValues().add("hn.processor."+count+".bogomips"+ HostingNode.KeyValueDelimiter+ Double.toString(pr.bogomips().longValue())); totalBogoMips+=pr.bogomips().longValue();}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".cache.l1"); item.getPairValues().add("hn.processor."+count+".cache.l1"+ HostingNode.KeyValueDelimiter+ Long.toString(pr.cacheL1()));}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".cache.l1d"); item.getPairValues().add("hn.processor."+count+".cache.l1d"+ HostingNode.KeyValueDelimiter+ Long.toString(pr.cacheL1D()));}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".cache.l1i"); item.getPairValues().add("hn.processor."+count+".cache.l1i"+ HostingNode.KeyValueDelimiter+ Long.toString(pr.cacheL1I()));}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".cache.l2"); item.getPairValues().add("hn.processor."+count+".cache.l2"+ HostingNode.KeyValueDelimiter+ Long.toString(pr.cacheL2()));}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".clockspeed"); item.getPairValues().add("hn.processor."+count+".clockspeed"+ HostingNode.KeyValueDelimiter+ Double.toString(pr.clockSpeedMhz().longValue())); totalClockSpeed+=pr.clockSpeedMhz().longValue();}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".family"); item.getPairValues().add("hn.processor."+count+".clockspeed"+ HostingNode.KeyValueDelimiter+ pr.family());}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".model"); item.getPairValues().add("hn.processor."+count+".model"+ HostingNode.KeyValueDelimiter+ pr.model());}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".model_name"); item.getPairValues().add("hn.processor."+count+".model_name"+ HostingNode.KeyValueDelimiter+ pr.modelName());}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".vendor"); item.getPairValues().add("hn.processor."+count+".vendor"+ HostingNode.KeyValueDelimiter+ pr.vendor());}catch(Exception ex){}
							count+=1;
						}
						

						item.getPairKeys().add("hn.processor.count"); item.getPairValues().add("hn.processor.count" + HostingNode.KeyValueDelimiter + Integer.toString(count));
						item.getPairKeys().add("hn.processor.total_bogomips"); item.getPairValues().add("hn.processor.total_bogomips" + HostingNode.KeyValueDelimiter + Long.toString(totalBogoMips));
						item.getPairKeys().add("hn.processor.total_clockspeed"); item.getPairValues().add("hn.processor.total_clockspeed" + HostingNode.KeyValueDelimiter + Long.toString(totalClockSpeed));
					}catch(Exception ex){}
					
					
					try{item.getPairKeys().add("hn.status"); item.getPairValues().add("hn.status"+ HostingNode.KeyValueDelimiter+ node.profile().description().status().toString());}catch(Exception ex){}
					count=0;
					try{
//						Iterator<org.gcube.common.resources.gcore.HostingNode.Profile.NodeDescription.StorageDevice> it = node.profile().description().storageDevices().iterator();
//						while(it.hasNext()){
//							org.gcube.common.resources.gcore.HostingNode.Profile.NodeDescription.StorageDevice sd = it.next();
//
//							try{item.getPairKeys().add("hn.disk.device."+count+".name"); item.getPairValues().add("hn.disk.device."+count+".name"+ HostingNode.KeyValueDelimiter+ sd.name());}catch(Exception ex){}
//							try{item.getPairKeys().add("hn.disk.device."+count+".size"); item.getPairValues().add("hn.disk.device."+count+".size"+ HostingNode.KeyValueDelimiter+ Long.toString(sd.size()));}catch(Exception ex){}
//							try{item.getPairKeys().add("hn.disk.device."+count+".transfer_rate"); item.getPairValues().add("hn.disk.device."+count+".transfer_rate"+ HostingNode.KeyValueDelimiter+ Long.toString(sd.transferRate()));}catch(Exception ex){}
//							try{item.getPairKeys().add("hn.disk.device."+count+".type"); item.getPairValues().add("hn.disk.device."+count+".type"+ HostingNode.KeyValueDelimiter+ sd.type());}catch(Exception ex){}
//							int newCount=0;
//							try{
//								Iterator<org.gcube.common.resources.gcore.HostingNode.Profile.NodeDescription.StoragePartition> it_sp = node.profile().description().storagePartitions().iterator();
//								while (it_sp.hasNext()) {
//									org.gcube.common.resources.gcore.HostingNode.Profile.NodeDescription.StoragePartition sdp = it_sp.next();
//
//									try{item.getPairKeys().add("hn.disk.device."+count+".partition."+newCount+".name"); item.getPairValues().add("hn.disk.device."+count+".partition."+newCount+".name"+ HostingNode.KeyValueDelimiter+ sdp.name());}catch(Exception ex){}
//									try{item.getPairKeys().add("hn.disk.device."+count+".partition."+newCount+".read_rate"); item.getPairValues().add("hn.disk.device."+count+".partition."+newCount+".read_rate"+ HostingNode.KeyValueDelimiter+Long.toString(sdp.readRate()));}catch(Exception ex){}
//									try{item.getPairKeys().add("hn.disk.device."+count+".partition."+newCount+".size"); item.getPairValues().add("hn.disk.device."+count+".partition."+newCount+".size"+ HostingNode.KeyValueDelimiter+ sdp.size());}catch(Exception ex){}
//									try{item.getPairKeys().add("hn.disk.device."+count+".partition."+newCount+".write_rate"); item.getPairValues().add("hn.disk.device."+count+".partition."+newCount+".write_rate"+ HostingNode.KeyValueDelimiter+Long.toString(sdp.writeRate()));}catch(Exception ex){}
//									int deepCount=0;
//									try{
//										
//										for(FileSystem sdpfs : sdp.getFileSystems().values())
//										{
//											try{item.getPairKeys().add("hn.disk.device."+count+".partition."+newCount+".filesystem."+deepCount+".name"); item.getPairValues().add("hn.disk.device."+count+".partition."+newCount+".filesystem."+deepCount+".name"+ HostingNode.KeyValueDelimiter+sdpfs.getName());}catch(Exception ex){}
//											try{item.getPairKeys().add("hn.disk.device."+count+".partition."+newCount+".filesystem."+deepCount+".root"); item.getPairValues().add("hn.disk.device."+count+".partition."+newCount+".filesystem."+deepCount+".root"+ HostingNode.KeyValueDelimiter+sdpfs.getRoot());}catch(Exception ex){}
//											try{item.getPairKeys().add("hn.disk.device."+count+".partition."+newCount+".filesystem."+deepCount+".size"); item.getPairValues().add("hn.disk.device."+count+".partition."+newCount+".filesystem."+deepCount+".size"+ HostingNode.KeyValueDelimiter+Long.toString(sdpfs.getSize()));}catch(Exception ex){}
//											try{item.getPairKeys().add("hn.disk.device."+count+".partition."+newCount+".filesystem."+deepCount+".type"); item.getPairValues().add("hn.disk.device."+count+".partition."+newCount+".filesystem."+deepCount+".type"+ HostingNode.KeyValueDelimiter+sdpfs.getType());}catch(Exception ex){}
//											deepCount+=1;
//										}
//									}catch(Exception ex){}
//									newCount+=1;
//								}
//							}catch(Exception ex){}
//							count+=1;
//						}
					}catch(Exception ex){}
					try{item.getPairKeys().add("hn.uptime"); item.getPairValues().add("hn.uptime"+ HostingNode.KeyValueDelimiter+ node.profile().description().uptime());}catch(Exception ex){}
					try{
						Iterator<DeployedPackage> it = node.profile().packages().iterator();
						
						while(it.hasNext())
						{
							DeployedPackage pkg = it.next();
							String identifier=pkg.serviceClass()+"."+pkg.serviceName()+"."+pkg.name();
							try{item.getPairKeys().add("software."+identifier+".deployed"); item.getPairValues().add("software."+identifier+".deployed"+ HostingNode.KeyValueDelimiter+ "true");}catch(Exception ex){}
							try{item.getPairKeys().add("software."+identifier+".service_version"); item.getPairValues().add("software."+identifier+".service_version"+ HostingNode.KeyValueDelimiter+ pkg.serviceVersion());}catch(Exception ex){}
							try{item.getPairKeys().add("software."+identifier+".package_version"); item.getPairValues().add("software."+identifier+".package_version"+ HostingNode.KeyValueDelimiter+ pkg.packageVersion());}catch(Exception ex){}
						}
					}catch(Exception ex){}
					try{
						
						Iterator<org.gcube.common.resources.gcore.HostingNode.Profile.NodeDescription.Variable> it = node.profile().description().environmentVariables().iterator();
						
						while(it.hasNext())
						{
							org.gcube.common.resources.gcore.HostingNode.Profile.NodeDescription.Variable var = it.next();
							
							try{item.getPairKeys().add(var.key()); item.getPairValues().add(var.key()+ HostingNode.KeyValueDelimiter+ var.value());}catch(Exception ex){}

						}
					}catch(Exception ex){}
					items.put(item.getID(), item);
					//logger.log(Level.INFO, "added hosting node of : \n"+item.deepToString());
				}
			}
		}
		return new HashSet<IDaoElement>(items.values());
	}
	
	private static Set<IDaoElement> getAllCollections() throws Exception {
		Set<IDaoElement> dataCollections = new HashSet<IDaoElement>();
		dataCollections.addAll(getDataCollections());
		dataCollections.addAll(getTreeCollections());
		
		return dataCollections;
	}
	
	
	private static Set<IDaoElement> getDataCollections() throws Exception 
	{
		List<String> scopes = BridgeHelper.scopes;
		
		
		HashMap<String, DataCollectionDao> hcols=new HashMap<String, DataCollectionDao>();
		
		
		for(String scope : scopes) {
			
			ScopeProvider.instance.set(scope.toString());
			SimpleQuery query = queryFor(GenericResource.class);
			
			query.addCondition("$resource/Profile/SecondaryType/text() eq 'DataSource'");
			
			
			logger.log(Level.INFO, "query      : " + query.toString());
			logger.log(Level.INFO, "query expr : " + query.expression());
			
			DiscoveryClient<GenericResource> client = clientFor(GenericResource.class);
			 
			List<GenericResource> resources = client.submit(query);
			for (GenericResource resource : resources) {
				String id = resource.id();
				 logger.log(Level.INFO, "Found collection with id : " + id);
				 if (hcols.containsKey(id)) {
					 hcols.get(id).getScopes().add(scope.toString());
				 } else {
				   try {
					String name = resource.profile().name();
					logger.log(Level.INFO, "collection with id : " + id + " has name : " + name);
					String description = resource.profile().description();
					DataSourceDescription datasourceDescription= DataSourceDescription.getCollection(resource);
					Boolean isUserCollection = datasourceDescription.isUser();
					Calendar creationTime = datasourceDescription.getCreationTime();
					String type = datasourceDescription.getType();

					if (type != null && type.equalsIgnoreCase("opensearch")){
						logger.log(Level.INFO, "collection with id : " + id + " name : " + name + " is of type : " + type);	
					} else {
						logger.log(Level.INFO, "collection with id : " + id + " name : " + name + " is not of type : opensearch");
						
						if (type == null){
							logger.log(Level.INFO, "no type given skipping");
							continue;
						}
					}
					
					if(!isUserCollection) continue;
					DataCollectionDao d=new DataCollectionDao();
					d.setID(id);
					d.setDescription(description);
					d.setCollectionType(type);
					if(creationTime != null) d.setCreationTime(Long.toString(creationTime.getTimeInMillis()));
					d.setName(name);
					d.getScopes().add(scope.toString());
					hcols.put(d.getID(), d);
					if(d.getDescription() == null || d.getDescription().trim().length()==0) d.setDescription(null);
					if(d.getName().trim().length()==0) d.setName(null);
					Set<String> toDel=new HashSet<String>();
					for(String s : d.getScopes()) if(s.trim().length()==0) toDel.add(s);
					d.getScopes().removeAll(toDel);
					logger.log(Level.INFO,"collection with id : " + id + " has name : " + name + " type : " + type);
				 } catch (Exception e) {
						logger.log(Level.WARNING, "problem getting the resource of : " + resource.id(), e);
					}
				 }
			}
		}
		
		
		
			
//			logger.log(Level.INFO,"Searching for collection in scope "+scope.toString());
//			List<Collection> cols = org.gcube.contentmanagement.gcubedocumentlibrary.util.Collections.list(scope);
//			
//			logger.log(Level.INFO,"Found "+cols.size()+" collections in scope");
//			for(Collection col : cols)
//			{
//				if(hcols.containsKey(col.getId()))
//				{
//					hcols.get(col.getId()).getScopes().add(scope.toString());
//					//logger.log(Level.INFO, "updated collection of : \n"+hcols.get(col.getId()).deepToString());
//				}
//				else
//				{
//					if(!col.isUserCollection()) continue;
//					DataCollectionDao d=new DataCollectionDao();
//					d.setID(col.getId());
//					d.setDescription(col.getDescription());
//					if(col.getCreationTime() != null) d.setCreationTime(Long.toString(col.getCreationTime().getTimeInMillis()));
//					d.setName(col.getName());
//					d.getScopes().add(scope.toString());
//					hcols.put(d.getID(), d);
//					if(d.getDescription() == null || d.getDescription().trim().length()==0) d.setDescription(null);
//					if(d.getName().trim().length()==0) d.setName(null);
//					Set<String> toDel=new HashSet<String>();
//					for(String s : d.getScopes()) if(s.trim().length()==0) toDel.add(s);
//					d.getScopes().removeAll(toDel);
//					//logger.log(Level.INFO, "added collection of : \n"+d.deepToString());
//				}
//			}
//		}
		return new HashSet<IDaoElement>(hcols.values());
	}
	
	private static final String JNDI_NAME = "gcube/data/tm";
	private static final String TREADER_NAME = JNDI_NAME+"/reader";
	private static final String SOURCENAME_RPNAME = "Name";
	private static final String SOURCEID_RPNAME = "SourceId";
	private static final String CARDINALITY_RPNAME = "Cardinality";
	
	
	
	
	
	
	
	
	
	
	
	public static Set<IDaoElement> getTreeCollections() throws Exception {
		//String xquery = "declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry'; declare namespace gc = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider'; for $result in collection("/db/Properties")//Document  where ($result/Data/child::*[local-name()='ServiceName']/string() eq 'tree-manager-service')   and ($result/SourceKey/string() ne 'binder')  and ($result/SourceKey/string() ne 'manager')  return $result";
		List<String> scopes = BridgeHelper.scopes;
		HashMap<String, DataCollectionDao> hcols=new HashMap<String, DataCollectionDao>();
		
		logger.log(Level.INFO, " will search for TREE COLLECTIONS in the following scopes");
		for(String scope : scopes) {
			logger.log(Level.INFO, "### " + scope.toString());
		}
		
		for(String scope : scopes) {
		
			ScopeProvider.instance.set(scope.toString());
			SimpleQuery query = queryFor(ServiceInstance.class);
			
			
			logger.log(Level.INFO, " searching for TREE COLLECTIONS in scope : " + scope);
			
			
			String serviceName = "tree-manager-service";
			String serviceClass = "DataAccess";
			
			query.addCondition("$resource/Data/gcube:ServiceClass/text() eq '" + serviceClass + "'")
				.addCondition("$resource/Data/gcube:ServiceName/text() eq '" + serviceName + "'");
			
			
			logger.log(Level.INFO, "query      : " + query.toString());
			logger.log(Level.INFO, "query expr : " + query.expression());
			
			DiscoveryClient<ServiceInstance> client = clientFor(ServiceInstance.class);
			 
			List<ServiceInstance> resources = client.submit(query);
			 
			
			logger.log(Level.INFO, " found " + resources.size() +  " TREE COLLECTIONS in scope : " + scope);
			
			for (ServiceInstance r : resources) {
				
				
				try {
					 String endpoint =  r.endpoint().getPath();
					 
					 if (endpoint.endsWith(TREADER_NAME)) {
						 logger.log(Level.INFO, "Parsing tree...");
					    	//String name =  result.evaluate("//*[local-name()='"+SOURCENAME_RPNAME+"']/text()").get(0);
					    	
							XPathHelper xpath = new XPathHelper(r.properties().customProperties());
							String name = xpath.evaluate("//*[local-name()='"+SOURCENAME_RPNAME+"']/text()").get(0);
					    	
					    	logger.log(Level.INFO, "\t name : "+name);
					    	//String id = result.evaluate("//*[local-name()='"+SOURCEID_RPNAME+"']/text()").get(0);
					    	
					    	xpath = new XPathHelper(r.properties().customProperties());
							String id = xpath.evaluate("//*[local-name()='"+SOURCEID_RPNAME+"']/text()").get(0);
					    	
					    	logger.log(Level.INFO, "\t id : "+id);
					    	
					    	logger.log(Level.INFO, "Parsing tree...OK");
					    	
					    	//String totalItems = result.evaluate("//*[local-name()='"+CARDINALITY_RPNAME+"']/text()").get(0);
					    	String description = null;
					    	String creationTime = null;
					    	
					    	///logger.log(Level.INFO,"Parsed elements from xml : [id = " + id +", name = " + name + ", totalItems = " + totalItems + " ] ");
					    	logger.log(Level.INFO,"Parsed elements from xml : [id = " + id +", name = " + name + " ] ");
					    	
					    	if(hcols.containsKey(id))
							{
								hcols.get(id).getScopes().add(scope.toString());
								logger.log(Level.INFO, "updated collection of : \n"+hcols.get(id).deepToString());
								
								
								logger.log(Level.INFO, "+ added collection : "+name + " " + description + " scope : " + scope + " all scopes : " + hcols.get(id).getScopes());
							}
							else
							{
						    	DataCollectionDao d=new DataCollectionDao();
						    	d.setID(id);
						    	d.setName(name);
						    	d.setDescription(description);
						    	d.setCreationTime(creationTime);
						    	if(d.getDescription() == null || d.getDescription().trim().length()==0) d.setDescription(null);
								if(d.getName().trim().length()==0) d.setName(null);
						    	if (creationTime == null || creationTime.trim().length() == 0) d.setCreationTime(null);
						    	d.getScopes().add(scope.toString());
						    	
						    	hcols.put(d.getID(), d);
						    	
						    	Set<String> toDel=new HashSet<String>();
								for(String s : d.getScopes()) if(s.trim().length()==0) toDel.add(s);
								d.getScopes().removeAll(toDel);
								
								logger.log(Level.INFO, "added collection : \n"+hcols.get(id).deepToString());
								
								logger.log(Level.INFO, "+ added collection : "+name + " " + description + " scope : " + scope + " all scopes : " + d.getScopes());
							}
					 	}
					 }catch (Exception e) {
			    	logger.log(Level.WARNING, "Error while retrieving-parsing the tree manager collection");
			    }
			
			}
		}
		
		
		
		
//		ISClient client = GHNContext.getImplementation(ISClient.class);
//		for(GCUBEScope scope : scopes) {
//			 logger.log(Level.INFO,"Searching for tree collection in scope : " + scope);
//			 WSResourceQuery query = client.getQuery(WSResourceQuery.class);
//			    	query.addAtomicConditions(
//			    		new AtomicCondition("//gc:ServiceName", "tree-manager-service"), new AtomicCondition("//gc:ServiceClass", "DataAccess")
//			    );
//			    List<RPDocument> results = client.execute(query, scope);
//			    for (RPDocument result : results) {
//			    	
//			    	try {
//					    String endpoint = result.getEndpoint().getAddress().getPath();
//					    if (endpoint.endsWith(TREADER_NAME)) {
//					    	logger.log(Level.INFO, "Parsing tree...");
//					    	String name = result.evaluate("//*[local-name()='"+SOURCENAME_RPNAME+"']/text()").get(0);
//					    	logger.log(Level.INFO, "\t name : "+name);
//					    	String id = result.evaluate("//*[local-name()='"+SOURCEID_RPNAME+"']/text()").get(0);
//					    	logger.log(Level.INFO, "\t id : "+id);
//					    	
//					    	logger.log(Level.INFO, "Parsing tree...OK");
//					    	
//					    	//String totalItems = result.evaluate("//*[local-name()='"+CARDINALITY_RPNAME+"']/text()").get(0);
//					    	String description = null;
//					    	String creationTime = null;
//					    	
//					    	///logger.log(Level.INFO,"Parsed elements from xml : [id = " + id +", name = " + name + ", totalItems = " + totalItems + " ] ");
//					    	logger.log(Level.INFO,"Parsed elements from xml : [id = " + id +", name = " + name + " ] ");
//					    	
//					    	if(hcols.containsKey(id))
//							{
//								hcols.get(id).getScopes().add(scope.toString());
//								logger.log(Level.INFO, "updated collection of : \n"+hcols.get(id).deepToString());
//							}
//							else
//							{
//						    	DataCollectionDao d=new DataCollectionDao();
//						    	d.setID(id);
//						    	d.setName(name);
//						    	d.setDescription(description);
//						    	d.setCreationTime(creationTime);
//						    	if(d.getDescription() == null || d.getDescription().trim().length()==0) d.setDescription(null);
//								if(d.getName().trim().length()==0) d.setName(null);
//						    	if (creationTime == null || creationTime.trim().length() == 0) d.setCreationTime(null);
//						    	d.getScopes().add(scope.toString());
//						    	
//						    	hcols.put(d.getID(), d);
//						    	
//						    	Set<String> toDel=new HashSet<String>();
//								for(String s : d.getScopes()) if(s.trim().length()==0) toDel.add(s);
//								d.getScopes().removeAll(toDel);
//								
//								logger.log(Level.INFO, "added collection : \n"+hcols.get(id).deepToString());
//							}
//					    }
//				    
//			    	}catch (Exception e) {
//				    	logger.log(Level.WARNING, "Error while retrieving-parsing the tree manager collection");
//				    }
//				    
//			    }
//		}
		return new HashSet<IDaoElement>(hcols.values());	
	}
	
	private static Set<IDaoElement> getFields() throws Exception
	{
		logger.info("Searching for fields");
		Set<IDaoElement> items=new HashSet<IDaoElement>();
		Document fieldsDOM=null;
		String fieldsResource=FieldModel.getMainResource();
		logger.log(Level.INFO, "fieldsResource : " + fieldsResource );
		if(fieldsResource != null) fieldsDOM = XMLUtils.Deserialize(fieldsResource);
		else return items;
		
		boolean flatModel = false;
		List<Element> xmlObjs = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "fields") , "field");
		if(xmlObjs.size()!=0)
			flatModel = true;
		else
			xmlObjs =XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "fields"), "fieldId");
			
		if(flatModel)
		{
			for(Element elem : xmlObjs)
			{
					FieldDao f=new FieldDao();
					f.fromXML(elem);
					items.add(f);
			}
		}
		else
		{
			Set<String> fieldIds = FieldModel.getFieldIds();
			for(String fieldId : fieldIds)
			{
				String fieldResource=FieldModel.getFieldResource(fieldId);
				logger.log(Level.FINE, "Field read from resource");
				if(fieldResource != null) 
				{
					fieldsDOM = XMLUtils.Deserialize(fieldResource);
					xmlObjs = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "fieldInfo") , "field");
					
					logger.log(Level.FINE, "field has elements : " + xmlObjs.size());
					for(Element elem : xmlObjs)
					{
						FieldDao f=new FieldDao();
						f.fromXML(elem);
						items.add(f);
					}
				}
			}
		}
		logger.info("Found " + items.size() + " fields");
		return items;
	}
	
	private static Set<IDaoElement> getSearchables() throws Exception
	{
		logger.info("Searching for searchables");
		Set<IDaoElement> items=new HashSet<IDaoElement>();
		Document fieldsDOM=null;
		String fieldsResource=FieldModel.getMainResource();
		if(fieldsResource != null) fieldsDOM = XMLUtils.Deserialize(fieldsResource);
		else return items;
		boolean flatModel = false;
		List<Element> xmlObjs = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "searchables") , "searchable");
		if(xmlObjs.size()!=0)
			flatModel=true;
		else
			xmlObjs =XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "fields"), "fieldId");
		
		if(flatModel)
		{
			for(Element elem : xmlObjs)
			{
				SearchableDao f=new SearchableDao();
				f.fromXML(elem);
				items.add(f);
			}
		}
		else
		{
			Set<String> fieldIds = FieldModel.getFieldIds();
			for(String fieldId : fieldIds)
			{
				String fieldResource=FieldModel.getFieldResource(fieldId);
				if(fieldResource != null) 
				{
					fieldsDOM = XMLUtils.Deserialize(fieldResource);
					xmlObjs = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "searchables") , "searchable");
					for(Element elem : xmlObjs)
					{
						SearchableDao f=new SearchableDao();
						f.fromXML(elem);
						items.add(f);
					}
				}
			}
		}
		logger.info("Found " + items.size() + " searchables");
		//System.out.println("Found " + items.size() + " searchables");
		return items;
	}
	
	private static Set<IDaoElement> getPresentables() throws Exception
	{
		logger.info("Searching for presentables");
		Set<IDaoElement> items=new HashSet<IDaoElement>();
		Document fieldsDOM=null;
		String fieldsResource=FieldModel.getMainResource();
		if(fieldsResource != null) fieldsDOM = XMLUtils.Deserialize(fieldsResource);
		else return items;
		boolean flatModel = false;
		List<Element> xmlObjs = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "presentables") , "presentable");
		if(xmlObjs.size()!=0)
			flatModel=true;
		else
			xmlObjs =XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "fields"), "fieldId");
		
		if(flatModel)
		{
			for(Element elem : xmlObjs)
			{
				PresentableDao f=new PresentableDao();
				f.fromXML(elem);
				items.add(f);
			}
		}
		else
		{
			Set<String> fieldIds = FieldModel.getFieldIds();
			for(String fieldId : fieldIds)
			{
				String fieldResource=FieldModel.getFieldResource(fieldId);
				if(fieldResource != null) 
				{
					fieldsDOM = XMLUtils.Deserialize(fieldResource);
					xmlObjs = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "presentables") , "presentable");
					for(Element elem : xmlObjs)
					{
						PresentableDao f=new PresentableDao();
						f.fromXML(elem);
						items.add(f);
					}
				}
			}
		}
		logger.info("Found " + items.size() + " presentables");
		//System.out.println("Found " + items.size() + " presentables");
		return items;
	}
	
	private static Set<IDaoElement> getElementMetadata() throws Exception
	{
		logger.info("Searching for element metadata");
		Set<IDaoElement> items = new HashSet<IDaoElement>();
		Document fieldsDOM=null;
		String resource = null;
		String fieldsResource = null;
		String metadataResource = FieldModel.getMetadataResource();
		if(metadataResource == null)
		{
			fieldsResource = FieldModel.getMainResource();
			resource = fieldsResource;
		}
		else
			resource = metadataResource;
		
		if(resource != null) fieldsDOM = XMLUtils.Deserialize(resource);
		else return items;
		
		List<Element> xmlObjs = null;
		Element metadataElement = XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "metadata");
		if(metadataElement==null) return items;
		
		xmlObjs = XMLUtils.GetChildElementsWithName(metadataElement, "elementMetadata");
		for(Element elem : xmlObjs)
		{
			ElementMetadataDao s=new ElementMetadataDao();
			s.fromXML(elem);
			items.add(s);
		}
		logger.info("Found " + items.size() + " element metadata");
		return items;
	}

	private static Set<IDaoElement> getStaticConfiguration() throws Exception
	{
		logger.info("Searching for static configuration");
		Set<IDaoElement> items = new HashSet<IDaoElement>();
		Document staticConfigDOM=null;
		String staticConfigResource = FieldModel.getStaticConfigResource();
		
		if(staticConfigResource != null) staticConfigDOM = XMLUtils.Deserialize(staticConfigResource);
		else return items;
		
		//Element staticConfigElement = XMLUtils.GetChildElementWithName(staticConfigDOM.getDocumentElement(), "staticConfiguration");
		//if(staticConfigElement==null) return items;
		
		StaticConfigurationDao item = new StaticConfigurationDao();
		item.fromXML(staticConfigDOM.getDocumentElement());
		
		items.add(item);
		
		logger.info("Found " + items.size() + " static configuration");
		return items;
	}
	
	private static GenericResource getMostRecentResource(List<GenericResource> resources) throws Exception
	{
		long mostRecentTime=-1;
		GenericResource mostRecentResource=null;
		for(GenericResource resource : resources)
		{
			long updateTime=0;
			try{updateTime = Long.parseLong(resource.profile().description());}catch(Exception ex){continue;}
			if(updateTime> mostRecentTime) mostRecentResource=resource;
		}
		return mostRecentResource;
	}
	
	public static List<GenericResource> getPublishedFieldResources() throws Exception
	{
		return getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName);
	}
	
	public static List<GenericResource> getPublishedMetadataResources() throws Exception
	{
		return getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName + "." + "Metadata");
	}
	
	public static List<GenericResource> getPublishedStaticConfigResources() throws Exception
	{
		return getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName + "." + "StaticConfig");
	}
	
	public static List<GenericResource> getPublishedFieldResourcesForField(String fieldId) throws Exception
	{
		return getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName + "." + fieldId);
	}
	
	public static List<GenericResource> getPublishedFieldResources(String resourceName) throws Exception
	{
		//logger.log(Level.INFO, "getPublishedFieldResources: RR Classloader=" + Thread.currentThread().getContextClassLoader().getClass().getName());
		//logger.log(Level.INFO, "GHNContext Classloader: " + GHNContext.class.getClassLoader());
		
		
		logger.log(Level.INFO,"Searching for publised field resources in scopes : " + BridgeHelper.scopes);
		
		Set<String> scopes = getVOScopes(BridgeHelper.scopes);
		logger.log(Level.INFO,"VO scopes of : " + BridgeHelper.scopes + " are : " + scopes);
		
		List<GenericResource> resources = new ArrayList<GenericResource>();
		
		for(String scope : scopes) {
			
			ScopeProvider.instance.set(scope.toString());
			SimpleQuery query = queryFor(GenericResource.class);
			
			query.addCondition("$resource/Profile/SecondaryType/text() eq '" + GCubeRepositoryProvider.RRModelGenericResourceName + "'").
				addCondition("$resource/Profile/Name/text() eq '" + resourceName + "'");
			
			
			logger.log(Level.INFO, "query      : " + query.toString());
			logger.log(Level.INFO, "query expr : " + query.expression());
			
			DiscoveryClient<GenericResource> client = clientFor(GenericResource.class);
			 
			resources.addAll(client.submit(query));
		}
		
		
//		
//		ISClient client = null;
//		GCUBEGenericResourceQuery query = null;
//		client =  GHNContext.getImplementation(ISClient.class);
//		query = client.getQuery(GCUBEGenericResourceQuery.class);
//		
//		query.addAtomicConditions(new AtomicCondition("/Profile/SecondaryType", GCubeRepositoryProvider.RRModelGenericResourceName));
//		query.addAtomicConditions(new AtomicCondition("/Profile/Name", resourceName));
//		
//		GCUBEScope []scopes = BridgeHelper.scopes;
//		
//		List<GCUBEGenericResource> resources=new ArrayList<GCUBEGenericResource>();
//		for(GCUBEScope scope : scopes) resources.addAll(client.execute(query,scope));
		return resources;

	}
	
	public static String getVOScope(String scope){
		ScopeBean bean = new ScopeBean(scope);
		
		if(bean.is(ScopeBean.Type.VO))
			return scope;
		else if(bean.is(ScopeBean.Type.VRE))
			return bean.enclosingScope().toString();
		return null;
	}
	
	public static Set<String> getVOScopes(Collection<String> vreScopes){
		Set<String> voScopes = new HashSet<String>();
		if (vreScopes != null) {
			for (String scope : vreScopes) {
				String voScope = getVOScope(scope);
				if (voScope != null)
					voScopes.add(voScope);
			}
		}
		return voScopes;
	}
	
	public static void publishFieldResource(GenericResource resource, boolean isNew, Set<String> nonUpdateVOScopes) throws Exception
	{
		logger.log(Level.INFO, "publishing information on IS");
		
		
		logger.log(Level.INFO, "nonUpdateVOScopes : " + nonUpdateVOScopes);
		
//		GenericResource generic = Resources.unmarshal(GenericResource.class, new StringReader(resource.toString()));
		
		for (String gcubeScope : BridgeHelper.getFieldModelScopes()){
			logger.log(Level.INFO, "will check scope  : " + gcubeScope.toString());
		}
		
		Set<String> voScopes = getVOScopes(BridgeHelper.getFieldModelScopes());
		
		for (String gcubeScope : voScopes){
			
			logger.log(Level.INFO, "VOScope scope : " + gcubeScope);
			
			if(nonUpdateVOScopes.contains(gcubeScope)){
				logger.log(Level.INFO, "VOScope of scope : " + gcubeScope + " is in nonUpdateVOScopes");
				continue;
			}
			
			logger.log(Level.INFO, "trying to use scope : " + gcubeScope.toString());
			
			ScopeProvider.instance.set(gcubeScope);
			List<String> scopes= new ArrayList<String>();// BridgeHelper.getFieldModelScopes();
			scopes.add(gcubeScope);
			
			logger.log(Level.INFO, "scope added : " + scopes);
			
			ScopedPublisher publish=RegistryPublisherFactory.scopedPublisher();
			Resource r= null;
			
			
			if (isNew){
				logger.log(Level.INFO, "creating resource with id : " + resource.id() + " . is new : " + isNew);
//				if (resource.scopes().contains(gcubeScope)){
//					logger.log(Level.INFO, "scope in resource. updating. is new : " + isNew);
//					r = publish.update(resource);
//				} else {
//						logger.log(Level.INFO, "scope not in resource. creating or updating. is new : " + isNew);
						r = publish.create(resource, scopes);
//				}
			} else {
				logger.log(Level.INFO, "updating resource with id : " + resource.id() + " is new : " + isNew);
				if (resource.scopes().contains(gcubeScope)){
					logger.log(Level.INFO, "scope in resource. updating with id : " + resource.id() + " is new : " + isNew);
					r = publish.update(resource);
				} else {
						logger.log(Level.INFO, "scope not in resource. creating resource with id : " + resource.id() + ". is new : " + isNew);
						r = publish.create(resource, scopes);
				}
				if (r != null){
					logger.log(Level.INFO, "published resource id : " + r.id());
					logger.log(Level.INFO, "published resource id equals to previous : " + r.id().equalsIgnoreCase(resource.id()));
				}
			}
			
			
			
//			if(isNew) r = publish.create(resource, scopes);
//			else r = publish.update(resource);
			//else r = publish.update(resource, scopes);
			
			logger.log(Level.INFO, "is new : " + isNew);
			logger.log(Level.INFO, "id : " + r.id());
			
		}
		
//		GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl() {  public boolean isSecurityEnabled() {return false;}};
//		ISPublisher publish =  GHNContext.getImplementation(ISPublisher.class);
//		for(GCUBEScope scope : BridgeHelper.getFieldModelScopes())
//		{
//			if(isNew)publish.registerGCUBEResource(resource, scope, managerSec);
//			else publish.updateGCUBEResource(resource, scope, managerSec);
//		}
		logger.log(Level.INFO, "done publishing information on IS");
	}
	
	public static void deleteFieldResource(GenericResource resource, Set<String> nonUpdateVOScopes) throws Exception
	{
		logger.log(Level.INFO, "Deleting information from IS");
		
//		GenericResource generic = Resources.unmarshal(GenericResource.class, new StringReader(resource.toString()));
		
		for (String gcubeScope : BridgeHelper.getFieldModelScopes()){
			logger.log(Level.INFO, "trying to use scope : " + gcubeScope.toString());
			
			ScopeProvider.instance.set(gcubeScope);
			
			String VOScope1 = getVOScope(gcubeScope);
			
			
			if(nonUpdateVOScopes.contains(gcubeScope) || nonUpdateVOScopes.contains(VOScope1)){
				logger.log(Level.INFO, "VOScope of scope : " + gcubeScope + " is in nonUpdateVOScopes");
				continue;
			}
			
			List<String> scopes=new ArrayList<String>();
			scopes.add(gcubeScope);
			logger.log(Level.INFO, "scope added : " + scopes);
			
			ScopedPublisher sp=RegistryPublisherFactory.scopedPublisher();
			Resource r= null;
			
			r = sp.remove(resource, scopes);
		}
		
//		GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl() {  public boolean isSecurityEnabled() {return false;}};
//		ISPublisher publish =  GHNContext.getImplementation(ISPublisher.class);
//		for(GCUBEScope scope : BridgeHelper.getFieldModelScopes())
//		{
//			publish.removeGCUBEResource(resource.getID(), resource.getType(), scope, managerSec);
//		}
		logger.log(Level.INFO, "done deleting information from IS");
	}
	
	public static String buildFieldDirectorySerialization(Set<IDaoElement> fields) throws ResourceRegistryException
	{
		StringBuilder buf=new StringBuilder();
		buf.append("<root>\n");
		buf.append("<fields>\n");
		for(IDaoElement elem : fields)
		{
			buf.append("<fieldId>");
			buf.append(((FieldDao)elem).getID());
			buf.append("</fieldId>");
		}
		buf.append("</fields>\n");	
		buf.append("</root>\n");
		return buf.toString();
	}
	
	public static String buildFieldSerialization(IDaoElement field,Set<IDaoElement> searchables,Set<IDaoElement> presentables, Set<String> deletedSearchables, Set<String> deletedPresentables) throws ResourceRegistryException
	{
		StringBuilder buf=new StringBuilder();
		buf.append("<root>\n");
		buf.append("<fieldInfo>\n");
		buf.append(field.toXML());
		buf.append("</fieldInfo>\n");
		buf.append("<searchables>\n");
		for(String searchableId : ((FieldDao)field).getSearchables()) 
		{
			for(IDaoElement elem : searchables)
			{
				if(elem.getID().equals(searchableId) && !deletedSearchables.contains(searchableId)){
					buf.append(elem.toXML());
				}
			}
		}
		buf.append("</searchables>\n");
		buf.append("<presentables>\n");
		for(String presentableId : ((FieldDao)field).getPresentables()) 
		{
			for(IDaoElement elem :presentables)
			{
				if(elem.getID().equals(presentableId) && !deletedPresentables.contains(presentableId)){
					buf.append(elem.toXML());
				}
			}
		}
		buf.append("</presentables>\n");
		
		buf.append("</root>\n");
		
		return buf.toString();
	}
	
	
	public static Set<IDaoElement> updateFieldList(Set<IDaoElement> fields,Set<IDaoElement> searchables,Set<IDaoElement> presentables, List<String> emptyScopedSearchables, List<String> emptyScoperdPresentables) throws ResourceRegistryException
	{
		Set<IDaoElement> updatedFields = new HashSet<IDaoElement>();
		
		for (IDaoElement field : fields)
			if (shouldUpdateField(field, searchables, presentables, emptyScopedSearchables, emptyScoperdPresentables) == true)
				updatedFields.add(field);
		return updatedFields;
	}
	
	public static boolean shouldUpdateField(IDaoElement field,Set<IDaoElement> searchables,Set<IDaoElement> presentables, List<String> emptyScopedSearchables, List<String> emptyScoperdPresentables) throws ResourceRegistryException
	{
		for(String searchableId : ((FieldDao)field).getSearchables()) 
		{
			for(IDaoElement elem : searchables)
			{
				if(elem.getID().equals(searchableId) && !emptyScopedSearchables.contains(searchableId)){
					return true;
				}
			}
		}
		for(String presentableId : ((FieldDao)field).getPresentables()) 
		{
			for(IDaoElement elem :presentables)
			{
				if(elem.getID().equals(presentableId) && !emptyScoperdPresentables.contains(presentableId)){
					return true;
				}
			}
		}
		
		return false;
	}
	
	public static String updateFieldSerialization(String originalSerialization, IDaoElement field,Set<IDaoElement> searchables,Set<IDaoElement> presentables,
			boolean updateFields, boolean updateSearchables, boolean updatePresentables, Set<String> deletedSearchables, Set<String> deletedPresentables) throws Exception
	{
		Document original = null;
		
		try {
			original = XMLUtils.Deserialize(originalSerialization);
		} catch (Exception e) {
			logger.log(Level.SEVERE, "error in deserializing : " + originalSerialization);
			throw e;
		}
		StringBuilder buf=new StringBuilder();
		buf.append("<root>\n");
		if(updateFields)
		{
			if(updateSearchables && updatePresentables)
			{
				buf.append("<fieldInfo>\n");
				buf.append(field.toXML());
				buf.append("</fieldInfo>\n");
			}else
			{
				Element originalField = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(original.getDocumentElement(), "fieldInfo"), "field").get(0);
				buf.append("<fieldInfo>\n");
				FieldDao updatedDao = new FieldDao();
				Document dbField = XMLUtils.Deserialize(field.toXML());
				
				updatedDao.setID(((FieldDao)field).getID());
				updatedDao.setName(((FieldDao)field).getName());
				updatedDao.setDescription(((FieldDao)field).getDescription());
			
				Set<String> updatedSearchables = new HashSet<String>();
				if(updateSearchables)
				{
					//the searchables of this field as retrieved from the database (updated)
					List<Element> dbSearchables = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(dbField.getDocumentElement(), "searchables") , "searchable");
					for(Element dbSearchable : dbSearchables)
						updatedSearchables.add(dbSearchable.getFirstChild().getNodeValue());
				}else 
				{
					//the searchables of this field as retrieved from the is (original)
					List<Element> originalSearchables = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(originalField, "searchables"), "searchable");
					for(Element originalSearchable : originalSearchables)
						updatedSearchables.add(originalSearchable.getFirstChild().getNodeValue());
				}
				
				Set<String> updatedPresentables = new HashSet<String>();
				if(updatePresentables)
				{
					//the presentables of this field as retrieved from the database (updated)
					List<Element> dbPresentables = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(dbField.getDocumentElement(), "presentables") , "presentable");
					for(Element dbPresentable : dbPresentables)
						updatedPresentables.add(dbPresentable.getFirstChild().getNodeValue());
				}else 
				{
					//the presentables of this field as retrieved from the is (original)
					List<Element> originalPresentables = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(originalField, "presentables"), "presentable");
					for(Element originalPresentable : originalPresentables)
						updatedPresentables.add(originalPresentable.getFirstChild().getNodeValue());
				}
				
				updatedDao.setSearchables(updatedSearchables);
				updatedDao.setPresentables(updatedPresentables);
				
				buf.append(updatedDao.toXML());
				buf.append("</fieldInfo>\n");
			}
		}else 
		{
			Element originalFields = XMLUtils.GetChildElementWithName(original.getDocumentElement(), "fieldInfo");
			buf.append(XMLUtils.Serialize(originalFields, true));
		}
		
		if(updateSearchables)
		{
			buf.append("<searchables>\n");
			for(String searchableId : ((FieldDao)field).getSearchables()) 
			{
				for(IDaoElement elem : searchables)
				{
					if(elem.getID().equals(searchableId) && !deletedSearchables.contains(searchableId))
						buf.append(elem.toXML());
				}
			}
			buf.append("</searchables>\n");
		}else
		{
			Element originalSearchables = XMLUtils.GetChildElementWithName(original.getDocumentElement(), "searchables");
			buf.append(XMLUtils.Serialize(originalSearchables, true));
		}
		
		if(updatePresentables)
		{
			buf.append("<presentables>\n");
			for(String presentableId : ((FieldDao)field).getPresentables()) 
			{
				for(IDaoElement elem :presentables)
				{
					if(elem.getID().equals(presentableId) && !deletedPresentables.contains(presentableId))
						buf.append(elem.toXML());
				}
			}
			buf.append("</presentables>\n");
		}else
		{
			Element originalPresentables = XMLUtils.GetChildElementWithName(original.getDocumentElement(), "presentables");
			buf.append(XMLUtils.Serialize(originalPresentables, true));
		}
		
		buf.append("</root>\n");
		return buf.toString();
	}
	
	public static String buildElementMetadataSerialization(Set<IDaoElement> metadata) throws ResourceRegistryException
	{
		StringBuilder buf=new StringBuilder();
		buf.append("<root>\n");
		buf.append("<metadata>\n");
		for(IDaoElement elem : metadata) buf.append(elem.toXML());
		buf.append("</metadata>\n");
		buf.append("</root>\n");
		return buf.toString();
	}
	
	public static String buildStaticConfigSerialization(IDaoElement staticConfig) throws ResourceRegistryException
	{
		StringBuilder buf=new StringBuilder();
		buf.append(staticConfig.toXML());
		return buf.toString();
	}
	
	public static void prefetchInMemoryItems(Set<Class<?>> itemTypes) throws ResourceRegistryException
	{
		InMemoryStore.clear();
		
		Map<String, ElementMetadataDao> metadata = new HashMap<String, ElementMetadataDao>();
		Set<IDaoElement> metadataSet = null;
		try { metadataSet = DatastoreHelper.getItems(DatastoreType.LOCAL, ElementMetadataDao.class); }
		catch(Exception e) { throw new ResourceRegistryException("Could not retrieve element metadata", e); }
		for(IDaoElement m : metadataSet)
			metadata.put(m.getID(), (ElementMetadataDao)m);
		
		boolean baseDatasource = false;
		for(Class<?> itemType : itemTypes)
		{
			if(itemType.getName().equals(DataSource.class.getName()))
			{
				baseDatasource = true;
				break;
			}
		}
		boolean baseDatasourceService = false;
		for(Class<?> itemType : itemTypes)
		{
			if(itemType.getName().equals(DataSourceService.class.getName()))
			{
				baseDatasourceService = true;
				break;
			}
		}
		for(Class<?> itemType : itemTypes)
		{
			logger.log(Level.INFO, "Prefetching element " + itemType.getName());
			if(itemType.getName().equals(DataCollection.class.getName()))
				InMemoryStore.setItems(itemType, new HashSet<DataCollection>(DataCollection.getAllCollections(false)));
			else if(itemType.getName().equals(DataLanguage.class.getName()))
				InMemoryStore.setItems(itemType, new HashSet<DataLanguage>(DataLanguage.getLanguages()));
			else if(itemType.getName().equals(Functionality.class.getName()))
				InMemoryStore.setItems(itemType, new HashSet<Functionality>(Functionality.getAllFunctionalities(false)));
			else if(itemType.getName().equals(HostingNode.class.getName()))
				InMemoryStore.setItems(itemType, new HashSet<HostingNode>(HostingNode.getAll(false)));
			else if(itemType.getName().equals(Field.class.getName()))
				InMemoryStore.setItems(itemType, new HashSet<Field>(Field.getAll(false)));
			else if(itemType.getName().equals(Searchable.class.getName()))
			{
				Set<IDaoElement> items = null;
				try { items = DatastoreHelper.getItems(DatastoreType.LOCAL, SearchableDao.class); }
				catch(Exception e) { throw new ResourceRegistryException("Could not prefetch searchables", e); }
				for(IDaoElement item : items)
				{
					Searchable loaded = new Searchable();
					loaded.setID(((SearchableDao)item).getID());
					loaded.load(false);
					if(!(metadata.containsKey(loaded.getField()) && metadata.get(loaded.getField()).getType().equals(ElementMetadata.Type.DeletedField.toString()))){
						if (metadata.get(loaded.getField()) != null)
							logger.info("loaded searchable for field : " + loaded.getField() + " id : " + item.getID()  +  " type " + metadata.get(loaded.getField()).getType());
						else
							logger.info("loaded searchable for field : " + loaded.getField() + " id : " + item.getID()  +  " is not in metadata");
						InMemoryStore.setItem(Searchable.class, loaded);
					}
				}
			}
			else if(itemType.getName().equals(Presentable.class.getName()))
			{
				Set<IDaoElement> items = null;
				try { items = DatastoreHelper.getItems(DatastoreType.LOCAL, PresentableDao.class); }
				catch(Exception e) { throw new ResourceRegistryException("Could not prefetch presentables", e); }
				for(IDaoElement item : items)
				{
					Presentable loaded = new Presentable();
					loaded.setID(((PresentableDao)item).getID());
					loaded.load(false);
					if(!(metadata.containsKey(loaded.getField()) && metadata.get(loaded.getField()).getType().equals(ElementMetadata.Type.DeletedField.toString()))){
						if (metadata.get(loaded.getField()) != null)
							logger.info("loaded presentable for field : " + loaded.getField() + " id : " + item.getID()  +  " type " + metadata.get(loaded.getField()).getType());
						else
							logger.info("loaded presentable for field : " + loaded.getField() + " id : " + item.getID()  +  " is not in metadata");
						
						InMemoryStore.setItem(Presentable.class, loaded);
					}
				}
			}
			else if(itemType.getName().equals(DataSource.class.getName()))
			{
				List<DataSource> ds = DataSource.getAll(false);
				for(DataSource d : ds)
					InMemoryStore.setItem(d.getClass(), d);	
			}
			else if(itemType.getName().equals(DataSourceService.class.getName()))
			{
				List<DataSourceService> ds = DataSourceService.getAll(false);
				for(DataSourceService d : ds)
					InMemoryStore.setItem(d.getClass(), d);	
			}
			else if(itemType.getName().equals(FTIndex.class.getName()))
			{
				if(baseDatasource==false)
					InMemoryStore.setItems(FTIndex.class, new HashSet<DataSource>(FTIndex.getAll(false)));
			}
			else if(itemType.getName().equals(FTIndexService.class.getName()))
			{
				if(baseDatasourceService == false)
					InMemoryStore.setItems(FTIndexService.class, new HashSet<DataSourceService>(FTIndexService.getAll(false)));
			}
//			else if(itemType.getName().equals(FWIndex.class.getName()))
//			{
//				if(baseDatasource == false)
//					InMemoryStore.setItems(FWIndex.class, new HashSet<DataSource>(FWIndex.getAll(false)));
//			}
//			else if(itemType.getName().equals(FWIndexService.class.getName()))
//			{
//				if(baseDatasourceService == false)
//					InMemoryStore.setItems(FWIndexService.class, new HashSet<DataSourceService>(FWIndexService.getAll(false)));
//			}
//			else if(itemType.getName().equals(GeoIndex.class.getName()))
//			{
//				if(baseDatasource == false)
//					InMemoryStore.setItems(GeoIndex.class, new HashSet<DataSource>(GeoIndex.getAll(false)));
//			}
//			else if(itemType.getName().equals(GeoIndexService.class.getName()))
//			{
//				if(baseDatasourceService == false)
//					InMemoryStore.setItems(GeoIndexService.class, new HashSet<DataSourceService>(GeoIndexService.getAll(false)));
//			}
			else if(itemType.getName().equals(OpenSearchDataSource.class.getName()))
			{
				if(baseDatasource == false)
					InMemoryStore.setItems(OpenSearchDataSource.class, new HashSet<DataSource>(OpenSearchDataSource.getAll(false)));
			}
			else if(itemType.getName().equals(OpenSearchDataSourceService.class.getName()))
			{
				if(baseDatasourceService == false)
					InMemoryStore.setItems(OpenSearchDataSourceService.class, new HashSet<DataSourceService>(OpenSearchDataSourceService.getAll(false)));
			}
			else if(itemType.getName().equals(FieldIndexContainer.class.getName()))
			{
				Set<IDaoElement> items = null;
				try { items = DatastoreHelper.getItems(DatastoreType.LOCAL, FieldIndexContainerDao.class); }
				catch(Exception e) { throw new ResourceRegistryException("Could not prefetch datasource field info", e); }
				for(IDaoElement item : items)
				{
					FieldIndexContainer loaded = new FieldIndexContainer();
					loaded.setID(((FieldIndexContainerDao)item).getID());
					loaded.load(false);
					InMemoryStore.setItem(FieldIndexContainer.class, loaded);
				}
			}
		}
	}
	
	
	static public List<String> getGHNContextStartScopes() {
		List<String> scopes = ConfigurationProviderLoader.getProvider().getGHNContextStartScopes();
		logger.log(Level.INFO, "gHNContextStartScopes : " + scopes);
		return scopes;
		/*
		List<String> scopes = new ArrayList<String>();
		for (GCUBEScope scope : GHNContext.getContext().getStartScopes()){
			scopes.add(scope.toString());
		}
		
		//XMLReader.getStartScopes();
		
		return scopes;*/
	}
	
	
	static public List<String> getGHNContextScopes() {
		List<String> scopes = ConfigurationProviderLoader.getProvider().getGHNContextScopes();
		logger.log(Level.INFO, "gHNContextScopes : " + scopes);
		return scopes;
		/*
		List<String> scopes = new ArrayList<String>();
		for (GCUBEScope scope : GHNContext.getContext().getGHN().getScopes().values()){
			scopes.add(scope.toString());
		}
		//XMLReader.getStartScopes();
		
		return scopes;*/
	}
	
	static public boolean isClientMode() {
		boolean isClientMode = ConfigurationProviderLoader.getProvider().isClientMode();
		logger.log(Level.INFO, "isClientMode : " + isClientMode);
		return isClientMode;
		//return GHNContext.getContext().isClientMode();
		
		//test JNDI to detect client mode and set status to DOWN in case
		/*try {getContext().lookup("java:comp/env/status");}
		catch(Exception e) {return true;}
		return false;*/
	}
	
	/*@SuppressWarnings("unchecked")
	static  InitialContext getContext() {
		try {
			Hashtable<String, String> env = new Hashtable<String, String>();
			env.put(SynchronizedContext.SYNCHRONIZED, "true");
			env.put(Context.INITIAL_CONTEXT_FACTORY,"org.apache.naming.java.javaURLContextFactory");
			return new InitialContext(env);
		} catch (Exception e) {
			
		}
		return null;
	}*/
	
	
	
	
	public static void main(String[] args) throws Exception {
		
//		String scope = "/gcube/devNext";
//		String serviceName = "ForwardIndexNode";
//		String serviceClass = "Index";
//		ScopeProvider.instance.set(scope);
//		SimpleQuery query = queryFor(ServiceInstance.class);
//		
//		query.addCondition("$resource/Data/gcube:ServiceClass/text() eq '" + serviceClass + "'")
//			 .addCondition("$resource/Data/gcube:ServiceName/text() eq '" + serviceName + "'");
//		 
//		DiscoveryClient<ServiceInstance> client = clientFor(ServiceInstance.class);
//		
//		List<ServiceInstance> resources = client.submit(query);
//		
//		
//		for (ServiceInstance resource : resources) {
//			resource.properties().customProperties().getClass();
//			XPathHelper xpath = new XPathHelper(resource.properties().customProperties());
//			for (String val: xpath.evaluate("/doc/*[local-name()='Fields']/text()"))
//				System.out.println(val);
//		}
//
////		
//		
////		
//////		System.out.println(resources);
//		
////		ResourceRegistry.startBridging();
////		while (!ResourceRegistry.isInitialBridgingComplete())
////			Thread.sleep(1000);
//		
		
//		System.out.println(getIndexServiceEndpoint("/gcube/devNext", "dl015.madgik.di.uoa.gr"));
//		System.out.println(getIndexServiceGHNId("/gcube/devNext", "dl015.madgik.di.uoa.gr"));
		
		BridgeHelper.scopes = new ArrayList<String>();
		BridgeHelper.scopes.add("/gcube/devNext/NextNext");
		BridgeHelper.scopes.add("/gcube/devNext");
//		BridgeHelper.scopes.add("/d4science.research-infrastructures.eu");
//		BridgeHelper.scopes.add("/d4science.research-infrastructures.eu/gCubeApps");
		
		getDataSourceFT();
//		getDataCollections();
//		getExecutionServer();
//		getSearchables();
//		getPresentables();
//		BridgeHelper.scopes.add("/d4science.research-infrastructures.eu/EUBrazilOpenBio/SpeciesLab");
////		BridgeHelper.scopes.add("/d4science.research-infrastructures.eu/EUBrazilOpenBio/SpeciesLab");
//		
//		System.out.println(getVOScopes(BridgeHelper.scopes));
//		
////		Set<DataCollection> colls = QueryHelper.getExternalCollectionsOfScope("/d4science.research-infrastructures.eu/EUBrazilOpenBio");
////		for (DataCollection col : colls){
////			System.out.println("col : " + col.getID() + " , " + col.getName());
////		}
//		
////		 BridgeHelper.searchSystemScopes = BridgeHelper.scopes;
////		 System.out.println(getPublishedMetadataResources().size());
//////		retrieveSearchService();
//////		FieldModel.retrieve();
//////		getExecutionServer();
//////		getDataCollections();
//////		getOpenSearchDataSource();
//////		getFields();
//////		getTreeCollections();
//////		getWorkflowService();
//////		retrieveSearchService();
////		getFTIndex();
		
//		String field = "977ec5d3-7a99-4262-8251-8332c4c16766";
//		String collection = "553e9014-fd4f-45fd-868e-07834c55b83b";
//		List<String> relations = new ArrayList<String>();
//		relations.add("=");
//		List<String> projections = new ArrayList<String>();
//		relations.add("4b9b2594-9ffe-4f40-8de1-698818dfecc0");
//		String scope = "/gcube/devNext";
//		
//		
//		
//		Set<String> s = QueryHelper.getLanguageByFieldRelationCol(field, relations,collection, projections, scope);
//		System.out.println(s);
		
		
//		DataCollection.getCollectionsOfScope(true, "/gcube/devNext/NextNext");
		
//////		System.out.println();
//		getFWIndex();
		

	}
}
