/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.rr.bridge;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.execution.rr.bridge.BackendConnector;
import org.gcube.execution.rr.bridge.BridgeHelper;
import org.gcube.execution.rr.bridge.GCubeRepositoryProvider;
import org.gcube.rest.commons.helpers.XPathEvaluator;
import org.gcube.rest.commons.resourceawareservice.resources.Resource;
import org.gcube.rest.resourcemanager.discovery.InformationCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FieldModel {
    private static final Logger logger = LoggerFactory.getLogger(FieldModel.class);
    public static Resource mainResource;
    private static Map<String, Resource> fieldResources;
    private static Resource metadataResource;
    private static Resource staticConfigResource;
    private static Set<String> fieldIds;

    private static Resource getMostRecentResource(List<Resource> resources) throws Exception {
        long mostRecentTime = -1L;
        Resource mostRecentResource = null;
        for (Resource resource : resources) {
            long updateTime = 0L;
            try {
                updateTime = Long.parseLong(resource.getDescription());
            }
            catch (Exception ex) {
                continue;
            }
            if (updateTime <= mostRecentTime) continue;
            mostRecentResource = resource;
        }
        return mostRecentResource;
    }

    private static void processResources(Map<String, Map<String, Resource>> resources) throws Exception {
        HashSet<String> fieldResourceIds = new HashSet<String>();
        HashSet fieldIdsInDirectory = new HashSet();
        ArrayList<Resource> mainResources = new ArrayList<Resource>();
        for (Map<String, Resource> resourcesInScope : resources.values()) {
            Resource mainResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName);
            if (mainResource == null) continue;
            mainResources.add(mainResource);
        }
        mainResource = FieldModel.getMostRecentResource(mainResources);
        boolean foundDirectory = false;
        Document fieldsDOM = null;
        if (mainResource != null && FieldModel.getStringOfElement(mainResource.getBody()) != null && FieldModel.getStringOfElement(mainResource.getBody()).trim().length() != 0) {
            fieldsDOM = XMLUtils.Deserialize((String)FieldModel.getStringOfElement(mainResource.getBody()));
            foundDirectory = true;
        }
        if (foundDirectory) {
            XPathEvaluator xpath = new XPathEvaluator(mainResource.getBody());
            List fieldIds = xpath.evaluate("//fieldId/text()");
            FieldModel.fieldIds.addAll(fieldIds);
            fieldIdsInDirectory.addAll(fieldIds);
        }
        ArrayList<Resource> metadataResources = new ArrayList<Resource>();
        for (Map map : resources.values()) {
            Resource metadataResource = (Resource)map.get(GCubeRepositoryProvider.RRModelGenericResourceName + ".Metadata");
            if (metadataResource == null) continue;
            metadataResources.add(metadataResource);
        }
        metadataResource = FieldModel.getMostRecentResource(metadataResources);
        ArrayList<Resource> staticConfigResources = new ArrayList<Resource>();
        for (Map<String, Resource> resourcesInScope : resources.values()) {
            Resource staticConfigResource = resourcesInScope.get(GCubeRepositoryProvider.RRModelGenericResourceName + ".StaticConfig");
            if (staticConfigResource == null) continue;
            staticConfigResources.add(staticConfigResource);
        }
        logger.info("found : " + staticConfigResources.size() + " staticconfig resources ");
        staticConfigResource = FieldModel.getMostRecentResource(staticConfigResources);
        if (foundDirectory) {
            for (Map<String, Resource> resourcesInScope : resources.values()) {
                for (Map.Entry entry : resourcesInScope.entrySet()) {
                    if (!((String)entry.getKey()).startsWith(GCubeRepositoryProvider.RRModelGenericResourceName + ".")) continue;
                    fieldResourceIds.add(((Resource)entry.getValue()).getName().substring(((Resource)entry.getValue()).getName().indexOf(".") + 1));
                }
            }
            for (String fieldResourceId : fieldResourceIds) {
                if (!fieldIdsInDirectory.contains(fieldResourceId)) continue;
                ArrayList<Resource> fieldResources = new ArrayList<Resource>();
                for (Map<String, Resource> map : resources.values()) {
                    Resource fieldResource = map.get(GCubeRepositoryProvider.RRModelGenericResourceName + "." + fieldResourceId);
                    if (fieldResource == null) continue;
                    fieldResources.add(fieldResource);
                }
                Resource resource = FieldModel.getMostRecentResource(fieldResources);
                if (resource == null) continue;
                FieldModel.fieldResources.put(fieldResourceId, resource);
            }
        }
    }

    public static void retrieve() throws Exception {
        InformationCollector icollector = BackendConnector.newICollector();
        mainResource = null;
        fieldResources = new HashMap<String, Resource>();
        metadataResource = null;
        staticConfigResource = null;
        fieldIds = new HashSet<String>();
        List<String> scopes = BridgeHelper.getFieldModelScopes();
        HashMap<String, Map<String, Resource>> resources = new HashMap<String, Map<String, Resource>>();
        for (String scope : scopes) {
            logger.info("Retrieving field model generic resources in scope " + scope.toString());
            List res = icollector.getGenericResourcesByType(GCubeRepositoryProvider.RRModelGenericResourceName, scope);
            logger.info("number of generic resources ( " + GCubeRepositoryProvider.RRModelGenericResourceName + " ) : " + res.size());
            if (!resources.containsKey(scope.toString())) {
                resources.put(scope.toString(), new HashMap());
            }
            for (Resource r : res) {
                ((Map)resources.get(scope.toString())).put(r.getName(), r);
            }
        }
        logger.info("number of generic resource : " + resources.size());
        FieldModel.processResources(resources);
        logger.info("Processed field model generic resources: " + (mainResource != null ? "1" : "0") + " field directory resources containing " + fieldIds.size() + " field references, " + fieldResources.keySet().size() + " field resources, " + (metadataResource != null ? "1" : "0") + " element metadata resources, " + (staticConfigResource != null ? "1" : "0") + " static configuration resources.");
    }

    public static String getMainResource() {
        if (mainResource == null || FieldModel.getStringOfElement(mainResource.getBody()) == null || FieldModel.getStringOfElement(mainResource.getBody()).trim().length() == 0) {
            return null;
        }
        return FieldModel.getStringOfElement(mainResource.getBody());
    }

    public static String getMetadataResource() {
        if (metadataResource == null || FieldModel.getStringOfElement(metadataResource.getBody()) == null || FieldModel.getStringOfElement(metadataResource.getBody()).trim().length() == 0) {
            return null;
        }
        return FieldModel.getStringOfElement(metadataResource.getBody());
    }

    public static String getStaticConfigResource() {
        if (staticConfigResource == null || FieldModel.getStringOfElement(staticConfigResource.getBody()) == null || FieldModel.getStringOfElement(staticConfigResource.getBody()).trim().length() == 0) {
            return null;
        }
        return FieldModel.getStringOfElement(staticConfigResource.getBody());
    }

    public static Set<String> getFieldIds() {
        return fieldIds;
    }

    public static String getFieldResource(String id) {
        Resource fieldResource = fieldResources.get(id);
        if (fieldResource == null || FieldModel.getStringOfElement(fieldResource.getBody()) == null || FieldModel.getStringOfElement(fieldResource.getBody()).trim().length() == 0) {
            return null;
        }
        return FieldModel.getStringOfElement(fieldResource.getBody());
    }

    public static Resource getFieldResourceObj(String id) {
        Resource fieldResource = fieldResources.get(id);
        return fieldResource;
    }

    public static String getStringOfElement(Node node) {
        XPathEvaluator eval = new XPathEvaluator(node);
        String text = (String)eval.evaluate("/").get(0);
        text = text.substring("<doc>".length());
        text = text.substring(0, text.length() - "</doc>".length());
        return text;
    }

    static {
        fieldResources = new HashMap<String, Resource>();
        fieldIds = new HashSet<String>();
    }
}

