package gr.uoa.di.madgik.rr.element.search.index;

import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.IDaoElement;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;

import org.w3c.dom.Element;

public abstract class DataSourceDao implements IDaoElement
{	
	private String ID;
	private long timestamp=Calendar.getInstance().getTimeInMillis();
	private String type;
	private String functionality;
	private Set<String> boundDataSourceServices;
	private Set<String> scopes=new HashSet<String>();
	private Set<String> fields=new HashSet<String>();
	private Set<String> capabilities=new HashSet<String>();
	
	public String getID()
	{
		return ID;
	}

	public void setID(String iD)
	{
		ID = iD;
	}

	public long getTimestamp()
	{
		return timestamp;
	}
	
	public void setTimestamp(long timestamp)
	{
		this.timestamp = timestamp;
	}
	
	public String getType()
	{
		return type;
	}
	
	public void setType(String type)
	{
		this.type = type;
	}
	
	public Set<String> getBoundDataSourceServices()
	{
		return this.boundDataSourceServices;
	}
	
	public void setBoundDataSourceServices(Set<String> boundDataSourceServices)
	{
		this.boundDataSourceServices = boundDataSourceServices;
	}
	
	public Set<String> getScopes()
	{
		return scopes;
	}

	public void setScopes(Set<String> scopes)
	{
		this.scopes = scopes;
	}
	
	public String getFunctionality()
	{
		return functionality;
	}

	public void setFunctionality(String functionality)
	{
		this.functionality = functionality;
	}
	
	public Set<String> getFields()
	{
		return fields;
	}

	public void setFields(Set<String> fields)
	{
		this.fields = fields;
	}

	public Set<String> getCapabilities()
	{
		return capabilities;
	}

	public void setCapabilities(Set<String> capabilities)
	{
		this.capabilities = capabilities;
	}

	public void apply(IDaoElement target) throws ResourceRegistryException
	{
		if(!(target instanceof DataSourceDao)) throw new ResourceRegistryException("cannot apply to target of "+target);
		this.setID(((DataSourceDao)target).getID());
		this.setFunctionality(((DataSourceDao)target).getFunctionality());
		this.setType(((DataSourceDao)target).getType());
		this.setFields(((DataSourceDao)target).getFields());
		this.setCapabilities(((DataSourceDao)target).getCapabilities());
		this.setScopes(((DataSourceDao)target).getScopes());
	}
	
	public void fromXML(Element element) throws ResourceRegistryException
	{
		throw new ResourceRegistryException("This element does not support serialization operation");
	}

	public String toXML() throws ResourceRegistryException
	{
		throw new ResourceRegistryException("This element does not support serialization operation");
	}

	@Override
	public String toString()
	{
		return this.ID;
	}
}
