package gr.uoa.di.madgik.rr.element.search.index;

import java.util.Calendar;

import org.w3c.dom.Element;

import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.IDaoElement;

public class FieldIndexContainerDao implements IDaoElement
{
	private String ID;
	private long timestamp = Calendar.getInstance().getTimeInMillis();
	private String collection;
	private String language;
	private String field;
	private String fieldType="s";
	private String expression;

	public String getID()
	{
		return ID;
	}

	public void setID(String iD)
	{
		ID = iD;
	}

	public long getTimestamp()
	{
		return timestamp;
	}
	
	public void setTimestamp(long timestamp)
	{
		this.timestamp = timestamp;
	}
	
	public String getFieldType()
	{
		return fieldType;
	}

	public void setFieldType(String fieldType)
	{
		if(fieldType==null) this.fieldType="s";
		else if(fieldType.equalsIgnoreCase("s")) this.fieldType="s";
		else this.fieldType = "p";
	}

	public String getCollection()
	{
		return collection;
	}

	public void setCollection(String collection)
	{
		this.collection = collection;
	}

	public String getLanguage()
	{
		return language;
	}

	public void setLanguage(String language)
	{
		this.language = language;
	}

	public String getField()
	{
		return field;
	}

	public void setField(String field)
	{
		this.field = field;
	}

	public String getExpression()
	{
		return expression;
	}
	
	public void setExpression(String expression)
	{
		this.expression = expression;
	}
	
	public void apply(IDaoElement target) throws ResourceRegistryException
	{
		if(!(target instanceof FieldIndexContainerDao)) throw new ResourceRegistryException("cannot apply to target of "+target);
		this.setID(((FieldIndexContainerDao)target).getID());
		this.setCollection(((FieldIndexContainerDao)target).getCollection());
		this.setField(((FieldIndexContainerDao)target).getField());
		this.setFieldType(((FieldIndexContainerDao)target).getFieldType());
		this.setLanguage(((FieldIndexContainerDao)target).getLanguage());
		this.setExpression(((FieldIndexContainerDao)target).getExpression());
	}
	
	public void fromXML(Element element) throws ResourceRegistryException
	{
		throw new ResourceRegistryException("This element does not support serialization operation");
	}

	public String toXML() throws ResourceRegistryException
	{
		throw new ResourceRegistryException("This element does not support serialization operation");
	}

}
