package gr.uoa.di.madgik.rr.element.search.index;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.RRContext.DatastoreType;

import java.util.List;

public class GeoIndexService extends DataSourceService
{
	public GeoIndexService() throws ResourceRegistryException
	{
		super(GeoIndexServiceDao.class);
		setType(Type.GeoIndex);
	}
	
	@Override
	public String deepToString()
	{
		StringBuilder buf=new StringBuilder();
		buf.append("GeoIndexService - ID : "+this.getID()+"\n");
		buf.append("GeoIndexService - Endpoint: "+this.getEndpoint()+"\n");
		buf.append("GeoIndexService - Hosting Node: "+this.getHostingNode()+"\n");
		buf.append("GeoIndexService - Functionality : "+this.getFunctionality()+"\n");
		buf.append("GeoIndexService - Scopes : ");
		for(String scope : this.getScopes()) buf.append(scope+" "); 
		return buf.toString();
	}
	
	@Override
	public boolean exists(RRContext.DatastoreType persistencyType) throws ResourceRegistryException
	{
		return exists(GeoIndexServiceDao.class, persistencyType);
	}

	
	public static List<DataSourceService> getAll(boolean loadDetails) throws ResourceRegistryException
	{
		return DataSourceService.getAll(GeoIndexServiceDao.class, DatastoreType.LOCAL, loadDetails);
	}

	public static List<DataSourceService> getAll(boolean loadDetails, DatastoreType persistencyType) throws ResourceRegistryException
	{
		return DataSourceService.getAll(GeoIndexServiceDao.class, persistencyType, loadDetails);
	}
	
	public static DataSourceService getById(boolean loadDetails, String id) throws ResourceRegistryException 
	{
		GeoIndexService f = new GeoIndexService();
		f.setID(id);
		return f.load(loadDetails) == true ? f : null;
	}
}
