package gr.uoa.di.madgik.rr.element.search.index;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.RRContext.DatastoreType;

public class FWIndex extends DataSource {

	public static Logger logger = Logger.getLogger(FWIndex.class.getName());
	
	public FWIndex() throws ResourceRegistryException
	{
		super(FWIndexDao.class, FWIndexService.class);
		super.setType(Type.ForwardIndex);
	}
	
	@Override
	public String deepToString()
	{
		StringBuilder buf=new StringBuilder();
		buf.append("FWIndex - ID : "+this.getID()+"\n");
		buf.append("FWIndex - Functionality : "+this.getFunctionality()+"\n");
		buf.append("FWIndex - Scopes : ");
		for(String scope : this.getScopes()) buf.append(scope+" "); 
		buf.append("\nFWIndex - Capabilities : ");
		for(String cap : this.getCapabilities()) buf.append(cap+" "); 
		buf.append("\nFWIndex - Fields : "+"\n");
		for(FieldIndexContainer cap : this.getFieldInfo()) buf.append(cap.deepToString()+"\n"); 
		return buf.toString();
	}
	
	@Override
	public boolean exists(RRContext.DatastoreType persistencyType) throws ResourceRegistryException
	{
		return exists(FWIndexDao.class, persistencyType);
	}

	public static List<DataSource> getAll(boolean loadDetails) throws ResourceRegistryException
	{
		return DataSource.getAll(FWIndexDao.class, DatastoreType.LOCAL, loadDetails);
	}
	
	public static List<DataSource> getAll(boolean loadDetails, DatastoreType persistencyType) throws ResourceRegistryException
	{
		return DataSource.getAll(FWIndexDao.class, persistencyType, loadDetails);
	}
	
	@Override
	public List<DataSourceService> getDataSourceServices() throws ResourceRegistryException
	{
		if(this.boundDataSourceServices == null)
		{
			if(this.item.getBoundDataSourceServices() != null)
			{
				List<DataSourceService> ret = new ArrayList<DataSourceService>();
				for(String ds : this.item.getBoundDataSourceServices())
				{
					DataSourceService s = FWIndexService.getById(true, ds);
					if(s != null) ret.add(s);
					else logger.log(Level.WARNING, "Could not find bound forward index service with id " + ds);
				}
				this.boundDataSourceServices = ret;
				return ret;
			}else
			{
				return FWIndexService.getAll(true);
			}
		}else
			return this.boundDataSourceServices;
	}
	

	public static DataSource getById(boolean loadDetails, String id) throws ResourceRegistryException 
	{
		FWIndex f = new FWIndex();
		f.setID(id);
		return f.load(loadDetails) == true ? f : null;
	}
}
