/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.plugins.impl;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.config.StaticConfiguration;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.FieldDao;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.PresentableDao;
import gr.uoa.di.madgik.rr.plugins.Plugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PresentationInfoManagerPlugin
extends Plugin {
    private static Logger logger = Logger.getLogger(PresentationInfoManagerPlugin.class.getName());
    private Set<String> keywordGroups = new HashSet<String>();

    public PresentationInfoManagerPlugin() {
        this.type = Plugin.Type.PRE_UPDATE;
        this.processedItems.add(new Plugin.ProcessedItemType(Field.class, RRContext.DatastoreType.LOCAL));
    }

    public void setup() throws ResourceRegistryException {
    }

    public void readConfiguration(String prefix, Properties properties) throws ResourceRegistryException {
        if (properties == null) {
            return;
        }
        String keywordGroupCountProp = properties.getProperty(prefix + ".keywordGroupCount");
        if (keywordGroupCountProp == null) {
            throw new ResourceRegistryException("keywordGroupCount property not found");
        }
        int keywordGroupCount = Integer.parseInt(keywordGroupCountProp);
        for (int i = 0; i < keywordGroupCount; ++i) {
            String keywordGroup = properties.getProperty(prefix + ".keywordGroup." + i);
            if (keywordGroup == null) {
                throw new ResourceRegistryException("Could not find keyword group #" + i);
            }
            this.keywordGroups.add(keywordGroup);
            logger.info("Added keyword group: " + keywordGroup);
        }
        if (this.keywordGroups.isEmpty()) {
            logger.warning("No keyword groups were found");
        }
    }

    private List<Field> getFields() throws ResourceRegistryException {
        Set fields = (Set)this.items.get(new Plugin.ProcessedItemType(Field.class, RRContext.DatastoreType.LOCAL));
        if (fields == null) {
            return Field.getAll((boolean)false, (RRContext.DatastoreType)RRContext.DatastoreType.LOCAL);
        }
        return new ArrayList<Field>(fields);
    }

    protected void execute(Set<Class<?>> targets) throws ResourceRegistryException {
        logger.log(Level.INFO, "Executing " + this.type + " plugin: " + ((Object)((Object)this)).getClass().getName());
        boolean locked = false;
        Lock writeLock = ResourceRegistry.getContext().getExclusiveLock();
        try {
            if (!targets.contains(FieldDao.class) || !targets.contains(PresentableDao.class)) {
                logger.warning("Targets do not contain " + FieldDao.class.getName() + " or " + PresentableDao.class.getName() + ". Nothing to do.");
                return;
            }
            if (this.keywordGroups.isEmpty()) {
                logger.warning("No keyword groups to propagate");
                return;
            }
            HashSet keywords = new HashSet();
            for (String keywordGroup : this.keywordGroups) {
                keywords.addAll(StaticConfiguration.getInstance().getPresentationInfoKeywords(keywordGroup));
            }
            List<Field> allFields = this.getFields();
            for (Field f : allFields) {
                for (Presentable p : f.getPresentables()) {
                    boolean updated = false;
                    p.load(false, RRContext.DatastoreType.LOCAL);
                    for (String keyword : keywords) {
                        if (p.getPresentationInfo().contains(keyword)) continue;
                        p.getPresentationInfo().add(keyword);
                        logger.info("Added presentation info keyword \"" + keyword + " to presentable " + p.getID() + " of field " + p.getField());
                        updated = true;
                    }
                    if (!updated) continue;
                    p.store(false, RRContext.DatastoreType.LOCAL);
                }
            }
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("could not align incoming elements", (Throwable)ex);
        }
        finally {
            if (locked) {
                writeLock.unlock();
            }
        }
    }
}

