/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.plugins.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadata;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadataDao;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.FieldDao;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.PresentableDao;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import gr.uoa.di.madgik.rr.element.search.SearchableDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainerDao;
import gr.uoa.di.madgik.rr.plugins.Plugin;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldUpdaterPlugin
extends Plugin {
    private static final Logger logger = LoggerFactory.getLogger(FieldUpdaterPlugin.class);
    public static Cache<CacheElement, Boolean> elementCache = null;

    public FieldUpdaterPlugin() {
        this.type = Plugin.Type.POST_RETRIEVE;
        this.processedItems.add(new Plugin.ProcessedItemType(Field.class, RRContext.DatastoreType.LOCALBUFFER));
        this.processedItems.add(new Plugin.ProcessedItemType(DataSource.class, RRContext.DatastoreType.LOCALBUFFER));
        this.processedItems.add(new Plugin.ProcessedItemType(ElementMetadataDao.class, RRContext.DatastoreType.LOCALBUFFER));
        this.processedItems.add(new Plugin.ProcessedItemType(FieldIndexContainerDao.class, RRContext.DatastoreType.LOCALBUFFER));
    }

    public void setup() throws ResourceRegistryException {
        Field.getBehavior().setMarkDeletion(true);
        Field.getBehavior().setMarkUpdate(true);
    }

    private List<Field> getFields() throws ResourceRegistryException {
        Set fields = (Set)this.items.get(new Plugin.ProcessedItemType(Field.class, RRContext.DatastoreType.LOCALBUFFER));
        if (fields == null) {
            return Field.getAll((boolean)true, (RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER);
        }
        return new ArrayList<Field>(fields);
    }

    private List<DataSource> getDataSources() throws ResourceRegistryException {
        Set datasources = (Set)this.items.get(new Plugin.ProcessedItemType(DataSource.class, RRContext.DatastoreType.LOCALBUFFER));
        if (datasources == null) {
            return DataSource.getAll((boolean)false, (RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER);
        }
        return new ArrayList<DataSource>(datasources);
    }

    private Set<IDaoElement> getElementMetadata() throws ResourceRegistryException {
        Set elMetadata = (Set)this.itemDaos.get(new Plugin.ProcessedItemType(ElementMetadataDao.class, RRContext.DatastoreType.LOCALBUFFER));
        try {
            if (elMetadata == null) {
                return DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER, ElementMetadataDao.class);
            }
        }
        catch (Exception e) {
            throw new ResourceRegistryException("", (Throwable)e);
        }
        return elMetadata;
    }

    private Set<IDaoElement> getFieldIndexContainer() throws ResourceRegistryException {
        Set fic = (Set)this.itemDaos.get(new Plugin.ProcessedItemType(FieldIndexContainerDao.class, RRContext.DatastoreType.LOCALBUFFER));
        try {
            if (fic == null) {
                return DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER, FieldIndexContainerDao.class);
            }
        }
        catch (Exception e) {
            throw new ResourceRegistryException("", (Throwable)e);
        }
        return fic;
    }

    protected void execute(Set<Class<?>> targets) throws ResourceRegistryException {
        elementCache = CacheBuilder.newBuilder().maximumSize(5000L).expireAfterWrite(30L, TimeUnit.MINUTES).build();
        logger.info("Executing " + this.type + " plugin: " + ((Object)((Object)this)).getClass().getName());
        boolean locked = false;
        Lock writeLock = ResourceRegistry.getContext().getExclusiveLock();
        try {
            boolean updateMode = !targets.contains(FieldDao.class) || !targets.contains(SearchableDao.class) || !targets.contains(PresentableDao.class);
            RRContext.DatastoreType datastoreType = ResourceRegistry.isInitialBridgingComplete() && updateMode ? RRContext.DatastoreType.LOCAL : RRContext.DatastoreType.LOCALBUFFER;
            List<Field> allFields = this.getFields();
            List<DataSource> allDataSources = this.getDataSources();
            Set<IDaoElement> allMetadata = this.getElementMetadata();
            HashMap<String, IDaoElement> metadataMap = new HashMap<String, IDaoElement>();
            for (IDaoElement iDaoElement : allMetadata) {
                if (metadataMap.get(iDaoElement.getID()) != null) {
                    logger.warn("metadata element " + iDaoElement.getID() + " already in map");
                }
                metadataMap.put(iDaoElement.getID(), iDaoElement);
            }
            HashMap<String, DataSource> datasourcesMap = new HashMap<String, DataSource>();
            for (DataSource datasource : allDataSources) {
                if (datasourcesMap.get(datasource.getID()) != null) {
                    logger.warn("datasource element " + datasource.getID() + " already in map");
                }
                datasourcesMap.put(datasource.getID(), datasource);
            }
            HashMap<String, Field> hashMap = new HashMap<String, Field>();
            HashMap<String, Field> fieldNames = new HashMap<String, Field>();
            logger.info("fields size : " + allFields.size());
            for (Field field : allFields) {
                hashMap.put(field.getID(), field);
                fieldNames.put(field.getName(), field);
            }
            logger.info("fieldIDs   : " + hashMap.keySet());
            logger.info("fieldNames : " + fieldNames.keySet());
            if (targets.contains(FieldIndexContainerDao.class)) {
                Set<IDaoElement> elems = this.getFieldIndexContainer();
                HashSet<Class<FieldIndexContainerDao>> purge = new HashSet<Class<FieldIndexContainerDao>>();
                purge.add(FieldIndexContainerDao.class);
                DatastoreHelper.clear((RRContext.DatastoreType)RRContext.DatastoreType.LOCALBUFFER, purge);
                logger.info("will run update for : " + elems.size() + " elements");
                HashMap<String, IDaoElement> elementMap = new HashMap<String, IDaoElement>();
                for (IDaoElement el : elems) {
                    if (elementMap.get(((FieldIndexContainerDao)el).getField()) != null) {
                        logger.warn("************ element " + ((FieldIndexContainerDao)el).getField() + " already in map");
                    }
                    elementMap.put(((FieldIndexContainerDao)el).getField(), el);
                }
                for (IDaoElement el : elems) {
                    FieldIndexContainerDao fic;
                    if (!(el instanceof FieldIndexContainerDao)) continue;
                    String fieldName = ((FieldIndexContainerDao)el).getField();
                    logger.info("field update : " + fieldName);
                    Field f = null;
                    f = (Field)hashMap.get(fieldName);
                    if (f == null) {
                        f = (Field)fieldNames.get(fieldName);
                    }
                    Field updatedField = null;
                    updatedField = this.updateField(f, (FieldIndexContainerDao)el, datasourcesMap, metadataMap, datastoreType, hashMap, fieldNames);
                    if (f != null || updatedField == null || (fic = (FieldIndexContainerDao)elementMap.get(updatedField.getName())) == null) continue;
                    fic.setField(updatedField.getID());
                }
                DatastoreHelper.bufferItems(elems);
            }
        }
        catch (Exception ex) {
            throw new ResourceRegistryException("could not align incoming elements", (Throwable)ex);
        }
        finally {
            if (locked) {
                writeLock.unlock();
            }
        }
    }

    private static boolean isDeletedSearchableOrPresentable(ElementMetadataDao elMetadata, String fieldID, String searchableID, String locator) {
        CacheElement ce = new CacheElement();
        ce.metadataID = elMetadata.getID();
        ce.locator = locator;
        ce.searchableID = searchableID;
        ce.fieldID = fieldID;
        Boolean result = (Boolean)elementCache.getIfPresent((Object)ce);
        if (result == null) {
            result = FieldUpdaterPlugin.computeIsDeletedSearchableOrPresentable(elMetadata, fieldID, searchableID, locator);
            elementCache.put((Object)ce, (Object)result);
        }
        return result;
    }

    private static boolean computeIsDeletedSearchableOrPresentable(ElementMetadataDao elMetadata, String fieldID, String searchableID, String locator) {
        logger.trace("elMetadata id : " + elMetadata.getID() + " searchableID  : " + searchableID + " fieldID : " + fieldID);
        logger.trace("elMetadata id : " + elMetadata.getID() + " DeletedElement property keys   : " + elMetadata.getPropertyKeys());
        logger.trace("elMetadata id : " + elMetadata.getID() + " DeletedElement property values : " + elMetadata.getPropertyValues());
        for (String value : elMetadata.getPropertyValues()) {
            if (!value.toLowerCase().contains(searchableID.toLowerCase())) continue;
            logger.trace("elMetadata id : " + elMetadata.getID() + " found match at value : " + value);
            return true;
        }
        boolean locatorFound = false;
        boolean fieldFound = false;
        for (String value : elMetadata.getPropertyValues()) {
            if (!value.toLowerCase().contains(fieldID.toLowerCase())) continue;
            logger.trace("elMetadata id : " + elMetadata.getID() + " found match at value : " + value);
            fieldFound = true;
        }
        for (String value : elMetadata.getPropertyValues()) {
            if (!value.toLowerCase().contains(locator.toLowerCase())) continue;
            logger.trace("elMetadata id : " + elMetadata.getID() + " found match at value : " + value);
            locatorFound = true;
        }
        if (fieldFound && locatorFound) {
            return true;
        }
        return elMetadata.getID().equalsIgnoreCase(searchableID);
    }

    private static String getDeletedID(ElementMetadataDao elMetadata) {
        return elMetadata.getID();
    }

    private Field updateField(Field f, FieldIndexContainerDao el, Map<String, DataSource> datasourcesMap, Map<String, IDaoElement> metadataMap, RRContext.DatastoreType datastoreType, Map<String, Field> fieldIDs, Map<String, Field> fieldNames) throws ResourceRegistryException {
        String locator = el.getID().split(":")[0];
        Field updatedField = new Field();
        if (f == null) {
            ElementMetadataDao elMetadata = (ElementMetadataDao)metadataMap.get(el.getField());
            if (elMetadata != null && elMetadata.getType().toString().equalsIgnoreCase(ElementMetadata.Type.DeletedField.toString())) {
                logger.info("field with id : " + el.getField() + " has been deleted. Update is not done");
                return null;
            }
            updatedField.setName(el.getField());
            updatedField.store(true, datastoreType);
            logger.info("Created new field: " + el.getField());
            f = updatedField;
            fieldIDs.put(f.getID(), f);
            fieldNames.put(f.getName(), f);
        } else {
            updatedField = new Field();
            updatedField.setID(f.getID());
            updatedField.setDescription(f.getDescription());
            updatedField.setName(f.getName());
            updatedField.getSearchables().addAll(f.getSearchables());
            updatedField.getPresentables().addAll(f.getPresentables());
        }
        boolean found = false;
        boolean update = false;
        boolean deletedSearchable = false;
        boolean deletedPresentable = false;
        if (el.getFieldType().equals("s")) {
            ArrayList<Searchable> toBeRemoved = new ArrayList<Searchable>();
            block0: for (Object s : updatedField.getSearchables()) {
                for (IDaoElement metadata : metadataMap.values()) {
                    ElementMetadataDao elMetadata = (ElementMetadataDao)metadata;
                    if (!elMetadata.getType().toString().equalsIgnoreCase(ElementMetadata.Type.DeletedSearchable.toString()) || !FieldUpdaterPlugin.isDeletedSearchableOrPresentable(elMetadata, f.getID(), s.getID(), locator)) continue;
                    logger.info("Searchable for field: " + f.getName() + " : " + f.getID() + " has been deleted. searchable id :" + s.getID());
                    logger.info("Searchables before remove : " + updatedField.getSearchables().size());
                    for (Searchable ss : updatedField.getSearchables()) {
                        if (ss.getID().equalsIgnoreCase(s.getID())) {
                            toBeRemoved.add(ss);
                            logger.info("found what should be deleted. id: " + ss.getID() + " in searchables? : " + updatedField.getSearchables().contains(toBeRemoved));
                        }
                        logger.trace("ss before remove : " + ss.getID());
                    }
                    deletedSearchable = true;
                    update = true;
                    continue block0;
                }
                if (!s.getCollection().equals(el.getCollection()) || !s.getLocator().equals(locator)) continue;
                found = true;
                break;
            }
            if (toBeRemoved.size() == 0) {
                logger.trace(" toBeRemoved not found!");
            } else {
                int sizeBeforeDelete = updatedField.getSearchables().size();
                logger.trace("removing toBeRemoved with ids : " + toBeRemoved);
                updatedField.getSearchables().removeAll(toBeRemoved);
                logger.trace("Searchables after remove : " + updatedField.getSearchables().size());
                if (logger.isTraceEnabled()) {
                    for (Searchable ss : updatedField.getSearchables()) {
                        logger.trace("ss after remove : " + ss.getID());
                    }
                }
                int sizeAfterDelete = updatedField.getSearchables().size();
                logger.info("before and after removal : " + sizeBeforeDelete + " - " + sizeAfterDelete);
            }
            if (!found && !deletedSearchable) {
                DataSource ds = datasourcesMap.get(locator);
                if (ds == null) {
                    logger.warn("datasources dont contain : " + locator + ". all datasources : " + datasourcesMap.keySet());
                } else {
                    Object s;
                    s = new Searchable();
                    s.setCollection(el.getCollection());
                    s.setField(f.getID());
                    s.setLocator(locator);
                    s.setExpression(el.getExpression());
                    s.getCapabilities().addAll(ds.getCapabilities());
                    s.setDatasourceScopes(ds.getScopes());
                    s.store(true, datastoreType);
                    f.getSearchables().add(s);
                    updatedField.getSearchables().add(s);
                    logger.info("Added new searchable to field " + f.getName() + " (" + f.getID() + ") for collection " + s.getCollection() + " and data source " + s.getLocator());
                    update = true;
                }
            }
        } else {
            ArrayList<Presentable> toBeRemoved = new ArrayList<Presentable>();
            block4: for (Object p : updatedField.getPresentables()) {
                for (IDaoElement metadata : metadataMap.values()) {
                    ElementMetadataDao elMetadata = (ElementMetadataDao)metadata;
                    if (!elMetadata.getType().toString().equalsIgnoreCase(ElementMetadata.Type.DeletedPresentable.toString()) || !FieldUpdaterPlugin.isDeletedSearchableOrPresentable(elMetadata, f.getID(), p.getID(), locator)) continue;
                    logger.trace("Presentalbe for field: " + f.getName() + " : " + f.getID() + " has been deleted. presentable id :" + p.getID());
                    logger.info("Presentables before remove : " + updatedField.getSearchables().size());
                    for (Presentable pp : updatedField.getPresentables()) {
                        if (pp.getID().equalsIgnoreCase(p.getID())) {
                            toBeRemoved.add(pp);
                            logger.info("found what should be deleted. id: " + pp.getID() + " in presentables? : " + updatedField.getPresentables().contains(toBeRemoved));
                        }
                        logger.info("pp before remove : " + pp.getID());
                    }
                    logger.trace("will remove presentable with id : " + p.getID());
                    deletedPresentable = true;
                    update = true;
                    continue block4;
                }
                if (!p.getCollection().equals(el.getCollection()) || !p.getLocator().equals(locator)) continue;
                found = true;
                break;
            }
            if (toBeRemoved.size() == 0) {
                logger.trace(" toBeRemoved not found!");
            } else {
                int sizeBeforeDelete = updatedField.getPresentables().size();
                logger.trace("removing toBeRemoved with ids : " + toBeRemoved);
                updatedField.getPresentables().removeAll(toBeRemoved);
                logger.trace("Presentables after remove : " + updatedField.getPresentables().size());
                if (logger.isTraceEnabled()) {
                    for (Presentable pp : updatedField.getPresentables()) {
                        logger.trace("pp after remove : " + pp.getID());
                    }
                }
                int sizeAfterDelete = updatedField.getPresentables().size();
                logger.info("before and after removal : " + sizeBeforeDelete + " - " + sizeAfterDelete);
            }
            if (!found && !deletedPresentable) {
                DataSource ds = datasourcesMap.get(locator);
                if (ds == null) {
                    logger.warn("datasources dont contain : " + locator + ". all datasources : " + datasourcesMap.keySet());
                } else {
                    Presentable p = new Presentable();
                    p.setCollection(el.getCollection());
                    p.setField(f.getID());
                    p.setLocator(locator);
                    p.setDatasourceScopes(ds.getScopes());
                    p.store(true, datastoreType);
                    f.getPresentables().add(p);
                    updatedField.getPresentables().add(p);
                    logger.info("Added new presentable to field " + f.getName() + " (" + f.getID() + ") for collection " + p.getCollection() + " and data source " + p.getLocator());
                    update = true;
                }
            }
        }
        logger.trace("After Field Update : ");
        logger.trace("searchables  size : " + f.getSearchables().size());
        logger.trace("presentables size : " + f.getPresentables().size());
        if (update || deletedPresentable || deletedSearchable) {
            updatedField.store(true, datastoreType);
        }
        return updatedField;
    }

    static class CacheElement {
        String metadataID;
        String fieldID;
        String searchableID;
        String locator;

        CacheElement() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.fieldID == null ? 0 : this.fieldID.hashCode());
            result = 31 * result + (this.locator == null ? 0 : this.locator.hashCode());
            result = 31 * result + (this.metadataID == null ? 0 : this.metadataID.hashCode());
            result = 31 * result + (this.searchableID == null ? 0 : this.searchableID.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheElement other = (CacheElement)obj;
            if (this.fieldID == null ? other.fieldID != null : !this.fieldID.equals(other.fieldID)) {
                return false;
            }
            if (this.locator == null ? other.locator != null : !this.locator.equals(other.locator)) {
                return false;
            }
            if (this.metadataID == null ? other.metadataID != null : !this.metadataID.equals(other.metadataID)) {
                return false;
            }
            return !(this.searchableID == null ? other.searchableID != null : !this.searchableID.equals(other.searchableID));
        }
    }
}

