/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.urlresolutionlibrary.nonstreamable;

import gr.uoa.di.madgik.urlresolutionlibrary.exceptions.ParseException;
import gr.uoa.di.madgik.urlresolutionlibrary.nonstreamable.NonStreamable;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.globus.ftp.DataSink;
import org.globus.ftp.FileRandomIO;
import org.globus.ftp.GridFTPClient;

public class GridFTPLocator
implements NonStreamable {
    private static Logger logger = Logger.getLogger(GridFTPLocator.class.getName());
    public static final String GRIDFTP_PROTOCOL = "gridftp";
    private static final String ANONYMOUS_USERNAME = "anonymous";
    private static final String ANONYMOUS_PASSWORD = "";
    private static final int DEFAULT_GRIDFTP_PORT = 21;
    private int port = 21;
    private String username = "anonymous";
    private String password = "";
    private String host;
    private String path;
    private File tempFile;

    public GridFTPLocator(String url) throws ParseException {
        this.parseURI(url);
    }

    private void parseURI(String url) throws ParseException {
        String[] parts;
        String tmpUri = url.trim();
        if (!tmpUri.startsWith("gridftp://")) {
            throw new ParseException("url is not in gridftp format");
        }
        if ((tmpUri = tmpUri.substring("gridftp://".length())).contains("@")) {
            int atIdx = tmpUri.lastIndexOf(64);
            if (atIdx >= tmpUri.length()) {
                throw new ParseException("url not in gridftp format. No username and/or password");
            }
            String credentials = tmpUri.substring(0, atIdx);
            String hostpath = tmpUri.substring(atIdx + 1, tmpUri.length());
            String[] parts2 = credentials.split(":");
            if (parts2 == null || parts2.length != 2) {
                throw new ParseException("url not in gridftp format. No username and/or password");
            }
            this.username = parts2[0];
            this.password = parts2[1];
            tmpUri = hostpath;
        }
        if ((parts = tmpUri.split("/", 2))[0].contains(":")) {
            String[] parts1 = parts[0].split(":");
            this.host = parts1[0];
            this.port = Integer.parseInt(parts1[1]);
        } else {
            this.host = parts[0];
        }
        if (parts.length == 2) {
            this.path = parts[1];
        }
        logger.log(Level.INFO, "Parsing results for : " + url);
        logger.log(Level.INFO, "Host \t : " + this.host);
        logger.log(Level.INFO, "Port \t : " + this.port);
        logger.log(Level.INFO, "Username : " + this.username);
        logger.log(Level.INFO, "Password : " + this.password);
        logger.log(Level.INFO, "Path \t : " + this.path);
    }

    @Override
    public void download() throws Exception {
        GridFTPClient client = new GridFTPClient(this.host, this.port);
        try {
            client.authorize(this.username, this.password);
        }
        catch (Exception e) {
            throw new Exception("Client authorize exception", e);
        }
        this.tempFile = File.createTempFile(GRIDFTP_PROTOCOL, "file");
        FileRandomIO ds = new FileRandomIO(new RandomAccessFile(this.tempFile, "rw"));
        long sourceFileSize = client.getSize(this.path);
        client.extendedGet(this.path, sourceFileSize, (DataSink)ds, null);
        client.close();
    }

    @Override
    public File getFile() {
        return this.tempFile;
    }
}

