/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.urlresolutionlibrary.streamable;

import gr.uoa.di.madgik.urlresolutionlibrary.exceptions.ParseException;
import gr.uoa.di.madgik.urlresolutionlibrary.streamable.Streamable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalFileLocator
implements Streamable {
    private static Logger logger = Logger.getLogger(LocalFileLocator.class.getName());
    public static final String LOCALFILE_PROTOCOL = "file";
    private String url;
    private String path = "/";
    private InputStream is;

    public LocalFileLocator(String uri) throws ParseException {
        this.url = uri;
        this.parseURL(this.url);
    }

    private void parseURL(String url) throws ParseException {
        String tmpUrl = url.trim();
        if (!tmpUrl.startsWith("file://")) {
            throw new ParseException("uri is not in local file format");
        }
        this.path = tmpUrl.substring("file://".length());
        logger.log(Level.INFO, "Parsing results for : " + url);
        logger.log(Level.INFO, "Path \t : " + this.path);
    }

    @Override
    public InputStream getInputStream() throws Exception {
        this.is = new FileInputStream(this.path);
        return this.is;
    }

    @Override
    public void close() {
        try {
            this.is.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Local File Locator inputstream close failed", e);
        }
    }
}

