/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.adaptor.utils.grid;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionExternalProgressReportStateEvent;
import gr.uoa.di.madgik.execution.event.ExecutionStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.filter.IExternalFilter;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JobLogInfoFilter
implements IExternalFilter {
    private static Logger logger = LoggerFactory.getLogger(JobLogInfoFilter.class);
    public String JobLogInfoVariableName = null;
    public String PlanNodeID = null;
    private String LastEvent = null;
    private boolean ReachedLastEvent = false;

    public Set<String> GetInputVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.JobLogInfoVariableName);
        return vars;
    }

    public Set<String> GetStoreOutputVariableName() {
        HashSet<String> vars = new HashSet<String>();
        return vars;
    }

    public boolean StoreOutput() {
        return false;
    }

    public void Validate() throws ExecutionValidationException {
        if (this.JobLogInfoVariableName == null || this.JobLogInfoVariableName.trim().length() == 0) {
            throw new ExecutionValidationException("Filtered parameter names cannot be empty or null");
        }
        if (this.PlanNodeID == null || this.PlanNodeID.trim().length() == 0) {
            throw new ExecutionValidationException("Needed value not set");
        }
    }

    public void ValidateForOnlineFiltering() throws ExecutionValidationException {
        throw new ExecutionValidationException("On line filtering is not supported");
    }

    public void ValidatePreExecution(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.Validate();
        if (!Handle.GetPlan().Variables.Contains(this.JobLogInfoVariableName)) {
            throw new ExecutionValidationException("Needed parameter not found");
        }
        NamedDataType ndt = Handle.GetPlan().Variables.Get(this.JobLogInfoVariableName);
        if (!ndt.IsAvailable.booleanValue() && !ExcludeAvailableConstraint.contains(this.JobLogInfoVariableName)) {
            throw new ExecutionValidationException("Needed variable not available");
        }
    }

    public void ValidatePreExecutionForOnlineFiltering(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.ValidateForOnlineFiltering();
    }

    public boolean SupportsOnLineFiltering() {
        return false;
    }

    public Object Process(ExecutionHandle Handle) throws ExecutionRunTimeException {
        try {
            String currentPayload = null;
            logger.debug("Scanning log info");
            if (Handle.GetPlan().Config.ChokeProgressReporting) {
                return null;
            }
            this.ReachedLastEvent = false;
            String output = DataTypeUtils.GetValueAsString((Object)Handle.GetPlan().Variables.Get((String)this.JobLogInfoVariableName).Value.GetValue());
            logger.debug("Log info is : \n" + output);
            BufferedReader reader = new BufferedReader(new StringReader(output));
            boolean inRec = false;
            StringBuilder buf = new StringBuilder();
            while (true) {
                String line = reader.readLine();
                logger.debug("read line : " + line);
                if (line == null) break;
                if (!this.LineContainsPayload(line = line.trim())) continue;
                if (line.toLowerCase().startsWith("event:".toLowerCase())) {
                    String payload;
                    if (!inRec) {
                        inRec = true;
                        buf.append(line);
                        buf.append("\n");
                        continue;
                    }
                    currentPayload = payload = buf.toString();
                    if (this.ShouldSend(payload)) {
                        Handle.EmitEvent((ExecutionStateEvent)new ExecutionExternalProgressReportStateEvent(this.PlanNodeID, "glite-wms-job-logging-info parsed output", payload));
                    }
                    buf = new StringBuilder();
                    buf.append(line);
                    buf.append("\n");
                    continue;
                }
                if (!line.startsWith("-") || !inRec) continue;
                buf.append(line);
                buf.append("\n");
            }
            if (buf.length() != 0) {
                String payload;
                currentPayload = payload = buf.toString();
                if (this.ShouldSend(payload)) {
                    Handle.EmitEvent((ExecutionStateEvent)new ExecutionExternalProgressReportStateEvent(this.PlanNodeID, "glite-wms-job-logging-info parsed output", payload));
                }
            }
            this.LastEvent = currentPayload;
            logger.debug("Finished Scanning log info");
            return null;
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not retrieve job status", (Throwable)ex);
        }
    }

    private boolean ShouldSend(String payload) {
        if (this.LastEvent == null) {
            return true;
        }
        if (!this.ReachedLastEvent) {
            if (this.LastEvent.equals(payload)) {
                this.ReachedLastEvent = true;
            }
            return false;
        }
        return true;
    }

    private boolean LineContainsPayload(String line) {
        String tmp = new String(line);
        if (tmp == null || tmp.trim().length() == 0) {
            return false;
        }
        while (tmp.contains("-")) {
            tmp = tmp.replace('-', ' ');
        }
        if ((tmp = tmp.trim()) == null || tmp.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < tmp.length(); ++i) {
            if (Character.isWhitespace(tmp.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public Object ProcessOnLine(Object OnLineFilteredValue, Set<NamedDataType> AdditionalValueProviders, ExecutionHandle Handle) throws ExecutionRunTimeException {
        throw new ExecutionRunTimeException("On line filtering is not supported");
    }

    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<external type=\"" + this.getClass().getName() + "\">");
        buf.append("<filteredVariable name=\"" + this.JobLogInfoVariableName + "\"/>");
        buf.append("<planNodeID name=\"" + this.PlanNodeID + "\"/>");
        buf.append("</external>");
        return buf.toString();
    }

    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"type").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            Element tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"filteredVariable");
            if (!XMLUtils.AttributeExists((Element)tmp, (String)"name").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.JobLogInfoVariableName = XMLUtils.GetAttribute((Element)tmp, (String)"name");
            tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"planNodeID");
            if (!XMLUtils.AttributeExists((Element)tmp, (String)"name").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.PlanNodeID = XMLUtils.GetAttribute((Element)tmp, (String)"name");
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", (Throwable)ex);
        }
    }
}

