/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.adaptor.utils.jdl;

import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.ss.StorageSystem;
import gr.uoa.di.madgik.workflow.adaptor.utils.IAdaptorResources;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.AttachedJDLResource;
import gr.uoa.di.madgik.workflow.exception.WorkflowValidationException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdaptorJDLResources
implements IAdaptorResources {
    private static Logger logger = LoggerFactory.getLogger(AdaptorJDLResources.class);
    public Set<AttachedJDLResource> Resources = new HashSet<AttachedJDLResource>();

    public boolean ResourceExists(String ResourceKey) {
        for (AttachedJDLResource res : this.Resources) {
            if (!res.Key.equals(ResourceKey)) continue;
            return true;
        }
        return false;
    }

    public AttachedJDLResource GetResource(String ResourceKey) {
        for (AttachedJDLResource res : this.Resources) {
            if (!res.Key.equals(ResourceKey)) continue;
            return res;
        }
        return null;
    }

    public void StoreResources(EnvHintCollection Hints) throws Exception {
        block5: for (AttachedJDLResource att : this.Resources) {
            if (att.TypeOfResource != AttachedJDLResource.ResourceType.InData) continue;
            switch (att.ResourceLocationType) {
                case CMSReference: {
                    if (att.Value == null || att.Value.trim().length() == 0) {
                        throw new WorkflowValidationException("CMS id not provided for " + (Object)((Object)att.ResourceLocationType) + " provided attribute");
                    }
                    att.StorageSystemID = att.Value;
                    logger.debug("Stored CMSReference resource: key=" + att.Key + " ssid=" + att.StorageSystemID);
                    continue block5;
                }
                case Reference: {
                    if (att.StorageSystemID == null || att.StorageSystemID.trim().length() == 0) {
                        att.StorageSystemID = StorageSystem.Store((URL)new URL(att.Value), (EnvHintCollection)Hints);
                    }
                    logger.debug("Stored Reference resource: key=" + att.Key + " ref=" + att.Value + " ssid=" + att.StorageSystemID);
                    continue block5;
                }
                case LocalFile: {
                    if (att.StorageSystemID == null || att.StorageSystemID.trim().length() == 0) {
                        att.StorageSystemID = StorageSystem.Store((Object)att.Value, (EnvHintCollection)Hints);
                    }
                    logger.debug("Stored Local resource: key=" + att.Key + " ref=" + att.Value + " ssid=" + att.StorageSystemID);
                    continue block5;
                }
            }
            throw new WorkflowValidationException("Unrecognized resource type");
        }
    }
}

