/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.adaptor.utils.grid;

import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.ss.StorageSystem;
import gr.uoa.di.madgik.workflow.adaptor.utils.IAdaptorResources;
import gr.uoa.di.madgik.workflow.adaptor.utils.grid.AttachedGridResource;
import gr.uoa.di.madgik.workflow.exception.WorkflowValidationException;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class AdaptorGridResources
implements IAdaptorResources {
    public Set<AttachedGridResource> Resources = new HashSet<AttachedGridResource>();

    public void Validate() throws WorkflowValidationException {
        int configCount = 0;
        int jdlCount = 0;
        int proxyCount = 0;
        for (AttachedGridResource att : this.Resources) {
            if (att.TypeOfResource.equals((Object)AttachedGridResource.ResourceType.Config)) {
                ++configCount;
                continue;
            }
            if (att.TypeOfResource.equals((Object)AttachedGridResource.ResourceType.JDL)) {
                ++jdlCount;
                continue;
            }
            if (att.TypeOfResource.equals((Object)AttachedGridResource.ResourceType.OutData)) {
                File f = new File(att.Key);
                if (!f.isAbsolute()) continue;
                throw new WorkflowValidationException("Key value of OutData resource cannot be absolute path");
            }
            if (!att.TypeOfResource.equals((Object)AttachedGridResource.ResourceType.UserProxy)) continue;
            ++proxyCount;
        }
        if (configCount > 1) {
            throw new WorkflowValidationException("At most one config resource can be defined");
        }
        if (jdlCount != 1) {
            throw new WorkflowValidationException("Exactly one jdl resource must be defined");
        }
        if (proxyCount != 1) {
            throw new WorkflowValidationException("Exactly one user proxy resource must be defined");
        }
    }

    public boolean ResourceExists(String ResourceKey) {
        for (AttachedGridResource res : this.Resources) {
            if (!res.Key.equals(ResourceKey)) continue;
            return true;
        }
        return false;
    }

    public AttachedGridResource GetResource(String ResourceKey) {
        for (AttachedGridResource res : this.Resources) {
            if (!res.Key.equals(ResourceKey)) continue;
            return res;
        }
        return null;
    }

    public void StoreResources(Set<AttachedGridResource.ResourceType> ResourcesToStore, EnvHintCollection Hints) throws Exception {
        block5: for (AttachedGridResource att : this.Resources) {
            switch (att.ResourceLocationType) {
                case CMSReference: {
                    if ((att.Value == null || att.Value.trim().length() == 0) && ResourcesToStore.contains((Object)att.TypeOfResource)) {
                        throw new WorkflowValidationException("CMS id not provided for " + (Object)((Object)att.ResourceLocationType) + " provided attribute");
                    }
                    att.StorageSystemID = att.Value;
                    continue block5;
                }
                case Reference: {
                    if (att.StorageSystemID != null && att.StorageSystemID.trim().length() != 0 || !ResourcesToStore.contains((Object)att.TypeOfResource)) continue block5;
                    att.StorageSystemID = StorageSystem.Store((URL)new URL(att.Value), (EnvHintCollection)Hints);
                    continue block5;
                }
                case LocalFile: {
                    if (att.StorageSystemID != null && att.StorageSystemID.trim().length() != 0 || !ResourcesToStore.contains((Object)att.TypeOfResource)) continue block5;
                    att.StorageSystemID = StorageSystem.Store((Object)att.Value, (EnvHintCollection)Hints);
                    continue block5;
                }
            }
            throw new WorkflowValidationException("Unrecognized resource type");
        }
    }

    public AttachedGridResource GetScopeResource() {
        for (AttachedGridResource att : this.Resources) {
            if (!att.TypeOfResource.equals((Object)AttachedGridResource.ResourceType.Scope)) continue;
            return att;
        }
        return null;
    }

    public AttachedGridResource GetJDLResource() {
        for (AttachedGridResource att : this.Resources) {
            if (!att.TypeOfResource.equals((Object)AttachedGridResource.ResourceType.JDL)) continue;
            return att;
        }
        return null;
    }

    public AttachedGridResource GetConfigResource() {
        for (AttachedGridResource att : this.Resources) {
            if (!att.TypeOfResource.equals((Object)AttachedGridResource.ResourceType.Config)) continue;
            return att;
        }
        return null;
    }

    public AttachedGridResource GetUserProxyResource() {
        for (AttachedGridResource att : this.Resources) {
            if (!att.TypeOfResource.equals((Object)AttachedGridResource.ResourceType.UserProxy)) continue;
            return att;
        }
        return null;
    }

    public Set<AttachedGridResource> GetInDataResources() {
        HashSet<AttachedGridResource> ret = new HashSet<AttachedGridResource>();
        for (AttachedGridResource att : this.Resources) {
            if (!att.TypeOfResource.equals((Object)AttachedGridResource.ResourceType.InData)) continue;
            ret.add(att);
        }
        return ret;
    }

    public Set<AttachedGridResource> GetOutDataResources() {
        HashSet<AttachedGridResource> ret = new HashSet<AttachedGridResource>();
        for (AttachedGridResource att : this.Resources) {
            if (!att.TypeOfResource.equals((Object)AttachedGridResource.ResourceType.OutData)) continue;
            ret.add(att);
        }
        return ret;
    }
}

