/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.adaptor.utils.condor;

import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.ss.StorageSystem;
import gr.uoa.di.madgik.workflow.adaptor.utils.IAdaptorResources;
import gr.uoa.di.madgik.workflow.adaptor.utils.condor.AttachedCondorResource;
import gr.uoa.di.madgik.workflow.exception.WorkflowValidationException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class AdaptorCondorResources
implements IAdaptorResources {
    public Set<AttachedCondorResource> Resources = new HashSet<AttachedCondorResource>();

    public AttachedCondorResource GetScopeResource() {
        for (AttachedCondorResource att : this.Resources) {
            if (!att.TypeOfResource.equals((Object)AttachedCondorResource.ResourceType.Scope)) continue;
            return att;
        }
        return null;
    }

    public void Validate() throws WorkflowValidationException {
        int submitCount = 0;
        for (AttachedCondorResource att : this.Resources) {
            if (!att.TypeOfResource.equals((Object)AttachedCondorResource.ResourceType.Submit)) continue;
            ++submitCount;
        }
        if (submitCount != 1) {
            throw new WorkflowValidationException("Exactly one submit resource must be defined");
        }
    }

    public void StoreResources(Set<AttachedCondorResource.ResourceType> ResourcesToStore, EnvHintCollection Hints) throws Exception {
        block5: for (AttachedCondorResource att : this.Resources) {
            switch (att.ResourceLocationType) {
                case CMSReference: {
                    if ((att.Value == null || att.Value.trim().length() == 0) && ResourcesToStore.contains((Object)att.TypeOfResource)) {
                        throw new WorkflowValidationException("CMS id not provided for " + (Object)((Object)att.ResourceLocationType) + " provided attribute");
                    }
                    att.StorageSystemID = att.Value;
                    continue block5;
                }
                case Reference: {
                    if (att.StorageSystemID != null && att.StorageSystemID.trim().length() != 0 || !ResourcesToStore.contains((Object)att.TypeOfResource)) continue block5;
                    att.StorageSystemID = StorageSystem.Store((URL)new URL(att.Value), (EnvHintCollection)Hints);
                    continue block5;
                }
                case LocalFile: {
                    if (att.StorageSystemID != null && att.StorageSystemID.trim().length() != 0 || !ResourcesToStore.contains((Object)att.TypeOfResource)) continue block5;
                    att.StorageSystemID = StorageSystem.Store((Object)att.Value, (EnvHintCollection)Hints);
                    continue block5;
                }
            }
            throw new WorkflowValidationException("Unrecognized resource type");
        }
    }

    public Set<AttachedCondorResource> GetInDataResources() {
        HashSet<AttachedCondorResource> ret = new HashSet<AttachedCondorResource>();
        for (AttachedCondorResource att : this.Resources) {
            if (!att.TypeOfResource.equals((Object)AttachedCondorResource.ResourceType.InData)) continue;
            ret.add(att);
        }
        return ret;
    }

    public Set<AttachedCondorResource> GetExecutableResources() {
        HashSet<AttachedCondorResource> ret = new HashSet<AttachedCondorResource>();
        for (AttachedCondorResource att : this.Resources) {
            if (!att.TypeOfResource.equals((Object)AttachedCondorResource.ResourceType.Executable)) continue;
            ret.add(att);
        }
        return ret;
    }

    public Set<AttachedCondorResource> GetCommandResources() {
        HashSet<AttachedCondorResource> ret = new HashSet<AttachedCondorResource>();
        for (AttachedCondorResource att : this.Resources) {
            if (!att.TypeOfResource.equals((Object)AttachedCondorResource.ResourceType.Command)) continue;
            ret.add(att);
        }
        return ret;
    }

    public AttachedCondorResource GetSubmitResource() {
        for (AttachedCondorResource att : this.Resources) {
            if (!att.TypeOfResource.equals((Object)AttachedCondorResource.ResourceType.Submit)) continue;
            return att;
        }
        return null;
    }
}

