/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.adaptor.utils.grid;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.filter.IExternalFilter;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JobStatusExternalFilter
implements IExternalFilter {
    private static Logger logger = LoggerFactory.getLogger(JobStatusExternalFilter.class);
    public boolean StoreOutput = false;
    public String JobStatusVariableName = null;
    public String JobStatusOutputVariableName = null;

    public Set<String> GetInputVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.JobStatusVariableName);
        return vars;
    }

    public Set<String> GetStoreOutputVariableName() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.JobStatusOutputVariableName);
        return vars;
    }

    public boolean StoreOutput() {
        return this.StoreOutput;
    }

    public void Validate() throws ExecutionValidationException {
        if (this.JobStatusVariableName == null || this.JobStatusVariableName.trim().length() == 0) {
            throw new ExecutionValidationException("Filtered parameter names cannot be empty or null");
        }
        if (this.StoreOutput && (this.JobStatusOutputVariableName == null || this.JobStatusOutputVariableName.trim().length() == 0)) {
            throw new ExecutionValidationException("Needed parameter is not provided");
        }
    }

    public void ValidateForOnlineFiltering() throws ExecutionValidationException {
        throw new ExecutionValidationException("On line filtering is not supported");
    }

    public void ValidatePreExecution(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.Validate();
        if (!Handle.GetPlan().Variables.Contains(this.JobStatusVariableName)) {
            throw new ExecutionValidationException("Needed parameter not found");
        }
        NamedDataType ndt = Handle.GetPlan().Variables.Get(this.JobStatusVariableName);
        if (!ndt.IsAvailable.booleanValue() && !ExcludeAvailableConstraint.contains(this.JobStatusVariableName)) {
            throw new ExecutionValidationException("Needed variable not available");
        }
        if (!Handle.GetPlan().Variables.Contains(this.JobStatusOutputVariableName)) {
            throw new ExecutionValidationException("Needed parameter to store output not present");
        }
    }

    public void ValidatePreExecutionForOnlineFiltering(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.ValidateForOnlineFiltering();
    }

    public boolean SupportsOnLineFiltering() {
        return false;
    }

    public Object Process(ExecutionHandle Handle) throws ExecutionRunTimeException {
        try {
            String l;
            String output = DataTypeUtils.GetValueAsString((Object)Handle.GetPlan().Variables.Get((String)this.JobStatusVariableName).Value.GetValue());
            logger.debug("Retrieved status is : \n" + output);
            BufferedReader r = new BufferedReader(new StringReader(output));
            JobStatus s = JobStatus.Other;
            while ((l = r.readLine()) != null) {
                if (!l.startsWith("Current Status:")) continue;
                String sts = l.substring("Current Status:".length()).trim().toLowerCase();
                if (sts.startsWith(JobStatus.Aborted.toString().toLowerCase())) {
                    s = JobStatus.Aborted;
                    continue;
                }
                if (sts.startsWith(JobStatus.Cancelled.toString().toLowerCase())) {
                    s = JobStatus.Cancelled;
                    continue;
                }
                if (sts.startsWith(JobStatus.Cleared.toString().toLowerCase())) {
                    s = JobStatus.Cleared;
                    continue;
                }
                if (sts.startsWith(JobStatus.Done.toString().toLowerCase())) {
                    s = JobStatus.Done;
                    continue;
                }
                if (sts.startsWith(JobStatus.Ready.toString().toLowerCase())) {
                    s = JobStatus.Ready;
                    continue;
                }
                if (sts.startsWith(JobStatus.Running.toString().toLowerCase())) {
                    s = JobStatus.Running;
                    continue;
                }
                if (sts.startsWith(JobStatus.Scheduled.toString().toLowerCase())) {
                    s = JobStatus.Scheduled;
                    continue;
                }
                if (sts.startsWith(JobStatus.Submitted.toString().toLowerCase())) {
                    s = JobStatus.Submitted;
                    continue;
                }
                if (sts.startsWith(JobStatus.Waiting.toString().toLowerCase())) {
                    s = JobStatus.Waiting;
                    continue;
                }
                s = JobStatus.Other;
            }
            if (s.equals((Object)JobStatus.Other)) {
                throw new ExecutionValidationException("Could not retrieve job status");
            }
            logger.debug("Parsed Status is : " + s.toString());
            return s.toString();
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not retrieve job status", (Throwable)ex);
        }
    }

    public Object ProcessOnLine(Object OnLineFilteredValue, Set<NamedDataType> AdditionalValueProviders, ExecutionHandle Handle) throws ExecutionRunTimeException {
        throw new ExecutionRunTimeException("On line filtering is not supported");
    }

    public String ToXML() throws ExecutionSerializationException {
        String outputvarString = "";
        if (this.JobStatusOutputVariableName != null) {
            outputvarString = "storeOutputName=\"" + this.JobStatusOutputVariableName + "\"";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<external type=\"" + this.getClass().getName() + "\" storeOutput=\"" + Boolean.toString(this.StoreOutput) + "\" " + outputvarString + ">");
        buf.append("<filteredVariable name=\"" + this.JobStatusVariableName + "\"/>");
        buf.append("</external>");
        return buf.toString();
    }

    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            Element tmp;
            if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"type").booleanValue() || !XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutput").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.StoreOutput = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutput"));
            if (this.StoreOutput) {
                if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutputName").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization is not valid");
                }
                this.JobStatusOutputVariableName = XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutputName");
            }
            if (!XMLUtils.AttributeExists((Element)(tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"filteredVariable")), (String)"name").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.JobStatusVariableName = XMLUtils.GetAttribute((Element)tmp, (String)"name");
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", (Throwable)ex);
        }
    }

    public static enum JobStatus {
        Submitted,
        Waiting,
        Ready,
        Scheduled,
        Running,
        Done,
        Cleared,
        Aborted,
        Cancelled,
        Other;

    }
}

