/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.avatar.storage.userattribute;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import org.apache.commons.io.IOUtils;
import org.gcube.keycloak.avatar.storage.AvatarStorageProvider;
import org.jboss.logging.Logger;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class UserAttributeAvatarStorageProvider
implements AvatarStorageProvider {
    private static final Logger logger = Logger.getLogger(UserAttributeAvatarStorageProvider.class);
    private final String userAttribute;

    public UserAttributeAvatarStorageProvider() {
        this("avatar");
    }

    public UserAttributeAvatarStorageProvider(String userAttribute) {
        this.userAttribute = userAttribute;
    }

    public void saveAvatarImage(RealmModel realm, UserModel user, InputStream input) {
        logger.debugf("Saving avatar image to user attribute: %s", (Object)this.userAttribute);
        user.setSingleAttribute(this.userAttribute, this.getBase64EncodedString(input));
    }

    private String getBase64EncodedString(InputStream input) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)input, (OutputStream)baos);
        }
        catch (IOException e) {
            logger.error((Object)"Getting image stream as bytes array", (Throwable)e);
        }
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }

    public InputStream loadAvatarImage(RealmModel realm, UserModel user) {
        logger.debugf("Getting avatar image from user attribute: %s", (Object)this.userAttribute);
        return this.toBinaryStream(user.getFirstAttribute(this.userAttribute));
    }

    private InputStream toBinaryStream(String base64EncodedImage) {
        return base64EncodedImage != null ? new ByteArrayInputStream(Base64.getDecoder().decode(base64EncodedImage)) : null;
    }

    public void deleteAvatarImage(RealmModel realm, UserModel user) {
        logger.debugf("Removing avatar image user's attribute: %s", (Object)this.userAttribute);
        user.removeAttribute(this.userAttribute);
    }

    public void close() {
    }
}

