/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.avatar;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.gcube.keycloak.avatar.AbstractAvatarResource;
import org.gcube.keycloak.avatar.storage.AvatarStorageProvider;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.reactive.RestForm;
import org.jboss.resteasy.reactive.multipart.FileUpload;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class AvatarAdminResource
extends AbstractAvatarResource {
    @Context
    private AvatarStorageProvider avatarStorageProvider;
    @Context
    private HttpHeaders httpHeaders;
    @Context
    private ClientConnection clientConnection;

    public AvatarAdminResource(KeycloakSession session) {
        super(session);
    }

    public void init() {
        this.checkRealmAdmin();
    }

    @GET
    @Path(value="/{user_id}")
    @Produces(value={"image/png", "image/jpeg", "image/gif"})
    public Response downloadUserAvatarImage(@PathParam(value="user_id") String userId) {
        try {
            UserModel user = this.session.users().getUserById(this.session.getContext().getRealm(), userId);
            return this.fetchAndCreateResponse(this.session.getContext().getRealm(), user);
        }
        catch (ForbiddenException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            logger.error((Object)"error getting user avatar", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @NoCache
    @Path(value="/{user_id}")
    @Consumes(value={"multipart/form-data"})
    public Response uploadUserAvatarImage(@PathParam(value="user_id") String userId, @RestForm(value="image") FileUpload image) {
        try {
            if (this.auth == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            RealmModel realm = this.session.getContext().getRealm();
            UserModel user = this.session.users().getUserById(this.session.getContext().getRealm(), userId);
            this.saveUserImage(realm, user, Files.newInputStream(image.uploadedFile(), new OpenOption[0]));
        }
        catch (ForbiddenException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            logger.error((Object)"error saving user avatar", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        return Response.ok().build();
    }

    private void checkRealmAdmin() {
        if (this.auth == null) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        if (this.auth.getToken().getRealmAccess() == null || !this.auth.getToken().getRealmAccess().isUserInRole("admin")) {
            throw new ForbiddenException("Does not have realm admin role");
        }
    }
}

