/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.avatar.storage.s3;

import io.minio.GetObjectArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.errors.ErrorResponseException;
import java.io.InputStream;
import org.gcube.keycloak.avatar.storage.AvatarStorageProvider;
import org.jboss.logging.Logger;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class MinioAvatarStorageProvider
implements AvatarStorageProvider {
    private static final Logger logger = Logger.getLogger(MinioAvatarStorageProvider.class);
    private static final String AVATAR_FOLDER = "avatar";
    private static final int CHUNK_SIZE = 0x500000;
    private final Configuration configuration;

    public MinioAvatarStorageProvider(Configuration configuration) {
        this.configuration = configuration;
    }

    public void saveAvatarImage(RealmModel realmModel, UserModel userModel, InputStream input) {
        logger.debugf("Saving avatar to S3 for user: %s", (Object)userModel.getUsername());
        this.execute(minioClient -> {
            String avatarFileName = this.getAvatarFilePath(realmModel, userModel);
            logger.tracef("Saving avatar file object as: %s", (Object)avatarFileName);
            return minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.configuration.rootBucket)).object(avatarFileName)).stream(input, -1L, 0x500000L).build());
        });
    }

    public InputStream loadAvatarImage(final RealmModel realmModel, final UserModel userModel) {
        logger.debugf("Loading avatar from S3 for user: %s", (Object)userModel.getUsername());
        return this.execute(new Executor<InputStream>(){

            @Override
            public InputStream execute(MinioClient minioClient) throws Exception {
                try {
                    String avatarFileName = MinioAvatarStorageProvider.this.getAvatarFilePath(realmModel, userModel);
                    logger.tracef("Getting avatar file object: %s", (Object)avatarFileName);
                    return minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(MinioAvatarStorageProvider.this.configuration.rootBucket)).object(avatarFileName)).build());
                }
                catch (ErrorResponseException e) {
                    if (e.response().code() == 404) {
                        logger.debugf("Avatar file not found for user '%s' in realm '%s'", (Object)userModel.getUsername(), (Object)realmModel.getName());
                        return null;
                    }
                    throw e;
                }
            }
        });
    }

    public void deleteAvatarImage(RealmModel realmModel, UserModel userModel) {
        logger.debugf("Deleting avatar from S3 for user: %s", (Object)userModel.getUsername());
        this.execute(minioClient -> {
            String avatarFileName = this.getAvatarFilePath(realmModel, userModel);
            logger.tracef("Deleting avatar file object: %s", (Object)avatarFileName);
            minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.configuration.rootBucket)).object(avatarFileName)).build());
            return true;
        });
    }

    public void close() {
    }

    public String getAvatarFilePath(RealmModel realmModel, UserModel userModel) {
        return "avatar/" + realmModel.getName() + "/" + userModel.getUsername();
    }

    public <T> T execute(Executor<T> executor) {
        try {
            MinioClient minioClient = MinioClient.builder().endpoint(this.configuration.getServerUrl()).credentials(this.configuration.getAccessKey(), this.configuration.getSecretKey()).build();
            return executor.execute(minioClient);
        }
        catch (Exception e) {
            throw new RuntimeException("Executing operation on S3 persistnce", e);
        }
    }

    public static class Configuration {
        private final String serverUrl;
        private final String accessKey;
        private final String secretKey;
        private final String rootBucket;

        public Configuration(String serverUrl, String accessKey, String secretKey, String rootBucket) {
            this.serverUrl = serverUrl;
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.rootBucket = rootBucket;
        }

        public String getServerUrl() {
            return this.serverUrl;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public String getRootBucket() {
            return this.rootBucket;
        }
    }

    public static interface Executor<T> {
        public T execute(MinioClient var1) throws Exception;
    }
}

