/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.account;

import java.net.URI;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.gcube.event.publisher.Event;
import org.gcube.keycloak.account.DeleteAccountEvent;
import org.gcube.keycloak.avatar.storage.AvatarStorageProvider;
import org.gcube.keycloak.event.OrchestratorEventPublisherProviderFactory;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AppAuthManager;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.RealmsResource;

public class DeleteAccountResource {
    protected static final Logger logger = Logger.getLogger(DeleteAccountResource.class);
    private final KeycloakSession session;
    private final AuthenticationManager.AuthResult auth;

    public DeleteAccountResource(KeycloakSession session) {
        logger.info((Object)"Created new DeleteAccountResource object");
        this.session = session;
        this.auth = new AppAuthManager().authenticateIdentityCookie(session, session.getContext().getRealm());
    }

    @NoCache
    @POST
    @Path(value="request-delete")
    public Response performDeleteAccount() {
        if (this.auth == null) {
            logger.debug((Object)"Invoked DELETE without authorization");
            throw new NotAuthorizedException((Object)"Cookie", new Object[0]);
        }
        logger.info((Object)"Invoked perform delete account");
        logger.debug((Object)"Getting realm model from auth session");
        RealmModel realm = this.auth.getSession().getRealm();
        logger.debug((Object)"Getting user model from auth");
        UserModel user = this.auth.getUser();
        try {
            if (!this.session.getTransactionManager().isActive()) {
                logger.debug((Object)"Beginning a new transaction on transaction manager");
                this.session.getTransactionManager().begin();
            }
            logger.debug((Object)"Finding user model and setting it as not enabled in realm");
            this.session.users().getUserById(realm, user.getId()).setEnabled(false);
            if (this.session.getTransactionManager().isActive()) {
                logger.debug((Object)"Committing the transaction on transaction manager");
                this.session.getTransactionManager().commit();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Cannot perform user model modifications", (Throwable)e);
        }
        logger.debug((Object)"Getting the the configured avatar storage provider");
        AvatarStorageProvider avatarStorageProvider = (AvatarStorageProvider)this.session.getProvider(AvatarStorageProvider.class);
        if (avatarStorageProvider != null) {
            logger.tracev("Configured avatar storage provider type is {0}", (Object)avatarStorageProvider.getClass().getName());
            logger.debug((Object)"Deleting user's avatar from the configured storage");
            avatarStorageProvider.deleteAvatarImage(realm, user);
        } else {
            logger.warn((Object)"Cannot perform avatar import ince the avatar storage provider is null");
        }
        logger.debug((Object)"Sending delete account event to the orchestrator");
        new OrchestratorEventPublisherProviderFactory().create(this.session).publish((Event)new DeleteAccountEvent(user, realm));
        logger.debug((Object)"Forcing logout from all active sessions");
        this.session.sessions().removeUserSessions(realm);
        URI auccountLoginUri = RealmsResource.accountUrl((UriBuilder)this.session.getContext().getUri().getBaseUriBuilder()).build(new Object[]{realm.getName()});
        logger.debugf("Finally redirecting to the account form login: %s", (Object)auccountLoginUri);
        return Response.status((int)302).location(auccountLoginUri).build();
    }
}

