package org.gcube.keycloak.protocol.oidc;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

import org.keycloak.protocol.oidc.representations.OIDCConfigurationRepresentation;

import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * @author <a href="mailto:mauro.mugnaini@nubisware.com">Mauro Mugnaini</a>
 */
public class Utils {

    public static String getIntrospectionEndpoint(String issuerUrl) {
        try {
            String wellKnownUrl = issuerUrl;
            if (!wellKnownUrl.endsWith("/")) {
                wellKnownUrl += "/";
            }
            wellKnownUrl += ".well-known/openid-configuration";

            URL url = new URL(wellKnownUrl);
            HttpURLConnection connection = (HttpURLConnection) url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Accept", "application/json");

            int status = connection.getResponseCode();
            if (status == 200) {
                InputStream inputStream = connection.getInputStream();

                ObjectMapper mapper = new ObjectMapper();
                OIDCConfigurationRepresentation config = mapper.readValue(inputStream,
                        OIDCConfigurationRepresentation.class);

                return config.getIntrospectionEndpoint();
            }
        } catch (Exception e) {
            // ignoring errors
        }
        return null;
    }
}
