import * as React from 'react';

import { Button, Grid, GridItem, Expandable, Modal, Form } from '@patternfly/react-core';
import { AccountServiceContext } from '../../account-service/AccountServiceContext';
import { Msg } from '../../widgets/Msg';
import { ContentPage } from '../ContentPage';
import { ContentAlert } from '../ContentAlert';
import { AvatarForm } from './AvatarForm';

interface AccountExtraPageProps {
}

interface AccountExtraPageState {
    isModalOpen: boolean;
}

export class AccountExtraPage extends React.Component<AccountExtraPageProps, AccountExtraPageState> {
    static contextType = AccountServiceContext;
    context: React.ContextType<typeof AccountServiceContext>;

    constructor(props: any) {
        super(props)
        this.state = { isModalOpen: false }
    }

    private handleModalToggle = (open: boolean) => {
        this.setState({ isModalOpen: open })
    }

    private modalConfirmDelete = (event: any) => {
        const accountUrl = this.context!["accountUrl"]
        const deleteUrl = accountUrl + "-delete/request-delete"
        this.context!.doPost<void>(deleteUrl, {})
            .then(() => {
                ContentAlert.success('accountDeletedMessage')
                window.location.reload();
            })
        this.setState({ isModalOpen: false })
    }

    public render(): React.ReactNode {
        const accountUrl = this.context!["accountUrl"]

        return (
            <ContentPage title="accountExtraInfoHtmlTitle"
                introMessage="accountExtraSubMessage"
            >
                <AvatarForm accountUrl={accountUrl} />

                <div id="delete-account" style={{marginTop:"30px"}}>
                    <Expandable toggleText={Msg.localize('deleteAccount')}>
                        <Grid gutter={"sm"}>
                            <GridItem span={8}>
                                <p dangerouslySetInnerHTML={{ __html: Msg.localize('deleteAccountInfoMessage')}} />
                            </GridItem>
                            <GridItem span={4}>
                                <Button id="delete-account-btn" variant="danger"
                                    onClick={(e) => this.handleModalToggle(true)} className="delete-button"
                                >
                                    <Msg msgKey="doDelete" />
                                </Button>
                            </GridItem>
                        </Grid>
                    </Expandable>

                    <Modal
                        width={'50%'}
                        title={Msg.localize('deleteAccountDialogHeader')}
                        isOpen={this.state.isModalOpen}
                        onClose={() => this.handleModalToggle(false)}
                        actions={[
                            <Button key="confirm" variant="danger" onClick={this.modalConfirmDelete}>
                                <Msg msgKey="doDeleteConfirm" />
                            </Button>,
                            <Button key="cancel" variant="secondary" onClick={(e) => this.handleModalToggle(false)}>
                                <Msg msgKey="doCancel" />
                            </Button>
                        ]}
                    >
                        <div dangerouslySetInnerHTML={{ __html: Msg.localize('deleteAccountWarningMessage')}} />
                        <div dangerouslySetInnerHTML={{ __html: Msg.localize('deleteAccountConfirmMessage')}} />
                    </Modal>
                </div>

            </ContentPage>
        )
    }
}