/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.protocol.oidc.mapper;

import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;

public class D4ScienceContextMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper {
    private static final Logger logger = Logger.getLogger(D4ScienceContextMapper.class);
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    private static final int PRIORITY = Integer.MAX_VALUE;
    private static final String DISPLAY_TYPE = "OIDC D4Science Context Mapper";
    private static final String PROVIDER_ID = "oidc-d4scince-context-mapper";
    public static final String HEADER_NAME = "X-D4Science-Context";

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public String getDisplayType() {
        return DISPLAY_TYPE;
    }

    public String getHelpText() {
        return "Maps the D4Science context audience by reading the 'X-D4Science-Context' header and sets it as the configured token claim";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession keycloakSession, ClientSessionContext clientSessionCtx) {
        if (token instanceof AccessToken) {
            logger.debugf("Looking for the '%s' header", (Object)HEADER_NAME);
            String requestedD4SContext = keycloakSession.getContext().getRequestHeaders().getHeaderString(HEADER_NAME);
            if (requestedD4SContext != null && !"".equals(requestedD4SContext)) {
                logger.debugf("Checking resource access for the requested context: %s", (Object)requestedD4SContext);
                if (((AccessToken)token).getResourceAccess().containsKey(requestedD4SContext)) {
                    logger.debugf("Mapping it as the configured claim: %s", mappingModel.getConfig().get("claim.name"));
                    OIDCAttributeMapperHelper.mapClaim((IDToken)token, (ProtocolMapperModel)mappingModel, (Object)requestedD4SContext);
                } else {
                    logger.warnf("Requested context '%s' is not accessible to the client: %s", (Object)requestedD4SContext, (Object)clientSessionCtx.getClientSession().getClient().getName());
                }
            }
        }
    }

    static {
        OIDCAttributeMapperHelper.addTokenClaimNameConfig(configProperties);
        OIDCAttributeMapperHelper.addIncludeInTokensConfig(configProperties, D4ScienceContextMapper.class);
    }
}

