/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.idm.client;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotAuthorizedException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.com.fasterxml.jackson.databind.JavaType;
import org.gcube.idm.client.AbstractIdmClient;
import org.gcube.idm.client.IdmMeClient;
import org.gcube.idm.client.beans.ResponseBean;
import org.gcube.idm.client.clients.IdmRestClient;
import org.gcube.idm.client.model.OwnerInfo;
import org.gcube.idm.client.model.UserInfo;
import org.gcube.idm.client.model.UserInspect;
import org.gcube.idm.client.model.UserProfile;
import org.gcube.idm.client.model.util.JsonUtilsCustom;
import org.gcube.idm.common.models.IdmUser;
import org.gcube.idm.common.models.IdmVerifyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMeClient
extends AbstractIdmClient
implements IdmMeClient {
    protected String auth_token;
    protected static Logger logger = LoggerFactory.getLogger(DefaultMeClient.class);

    public DefaultMeClient(IdmRestClient client, String auth_token) throws URISyntaxException {
        super(client);
        this.auth_token = auth_token;
    }

    public DefaultMeClient(String base_url, String auth_token) throws URISyntaxException {
        super(base_url);
        this.auth_token = auth_token;
    }

    public DefaultMeClient(URI base_url, String auth_token) throws URISyntaxException {
        super(base_url);
        this.auth_token = auth_token;
    }

    @Override
    public String getMeId() {
        ResponseBean<String> resp = this.client.performGetRequest("users/me/id", this.auth_token, String.class);
        return resp.getResult();
    }

    @Override
    public String getMeEmail() {
        ResponseBean<String> resp = this.client.performGetRequest("users/me/email", this.auth_token, String.class);
        return resp.getResult();
    }

    @Override
    public String getMeUsername() {
        ResponseBean<String> resp = this.client.performGetRequest("users/me/username", this.auth_token, String.class);
        return resp.getResult();
    }

    @Override
    public OwnerInfo getMeOwner() {
        ResponseBean<OwnerInfo> resp = this.client.performGetRequest("users/me/owner", this.auth_token, OwnerInfo.class);
        return resp.getResult();
    }

    @Override
    public UserProfile getMeProfile() {
        ResponseBean<UserProfile> resp = this.client.performGetRequest("users/me/profile", this.auth_token, UserProfile.class);
        return resp.getResult();
    }

    @Override
    public IdmVerifyObject verifyToken() {
        ResponseBean<IdmVerifyObject> resp = this.client.performGetRequest("users/me/verify", this.auth_token, IdmVerifyObject.class);
        return resp.getResult();
    }

    @Override
    public String getMeName() throws NotAuthorizedException, BadRequestException {
        ResponseBean<String> resp = this.client.performGetRequest("users/me/name", this.auth_token, String.class);
        return resp.getResult();
    }

    @Override
    public Map<String, List<String>> getMeAttributes() throws NotAuthorizedException, BadRequestException {
        JavaType stringListType = JsonUtilsCustom.geListOfObjectsType(String.class);
        JavaType stringType = JsonUtilsCustom.getObjectJT(String.class);
        JavaType mapOfStringList = JsonUtilsCustom.geMapOfObjectsType(stringType, stringListType);
        ResponseBean resp = this.client.performGetRequest("users/me/attributes", this.auth_token, mapOfStringList);
        return (Map)resp.getResult();
    }

    @Override
    public IdmUser getMeUser() throws NotAuthorizedException, BadRequestException {
        ResponseBean<IdmUser> resp = this.client.performGetRequest("users/me/user", this.auth_token, IdmUser.class);
        return resp.getResult();
    }

    @Override
    public UserInfo getMe() throws NotAuthorizedException, BadRequestException {
        ResponseBean<UserInfo> resp = this.client.performGetRequest("users/me", this.auth_token, UserInfo.class);
        return resp.getResult();
    }

    @Override
    public UserInspect getMeInspect() throws NotAuthorizedException, BadRequestException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("inspect", "true");
        HashMap<String, String> headers = IdmRestClient.getHeadersWithAuth(this.auth_token, null);
        ResponseBean<UserInspect> resp = this.client.performGetRequest("users/me", headers, params, UserInspect.class);
        return resp.getResult();
    }
}

