/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.security.Owner;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.service.idm.IdMManager;
import org.gcube.service.idm.controller.AuthController;
import org.gcube.service.idm.controller.JWTController;
import org.gcube.service.idm.controller.KCUserController;
import org.gcube.service.idm.controller.LiferayProfileClient;
import org.gcube.service.idm.keycloack.KkClientFactory;
import org.gcube.service.idm.rest.UserAPI;
import org.gcube.service.idm.serializers.IdmObjectSerializator;
import org.gcube.service.utils.beans.ResponseBean;
import org.gcube.service.utils.beans.ResponseBeanMap;
import org.gcube.service.utils.beans.ResponseBeanPaginated;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedBy(value=IdMManager.class)
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
@Path(value="users")
public class UserAPI {
    private static final Logger logger = LoggerFactory.getLogger(UserAPI.class);

    @GET
    @Path(value="/me")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="current user informations"), @ResponseCode(code=403, condition="User's information can only be retrieved through a user token (not qualified)"), @ResponseCode(code=404, condition="Such an attribute doesn't exist"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getMe(@QueryParam(value="inspect") @DefaultValue(value="false") Boolean inspect) {
        logger.info("/users/me");
        ResponseBean responseBean = new ResponseBean();
        ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
        Secret secret = SecretManagerProvider.get();
        Owner owner = secret.getOwner();
        String username = owner.getId();
        Map result = this.getUserData(username, Boolean.valueOf(!owner.isApplication()), inspect);
        responseBean.setResult((Object)result);
        result.put("owner", owner);
        try {
            if (inspect.booleanValue()) {
                String token = AuthController.getAccessToken();
                result.put("verify", JWTController.decodeJwtToken((String)token));
            }
            responseBean.setSuccess(true);
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/{username}")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="user informations"), @ResponseCode(code=403, condition="User's information can only be retrieved through a user token (not qualified)"), @ResponseCode(code=404, condition="Such an attribute doesn't exist"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getUser(@PathParam(value="username") String username, @QueryParam(value="inspect") @DefaultValue(value="false") Boolean inspect) {
        ResponseBeanMap responseBean = new ResponseBeanMap();
        ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
        if (!AuthController.checkAnyRole((List)AuthController.ACCESS_READ_ROLES)) {
            throw new ForbiddenException("User is not authorized to access private data");
        }
        Secret secret = SecretManagerProvider.get();
        Owner owner = secret.getOwner();
        try {
            Map result = this.getUserData(username, Boolean.valueOf(!owner.isApplication()), inspect);
            responseBean.setResult(result);
            responseBean.setSuccess(true);
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    protected Map<String, Object> getUserData(String username, Boolean getProfile, Boolean isInspect) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        UserRepresentation user = KCUserController.getUserByUsername((String)username);
        result.put("user", user);
        try {
            if (getProfile.booleanValue()) {
                GCubeUser profile = LiferayProfileClient.getUserProfileByUsername((String)username);
                result.put("profile", profile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("profile", null);
        }
        if (isInspect.booleanValue()) {
            UserResource userResource = KCUserController.getUserResourceByUsername((String)username);
            MappingsRepresentation roles = userResource.roles().getAll();
            result.put("roles", roles);
            List groups = userResource.groups();
            result.put("groups", groups);
            HashMap groupRolesRealm = new HashMap();
            HashMap<String, Map> groupRolesClients = new HashMap<String, Map>();
            result.put("groupRolesRealm", groupRolesRealm);
            result.put("groupRolesClients", groupRolesClients);
            for (GroupRepresentation g : groups) {
                groupRolesClients.put(g.getId(), g.getClientRoles());
            }
        }
        return result;
    }

    @GET
    @Path(value="/me/owner")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="infos about the owner of the auth token"), @ResponseCode(code=403, condition="User's information can only be retrieved through a user token (not qualified)"), @ResponseCode(code=404, condition="Such an attribute doesn't exist"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getCurrentUser() {
        ResponseBean responseBean = new ResponseBean();
        Secret secret = SecretManagerProvider.get();
        Owner owner = secret.getOwner();
        try {
            responseBean.setResult((Object)owner);
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/me/verify")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="decode the token"), @ResponseCode(code=403, condition="User's information can only be retrieved through a user token (not qualified)"), @ResponseCode(code=404, condition="Such an attribute doesn't exist"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getInrospectioCurrenttUser() {
        ResponseBean responseBean = new ResponseBean();
        try {
            String token = AuthController.getAccessToken();
            responseBean.setResult((Object)JWTController.decodeJwtToken((String)token));
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/{username}/{parameter}")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="decode the token"), @ResponseCode(code=403, condition="User's information can only be retrieved through a user token (not qualified)"), @ResponseCode(code=404, condition="Such an attribute doesn't exist"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getUserParameter(@PathParam(value="username") String username, @PathParam(value="parameter") USER_DETAILS parameter) {
        ResponseBean responseBean = new ResponseBean();
        ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
        Secret secret = SecretManagerProvider.get();
        Owner owner = secret.getOwner();
        if (username.equals("me")) {
            username = owner.getId();
        }
        if (!AuthController.checkAnyRole((List)AuthController.ACCESS_READ_ROLES) && !AuthController.userIsMe((String)username, (Owner)owner)) {
            throw new ForbiddenException("User is not authorized to access private data");
        }
        try {
            if (parameter.equals((Object)USER_DETAILS.profile)) {
                GCubeUser profile = LiferayProfileClient.getUserProfileByUsername((String)username);
                responseBean.setResult((Object)profile);
                String jsonData = objectMapper.writeValueAsString((Object)responseBean);
                return Response.ok((Object)jsonData).build();
            }
            UserRepresentation user = KCUserController.getUserByUsername((String)username);
            if (parameter.equals((Object)USER_DETAILS.email)) {
                responseBean.setResult((Object)user.getEmail());
            } else if (parameter.equals((Object)USER_DETAILS.roles_realm)) {
                responseBean.setResult((Object)user.getRealmRoles());
            } else if (parameter.equals((Object)USER_DETAILS.roles_clients)) {
                responseBean.setResult((Object)user.getClientRoles());
            } else if (parameter.equals((Object)USER_DETAILS.groups)) {
                responseBean.setResult((Object)user.getGroups());
            } else if (parameter.equals((Object)USER_DETAILS.id)) {
                responseBean.setResult((Object)user.getId());
            } else if (parameter.equals((Object)USER_DETAILS.username)) {
                responseBean.setResult((Object)user.getUsername());
            } else if (parameter.equals((Object)USER_DETAILS.name)) {
                responseBean.setResult((Object)(String.valueOf(user.getFirstName()) + " " + user.getLastName()));
            } else if (parameter.equals((Object)USER_DETAILS.attributes)) {
                responseBean.setResult((Object)user.getAttributes());
            } else if (parameter.equals((Object)USER_DETAILS.user) || parameter == null) {
                responseBean.setResult((Object)user);
            } else {
                throw new BadRequestException("unknow parameter " + parameter);
            }
            responseBean.setSuccess(true);
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/search")
    @Produces(value={"application/json"})
    public Response search(@QueryParam(value="format") @DefaultValue(value="username") KCUserController.REPR format, @QueryParam(value="exact") @DefaultValue(value="true") Boolean exact, @QueryParam(value="username") String username, @QueryParam(value="firsnName") String firstName, @QueryParam(value="lastName") String lastName, @QueryParam(value="email") String email, @QueryParam(value="first") @DefaultValue(value="0") int firstResult, @QueryParam(value="max") @DefaultValue(value="100") int maxResults, @QueryParam(value="enabled") @DefaultValue(value="true") Boolean enabled) {
        ResponseBeanPaginated responseBean = new ResponseBeanPaginated(Integer.valueOf(firstResult), Integer.valueOf(maxResults));
        try {
            if (!format.equals((Object)KCUserController.REPR.username) && !AuthController.checkAnyRole((List)AuthController.ACCESS_READ_ROLES)) {
                throw new ForbiddenException("User is not authorized to access private data");
            }
            RealmResource realm = KkClientFactory.getSingleton().getKKRealm();
            Boolean briefRepresentation = !KCUserController.REPR.full.equals((Object)format);
            List users = realm.users().search(username, firstName, lastName, email, Integer.valueOf(firstResult), Integer.valueOf(maxResults), enabled, briefRepresentation, exact);
            responseBean.setResult(KCUserController.formatList((List)users, (KCUserController.REPR)format));
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }
}

