/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm.liferay;

import jakarta.ws.rs.InternalServerErrorException;
import org.gcube.common.security.secrets.Secret;
import org.gcube.idm.common.is.InfrastrctureServiceClient;
import org.gcube.idm.common.is.IsServerConfig;
import org.gcube.vomanagement.usermanagement.impl.ws.LiferayWSUserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class LiferayClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(LoggerFactory.class);
    private static final String RUNTIME_RESOURCE_NAME = "D4Science Infrastructure Gateway";
    private static final String CATEGORY = "Portal";
    private static final String END_POINT_NAME = "JSONWSUser";
    private static final boolean IS_ROOT_SERVICE = true;
    LiferayWSUserManager client = null;
    private IsServerConfig config;
    private Secret secret;
    private static LiferayClientFactory singleton = new LiferayClientFactory();

    public static LiferayClientFactory getSingleton() {
        if (singleton == null) {
            singleton = new LiferayClientFactory();
        }
        return singleton;
    }

    public Secret getSecret() {
        return this.secret;
    }

    public void setSecret(Secret secret) {
        this.secret = secret;
    }

    public void setConfig(IsServerConfig config) {
        this.config = config;
        this.client = null;
    }

    public Secret getSecretForInfrastructure() {
        return InfrastrctureServiceClient.getSecretForInfrastructure();
    }

    public IsServerConfig fetchIsConfig() throws InternalServerErrorException {
        if (this.secret == null) {
            this.secret = this.getSecretForInfrastructure();
        }
        return this.fetchIsConfig(this.secret);
    }

    public IsServerConfig fetchIsConfig(Secret secret) throws InternalServerErrorException {
        if (secret == null) {
            throw new InternalServerErrorException("null secret for fetchIsConfig");
        }
        try {
            IsServerConfig cfg = InfrastrctureServiceClient.serviceConfigFromIS((String)"D4Science Infrastructure Gateway", (String)"Portal", (String)"JSONWSUser", (boolean)true, (Secret)secret);
            logger.info("KeycloakAPICredentials object built {} - {}", (Object)cfg.getServerUrl(), (Object)cfg.getName());
            return cfg;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public LiferayWSUserManager createtLiferayClientInstance() {
        if (this.config == null) {
            this.config = this.fetchIsConfig();
        }
        return LiferayClientFactory.createtLiferayClientInstance((IsServerConfig)this.config);
    }

    public static LiferayWSUserManager createtLiferayClientInstance(IsServerConfig config) {
        String host = config.getServerUrl();
        String schema = config.getProperty("schema");
        String user = config.getProperty("username");
        String password = config.getProperty("password");
        Integer port = Integer.valueOf(config.getProperty("port"));
        LiferayWSUserManager client = null;
        try {
            client = new LiferayWSUserManager(user, password, host, schema, port.intValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalServerErrorException("cannot create Liferay client");
        }
        if (client == null) {
            throw new InternalServerErrorException("cannot create Liferay client");
        }
        logger.info("Liferay object built {} - {}", (Object)config.getServerUrl(), (Object)config.getName());
        return client;
    }

    public LiferayWSUserManager getClient() {
        if (this.client == null) {
            this.client = this.createtLiferayClientInstance();
        }
        return this.client;
    }
}

