/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm.keycloack;

import jakarta.ws.rs.NotFoundException;
import java.util.List;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.idm.common.is.IsServerConfig;
import org.gcube.service.idm.AbstractClientFactory;
import org.gcube.service.idm.keycloack.KeycloackApiClient;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class KkClientFactory
extends AbstractClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(KkClientFactory.class);
    protected static String RUNTIME_RESOURCE_NAME = "IAM";
    protected static String CATEGORY = "Service";
    protected static String END_POINT_NAME = "d4science";
    protected static boolean IS_ROOT_SERVICE = true;
    private static KkClientFactory singleton = new KkClientFactory();

    public String getRuntimeResourceName() {
        return RUNTIME_RESOURCE_NAME;
    }

    public String getCategory() {
        return CATEGORY;
    }

    public String getEndPointName() {
        return END_POINT_NAME;
    }

    public boolean isRootService() {
        return IS_ROOT_SERVICE;
    }

    public static KkClientFactory getSingleton() {
        if (singleton == null) {
            singleton = new KkClientFactory();
        }
        return singleton;
    }

    public KeycloackApiClient createtKeycloakInstance(String context) {
        if (this.secret == null) {
            this.secret = KkClientFactory.getSecretForInfrastructure();
        }
        if (this.config == null) {
            this.config = this.fetchIsConfig(this.secret);
        }
        return KkClientFactory.createtKeycloakInstance((IsServerConfig)this.config, (String)context);
    }

    public static KeycloackApiClient createtKeycloakInstance(IsServerConfig config, String context) {
        Keycloak kclient = KeycloakBuilder.builder().serverUrl(config.getServerUrl()).realm(config.getName()).grantType(config.getGrantType()).clientId(config.getClientId()).clientSecret(config.getClientSecret()).build();
        return new KeycloackApiClient(kclient, config.getName(), context);
    }

    public RealmResource getKKRealm() {
        String ctx = SecretManagerProvider.get().getContext();
        return this.getKKRealm(ctx);
    }

    public RealmResource getKKRealm(String ctx) {
        logger.info("Searching client for contex");
        KeycloackApiClient keycloackApiClient = this.createtKeycloakInstance(ctx);
        RealmResource realm = keycloackApiClient.kclient.realm(keycloackApiClient.realmName);
        return realm;
    }

    public ClientResource getKKClient() {
        String ctx = SecretManagerProvider.get().getContext();
        return this.getKKClient(ctx);
    }

    public ClientResource getKKClient(String ctx) {
        logger.info("Searching client for contex");
        RealmResource realm = this.getKKRealm(ctx);
        List clients = realm.clients().findByClientId(KkClientFactory.encodeClientIdContext((String)ctx));
        if (clients.size() == 0) {
            return null;
        }
        String id = ((ClientRepresentation)clients.get(0)).getId();
        return realm.clients().get(id);
    }

    public ClientResource getKKClientById(String clientId) {
        if (clientId == null) {
            return KkClientFactory.getSingleton().getKKClient();
        }
        RealmResource realmResource = this.getKKRealm();
        List clients = realmResource.clients().findByClientId(clientId);
        if (clients.size() == 0) {
            throw new NotFoundException();
        }
        String id = ((ClientRepresentation)clients.get(0)).getId();
        return realmResource.clients().get(id);
    }

    public static String encodeClientIdContext(String context) {
        return context.replace("/", "%2F");
    }
}

