/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.couchbase.helpers;

import com.couchbase.client.CouchbaseClient;
import com.couchbase.client.protocol.views.DesignDocument;
import com.couchbase.client.protocol.views.ViewDesign;
import java.util.Map;
import org.gcube.couchbase.helpers.CouchBaseDataTypesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewHelper {
    private static final Logger logger = LoggerFactory.getLogger(ViewHelper.class);

    public static void createAllIndexes(CouchbaseClient client, String bucketName, String designDocumentName, Map<String, CouchBaseDataTypesHelper.DataType> keys) {
        if (keys == null || keys.size() == 0) {
            logger.warn("No keys are given to build index");
            logger.warn("Skipping the index creation");
            return;
        }
        DesignDocument designDoc = new DesignDocument(designDocumentName);
        for (Map.Entry<String, CouchBaseDataTypesHelper.DataType> e : keys.entrySet()) {
            String fieldName = e.getKey();
            CouchBaseDataTypesHelper.DataType datatype = e.getValue();
            designDoc.getViews().add(ViewHelper.getView(bucketName, fieldName, datatype));
        }
        client.createDesignDoc(designDoc);
    }

    public static void createAllIndexes(CouchbaseClient client, String designDocumentName, Map<String, CouchBaseDataTypesHelper.DataType> keys) {
        ViewHelper.createAllIndexes(client, "", designDocumentName, keys);
    }

    public static ViewDesign getIntegerView() {
        String viewName = CouchBaseDataTypesHelper.DataType.INTEGER.toString();
        String mapFunction = "function (doc, meta) {\n    if (doc.type && doc.type == \"" + CouchBaseDataTypesHelper.DataType.INTEGER.toString() + "\") {\n" + "        emit(parseInt(meta.id, 10), 1);\n" + "    }\n" + "}";
        String reduceFunction = "_count";
        logger.info("view result map : \n" + mapFunction);
        logger.info("view result reduce : \n" + reduceFunction);
        return new ViewDesign(viewName, mapFunction, reduceFunction);
    }

    public static ViewDesign getFloatView() {
        String viewName = CouchBaseDataTypesHelper.DataType.FLOAT.toString();
        String mapFunction = "function (doc, meta) {\n    if (doc.type && doc.type == \"" + CouchBaseDataTypesHelper.DataType.FLOAT.toString() + "\") {\n" + "        emit(parseFloat(meta.id), 1);\n" + "    }\n" + "}";
        String reduceFunction = "_count";
        logger.info("view result map : \n" + mapFunction);
        logger.info("view result reduce : \n" + reduceFunction);
        return new ViewDesign(viewName, mapFunction, reduceFunction);
    }

    public static ViewDesign getDateView() {
        String viewName = CouchBaseDataTypesHelper.DataType.DATE.toString();
        String mapFunction = "function (doc, meta) {\n    if (doc.type && doc.type == \"" + CouchBaseDataTypesHelper.DataType.DATE.toString() + "\") {\n" + "        emit(parseInt(meta.id, 10), 1);\n" + "    }\n" + "}";
        String reduceFunction = "_count";
        logger.info("view result map : \n" + mapFunction);
        logger.info("view result reduce : \n" + reduceFunction);
        return new ViewDesign(viewName, mapFunction, reduceFunction);
    }

    public static ViewDesign getStringView() {
        String viewName = CouchBaseDataTypesHelper.DataType.STRING.toString();
        String mapFunction = "function (doc, meta) {\n    if (doc.type && doc.type == \"" + CouchBaseDataTypesHelper.DataType.STRING.toString() + "\") {\n" + "        emit(meta.id, 1);\n" + "    }\n" + "}";
        String reduceFunction = "_count";
        logger.info("view result map : \n" + mapFunction);
        logger.info("view result reduce : \n" + reduceFunction);
        return new ViewDesign(viewName, mapFunction, reduceFunction);
    }

    public static String constructViewName(String bucketName, String fieldName, Map<String, CouchBaseDataTypesHelper.DataType> keys) {
        if (!keys.containsKey(fieldName)) {
            logger.error("fieldname : " + fieldName + " not in keys : " + keys);
        }
        return bucketName + "_" + fieldName + "_" + keys.get(fieldName).toString();
    }

    public static String constructViewName(String bucketName, String fieldName, CouchBaseDataTypesHelper.DataType datatype) {
        return bucketName + "_" + fieldName + "_" + datatype.toString();
    }

    public static ViewDesign getIntegerView(String fieldName) {
        return ViewHelper.getIntegerView("", fieldName);
    }

    public static ViewDesign getIntegerView(String bucketName, String fieldName) {
        String viewName = ViewHelper.constructViewName(bucketName, fieldName, CouchBaseDataTypesHelper.DataType.INTEGER);
        String mapFunction = "function (doc, meta) {\n    if (doc.keys && doc.keys." + fieldName + ") {\n" + "        for (i = 0 ; i < doc.keys." + fieldName + ".length ; i++) {\n" + "            emit(parseInt(doc.keys." + fieldName + "[i], 10), 1);\n" + "        }\n" + "    }\n" + "}";
        String reduceFunction = "_count";
        logger.info("view result map : \n" + mapFunction);
        logger.info("view result reduce : \n" + reduceFunction);
        return new ViewDesign(viewName, mapFunction, reduceFunction);
    }

    public static ViewDesign getFloatView(String fieldName) {
        return ViewHelper.getFloatView("", fieldName);
    }

    public static ViewDesign getFloatView(String bucketName, String fieldName) {
        String viewName = ViewHelper.constructViewName(bucketName, fieldName, CouchBaseDataTypesHelper.DataType.FLOAT);
        String mapFunction = "function (doc, meta) {\n    if (doc.keys && doc.keys." + fieldName + ") {\n" + "        for (i = 0 ; i < doc.keys." + fieldName + ".length ; i++) {\n" + "            emit(parseFloat(doc.keys." + fieldName + "[i]), 1);\n" + "        }\n" + "    }\n" + "}";
        String reduceFunction = "_count";
        logger.info("view result map : \n" + mapFunction);
        logger.info("view result reduce : \n" + reduceFunction);
        return new ViewDesign(viewName, mapFunction, reduceFunction);
    }

    public static ViewDesign getDateView(String fieldName) {
        return ViewHelper.getDateView("", fieldName);
    }

    public static ViewDesign getDateView(String bucketName, String fieldName) {
        String viewName = ViewHelper.constructViewName(bucketName, fieldName, CouchBaseDataTypesHelper.DataType.DATE);
        String mapFunction = "function (doc, meta) {\n    if (doc.keys && doc.keys." + fieldName + ") {\n" + "        for (i = 0 ; i < doc.keys." + fieldName + ".length ; i++) {\n" + "            emit(parseInt(doc.keys." + fieldName + "[i], 10), 1);\n" + "        }\n" + "    }\n" + "}";
        String reduceFunction = "_count";
        logger.info("view result map : \n" + mapFunction);
        logger.info("view result reduce : \n" + reduceFunction);
        return new ViewDesign(viewName, mapFunction, reduceFunction);
    }

    public static ViewDesign getStringView(String fieldName) {
        return ViewHelper.getStringView("", fieldName);
    }

    public static ViewDesign getStringView(String bucketName, String fieldName) {
        String viewName = ViewHelper.constructViewName(bucketName, fieldName, CouchBaseDataTypesHelper.DataType.STRING);
        String mapFunction = "function (doc, meta) {\n    if (doc.keys && doc.keys." + fieldName + ") {\n" + "        for (i = 0 ; i < doc.keys." + fieldName + ".length ; i++) {\n" + "            emit(doc.keys." + fieldName + "[i], 1);\n" + "        }\n" + "    }\n" + "}";
        String reduceFunction = "_count";
        logger.info("view result map : \n" + mapFunction);
        logger.info("view result reduce : \n" + reduceFunction);
        return new ViewDesign(viewName, mapFunction, reduceFunction);
    }

    public static ViewDesign getView(String fieldName, CouchBaseDataTypesHelper.DataType datatype) {
        return ViewHelper.getView("", fieldName, datatype);
    }

    public static ViewDesign getView(String bucketName, String fieldName, CouchBaseDataTypesHelper.DataType datatype) {
        ViewDesign vd = null;
        switch (datatype) {
            case INTEGER: {
                vd = ViewHelper.getIntegerView(bucketName, fieldName);
                break;
            }
            case FLOAT: {
                vd = ViewHelper.getFloatView(bucketName, fieldName);
                break;
            }
            case DATE: {
                vd = ViewHelper.getDateView(bucketName, fieldName);
                break;
            }
            case STRING: {
                vd = ViewHelper.getStringView(bucketName, fieldName);
                break;
            }
        }
        return vd;
    }

    public static void main(String[] args) {
        ViewHelper.getDateView("startDate");
        ViewHelper.getStringView("title");
        ViewHelper.getIntegerView("myint");
        ViewHelper.getFloatView("myfloat");
    }
}

