package org.gcube.elasticsearch.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map.Entry;

import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.highlight.HighlightField;
import org.gcube.indexmanagement.common.IndexType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import edu.emory.mathcs.backport.java.util.Collections;

public class SnippetsHelper {
	private static final Logger logger = LoggerFactory.getLogger(SnippetsHelper.class);

	private static final SnippetsComparator snippetsComparator = new SnippetsComparator();
	public static final String SNIPPET_TOKEN = "...";
	public static final List<String> NOT_HIGHLIGHTED_FIELDS = Arrays.asList(IndexType.COLLECTION_FIELD,
			IndexType.DOCID_FIELD, IndexType.LANGUAGE_FIELD);

	private static class SnippetsComparator implements Comparator<String> {
		@Override
		public int compare(String o1, String o2) {
			return o2.length() - o1.length();
		}
	}

	public static String createSnippetString(SearchHit hit, int maxSnippetCount) {
		List<String> snippets = new ArrayList<String>();

		logger.trace("Creating snippets for hit : " + hit);

		for (Entry<String, HighlightField> snippet : hit.getHighlightFields().entrySet()){
			if (NOT_HIGHLIGHTED_FIELDS.contains(snippet.getKey()))
				continue;
			if (snippet.getValue() != null && snippet.getValue().getFragments() != null)
				for (Text text : snippet.getValue().getFragments())
					snippets.add(text.string());
		}

		logger.trace("snippets found : " + snippets);

		Collections.sort(snippets, snippetsComparator);

		int snippetsCnt = 0;
		StringBuilder strb = new StringBuilder();
		for (String s : snippets) {
			strb.append(s.trim());
			strb.append(SNIPPET_TOKEN);
			snippetsCnt++;
			if (snippetsCnt >= maxSnippetCount)
				break;
		}

		String snippet = strb.toString().trim();
		logger.trace("snippets string : " + snippet);

		return snippet;
	}
}
