/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnippetsHelper {
    private static final Logger logger = LoggerFactory.getLogger(SnippetsHelper.class);
    private static final SnippetsComparator snippetsComparator = new SnippetsComparator();
    public static final String SNIPPET_TOKEN = "...";
    public static final List<String> NOT_HIGHLIGHTED_FIELDS = Arrays.asList("gDocCollectionID", "ObjectID", "gDocCollectionLang");

    public static String createSnippetString(SearchHit hit, int maxSnippetCount) {
        ArrayList<String> snippets = new ArrayList<String>();
        logger.trace("Creating snippets for hit : " + hit);
        for (Map.Entry snippet : hit.getHighlightFields().entrySet()) {
            if (NOT_HIGHLIGHTED_FIELDS.contains(snippet.getKey()) || snippet.getValue() == null || ((HighlightField)snippet.getValue()).getFragments() == null) continue;
            for (Text text : ((HighlightField)snippet.getValue()).getFragments()) {
                snippets.add(text.string());
            }
        }
        logger.trace("snippets found : " + snippets);
        Collections.sort(snippets, snippetsComparator);
        int snippetsCnt = 0;
        StringBuilder strb = new StringBuilder();
        for (String s : snippets) {
            strb.append(s.trim());
            strb.append(SNIPPET_TOKEN);
            if (++snippetsCnt < maxSnippetCount) continue;
            break;
        }
        String snippet = strb.toString().trim();
        logger.trace("snippets string : " + snippet);
        return snippet;
    }

    private static class SnippetsComparator
    implements Comparator<String> {
        private SnippetsComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o2.length() - o1.length();
        }
    }
}

