/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch.helpers;

import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.StringField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.elasticsearch.FTNodeCache;
import org.gcube.indexmanagement.common.FullTextIndexType;
import org.gcube.indexmanagement.common.IndexField;
import org.gcube.indexmanagement.common.XMLTokenReplacer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowsetParser {
    private static final Logger logger = LoggerFactory.getLogger(RowsetParser.class);
    private static String regexIdxTypeNameRowset = "<ROWSET[^>]*idxType=\"([^\"]*?)\"";
    private static Pattern patternIdxTypeNameRowset = Pattern.compile(regexIdxTypeNameRowset);
    private static String regexLangRowset = "<ROWSET[^>]*lang=\"([^\"]*?)\"";
    private static Pattern patternLangRowset = Pattern.compile(regexLangRowset);
    private static String regexColIDRowset = "<ROWSET[^>]*colID=\"([^\"]*?)\"";
    private static Pattern patternColIDRowset = Pattern.compile(regexColIDRowset);
    private static String regexField = "<FIELD\\s+(?:lang=\"([^\"]*?)\"\\s+)*(?:[^>]*?\\s+)??name=\"([^\"]*?)\"(?:\\s+lang=\"([^\"]*?)\"\\s*)*\\s*>\\s*(.*?)\\s*</";
    private static Pattern patternField = Pattern.compile(regexField);
    private static final String ROWSETFIELD = "Rowset";

    public static String getIdxTypeNameRowset(String rowset) {
        return RowsetParser.getMatchRegex(patternIdxTypeNameRowset, rowset);
    }

    public static String getLangRowset(String rowset) {
        return RowsetParser.getMatchRegex(patternLangRowset, rowset);
    }

    public static String getColIDRowset(String rowset) {
        return RowsetParser.getMatchRegex(patternColIDRowset, rowset);
    }

    private static String getMatchRegex(Pattern pattern, String rowset) {
        Matcher m = pattern.matcher(rowset);
        String match = null;
        try {
            if (m.find()) {
                match = m.group(1).trim();
                return !match.equals("") ? match : null;
            }
        }
        catch (Exception e) {
            logger.error("exception while getting idxType", (Throwable)e);
        }
        return match;
    }

    public static String preprocessRowset(String rowset, String lang, String colID, String indexName, String IdxTypeID, String scope, FTNodeCache cache) {
        int payloadIndex = rowset.indexOf("fullpayload");
        if (payloadIndex > -1) {
            logger.trace("Found payload field");
            String payload = rowset.substring(payloadIndex + "fullpayload".length()).trim();
            if (payload.charAt(0) != '\"') {
                logger.warn("please check the rowsets to be fed in the index. While there is a fullpayload keyword, it doesn't seem to be a FIELD");
            } else {
                int payloadStart = rowset.indexOf(62, payloadIndex);
                int testInsideElement = rowset.indexOf(60, payloadIndex);
                if (payloadStart == -1) {
                    logger.warn("please check the rowsets to be fed in the index. While there is a fullpayload keyword, it seems to be in a weird spot");
                } else if (testInsideElement != -1 && payloadStart > testInsideElement) {
                    logger.warn("please check the rowsets to be fed in the index. While there is a fullpayload keyword, it doesn't seem to be INSIDE a FIELD");
                } else {
                    int payloadEnd = rowset.indexOf("</FIELD>", payloadStart);
                    if (payloadEnd == -1) {
                        logger.warn("please check the rowsets to be fed in the index. Thefullpayload keyword, must be out of FIELD");
                    }
                    payload = rowset.substring(payloadStart + 1, payloadEnd);
                    payload = XMLTokenReplacer.XMLUnresolve((String)payload);
                    rowset = rowset.substring(0, payloadStart + 1) + payload + rowset.substring(payloadEnd);
                }
            }
        }
        StringBuilder alteredRowSet = new StringBuilder("<ROWSET>\n");
        boolean first = true;
        for (String row : rowset.split("<ROW>")) {
            if (first) {
                first = false;
                continue;
            }
            Matcher m = patternField.matcher(row);
            HashMap<String, String> fields = new HashMap<String, String>();
            try {
                while (m.find()) {
                    String fieldName = m.group(2).trim();
                    String fieldContent = m.group(4).trim();
                    String sumContent = (String)fields.get(fieldName);
                    sumContent = sumContent == null ? fieldContent : sumContent + " " + fieldContent;
                    fields.put(fieldName, sumContent);
                    logger.trace("putting in fieldName: " + fieldName + ", new content: " + fieldContent);
                }
            }
            catch (Exception e) {
                logger.error(indexName + " exception while adding language fields", (Throwable)e);
            }
            logger.trace("Fields keySet: " + fields.keySet().size());
            String content = null;
            content = (String)fields.get("gDocCollectionID");
            if (content != null) {
                logger.error("-- rowset has already a value: " + content + "for the reserved field " + "gDocCollectionID" + ", that will be dropped.");
            }
            fields.put("gDocCollectionID", colID);
            content = null;
            content = (String)fields.get("gDocCollectionLang");
            if (content != null) {
                logger.error("-- rowset has already a value: " + content + "for the reserved field " + "gDocCollectionLang" + ", that will be dropped.");
            }
            fields.put("gDocCollectionLang", lang);
            if (fields.isEmpty()) continue;
            alteredRowSet.append("   <ROW>\n");
            for (String field : fields.keySet()) {
                alteredRowSet.append("      <FIELD name=\"");
                alteredRowSet.append(field);
                alteredRowSet.append("\">");
                alteredRowSet.append(((String)fields.get(field)).trim());
                alteredRowSet.append("</FIELD>\n");
            }
            alteredRowSet.append("   </ROW>\n");
        }
        alteredRowSet.append("</ROWSET>\n");
        return alteredRowSet.toString();
    }

    public static boolean addToFieldInfo(ArrayList<String> toBeAdded, String field, String colIDandLang, FullTextIndexType idxType) {
        boolean found = false;
        boolean searchable = false;
        boolean presentable = false;
        for (IndexField idxField : idxType.getFields()) {
            if (!idxField.name.equals(field)) continue;
            found = true;
            searchable = idxField.index;
            presentable = idxField.returned;
            break;
        }
        if (field.equalsIgnoreCase("ObjectID")) {
            searchable = true;
            presentable = false;
        } else if (!found) {
            logger.error("The field: " + field + ", is not declared in the indexType.");
            return false;
        }
        if (searchable) {
            toBeAdded.add(colIDandLang + ":" + "s" + ":" + field);
        }
        if (presentable) {
            toBeAdded.add(colIDandLang + ":" + "p" + ":" + field);
        }
        return true;
    }

    public static String getRowsetFromResult(Record record) throws GRS2RecordDefinitionException, GRS2BufferException {
        return ((StringField)record.getField(ROWSETFIELD)).getPayload();
    }
}

