package org.gcube.elasticsearch.helpers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.Resources;

public class Main {
	public static final String STOPWORDS_FILENAME = "stopwords.txt";
	
	
	public static void main(String[] args) {
		List<String> STOPWORDS = null;

		try {
			
			
			URL url1 = ClassLoader.class.getResource("/" + STOPWORDS_FILENAME);
			
			System.out.println("url1 : " + url1);
			if (url1 != null)
				System.out.println("uri1 : " + url1.toURI());
			
			
			URL url2 = ClassLoader.class.getResource(STOPWORDS_FILENAME);
			
			System.out.println("url2 : " +url2);
			if (url2 != null)
				System.out.println("uri2 : " +url2.toURI());
			
			
			
			URL url = Resources.getResource(STOPWORDS_FILENAME);
			
			System.out.println("url : " + url);
			if (url !=null)
				System.out.println("uri : " + url.toURI());
			
			STOPWORDS = Files.readLines(new File(url.toURI()), Charsets.UTF_8);
		} catch (IOException | URISyntaxException e) {
			e.printStackTrace();
		}
		
		
		System.out.println(STOPWORDS);
	}

}
