/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch.helpers;

import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.count.CountRequestBuilder;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequestBuilder;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.facet.FacetBuilder;
import org.elasticsearch.search.facet.FacetBuilders;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.gcube.elasticsearch.exceptions.ElasticSearchHelperException;
import org.gcube.elasticsearch.helpers.FullTextIndexDocument;
import org.gcube.elasticsearch.helpers.SnippetsHelper;
import org.gcube.indexmanagement.common.FullTextIndexType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchHelper {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchHelper.class);
    private static long SCROLL_TIMEOUT = 100000L;
    private static int MAX_RESULTS = 2000;
    private static final String HIGHLIGHT_PRE_TAG = "&lt;b&gt;";
    private static final String HIGHLIGHT_POST_TAG = "&lt;/b&gt;";
    public static final String SECURITY_FIELD = "sid";
    public static final String STOPWORDS_FILENAME = "stopwords.txt";
    private static List<String> STOPWORDS = null;
    static final String FREQUENT_TERMS_FACET = "frequent_terms";

    public static void main(String[] args) {
        System.out.println(STOPWORDS);
    }

    public static void commit(Client client, String indexName) {
        try {
            logger.info("flush request: " + indexName);
            long before = System.currentTimeMillis();
            FlushResponse flushResponse = (FlushResponse)client.admin().indices().prepareFlush(new String[]{indexName}).get();
            long after = System.currentTimeMillis();
            logger.info("Time for the flush request : " + (double)(after - before) / 1000.0 + " secs");
            logger.info("flush response  failed shards: " + flushResponse.getFailedShards());
            logger.info("refresh request : " + indexName);
            before = System.currentTimeMillis();
            RefreshResponse refreshResponse = (RefreshResponse)client.admin().indices().prepareRefresh(new String[]{indexName}).get();
            after = System.currentTimeMillis();
            logger.info("Time for the flush request : " + (double)(after - before) / 1000.0 + " secs");
            logger.info("refresh response failed shards : " + refreshResponse.getFailedShards());
        }
        catch (Exception e) {
            logger.error("Exception while commiting:", (Throwable)e);
        }
    }

    public static Map<String, Integer> termsFacetElasticSearch(Client client, String indexName, QueryBuilder qb, int maxTerms, List<String> projections) {
        SearchRequestBuilder srb = client.prepareSearch(new String[]{indexName}).setSize(0).setQuery(qb);
        srb.addFacet((FacetBuilder)FacetBuilders.termsFacet((String)FREQUENT_TERMS_FACET).fields((String[])Iterables.toArray(projections, String.class)).size(maxTerms).exclude(STOPWORDS.toArray()));
        srb.setFetchSource(ElasticSearchHelper.createFetchSourceArray(projections), null);
        srb.addField("ObjectID");
        logger.trace("query request : " + srb.toString());
        logger.info("query request : " + srb.toString());
        SearchResponse response = (SearchResponse)srb.get();
        logger.info("query time : " + response.getTookInMillis());
        logger.trace("query response : " + response);
        TermsFacet facet = (TermsFacet)response.getFacets().facet(FREQUENT_TERMS_FACET);
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        for (TermsFacet.Entry entry : facet) {
            map.put(entry.getTerm().string(), entry.getCount());
        }
        return map;
    }

    public static SearchHit[] queryElasticSearch(Client client, String indexName, QueryBuilder qb, int maxHits, List<String> projections, List<AbstractMap.SimpleEntry<String, String>> sortBys) {
        return ElasticSearchHelper.queryElasticSearch(client, indexName, qb, maxHits, null, projections, 0, 0, 0, sortBys);
    }

    public static SearchHit[] queryElasticSearch(Client client, String indexName, QueryBuilder qb, int maxHits, int from, List<String> projections, List<AbstractMap.SimpleEntry<String, String>> sortBys) {
        return ElasticSearchHelper.queryElasticSearch(client, indexName, qb, maxHits, null, projections, 0, 0, from, sortBys);
    }

    public static SearchHit[] queryElasticSearch(Client client, String indexName, QueryBuilder qb, int maxHits, List<String> highlightedFields, List<String> projections, int maxFragmentSize, int maxFragmentCnt, int from, List<AbstractMap.SimpleEntry<String, String>> sortBys) {
        SearchRequestBuilder srb = client.prepareSearch(new String[]{indexName}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setSize(MAX_RESULTS).setFrom(from).setQuery(qb);
        srb.setFetchSource(ElasticSearchHelper.createFetchSourceArray(projections), null);
        srb.addField("ObjectID");
        if (highlightedFields != null) {
            for (String string : highlightedFields) {
                if (SnippetsHelper.NOT_HIGHLIGHTED_FIELDS.contains(string)) continue;
                srb.addHighlightedField(string, maxFragmentSize, maxFragmentCnt);
            }
            srb.setHighlighterOrder("score");
            srb.setHighlighterPreTags(new String[]{HIGHLIGHT_PRE_TAG});
            srb.setHighlighterPostTags(new String[]{HIGHLIGHT_POST_TAG});
        }
        if (sortBys != null) {
            for (Map.Entry entry : sortBys) {
                String sortByField = (String)entry.getKey();
                SortOrder sortOrder = ((String)entry.getValue()).equalsIgnoreCase("ASC") ? SortOrder.ASC : SortOrder.DESC;
                srb.addSort((SortBuilder)SortBuilders.fieldSort((String)(sortByField + "_raw")).order(sortOrder));
            }
        }
        if (maxHits > 0) {
            srb.setSize(maxHits);
        }
        logger.trace("query request : " + srb.toString());
        logger.info("query request : " + srb.toString());
        SearchResponse response = (SearchResponse)srb.get();
        logger.info("query time : " + response.getTookInMillis());
        logger.trace("query response : " + response);
        return response.getHits().getHits();
    }

    public static String[] createFetchSourceArray(List<String> projections) {
        HashSet<String> fetchSource = new HashSet<String>();
        if (projections != null && projections.size() > 0) {
            fetchSource.addAll(projections);
        }
        return fetchSource.toArray(new String[0]);
    }

    public static SearchResponse queryElasticSearchScroll(Client client, String indexName, QueryBuilder qb, int maxHits, List<String> projections, List<AbstractMap.SimpleEntry<String, String>> sortBys) {
        return ElasticSearchHelper.queryElasticSearchScroll(client, indexName, qb, maxHits, null, projections, 0, 0, sortBys);
    }

    public static SearchResponse queryElasticSearchScroll(Client client, String indexName, QueryBuilder qb, int maxHits, List<String> highlightedFields, List<String> projections, int maxFragmentSize, int maxFragmentCnt, List<AbstractMap.SimpleEntry<String, String>> sortBys) {
        SearchRequestBuilder srb = client.prepareSearch(new String[]{indexName}).setTrackScores(true).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setScroll(TimeValue.timeValueMillis((long)SCROLL_TIMEOUT)).setQuery(qb);
        srb.setFetchSource(ElasticSearchHelper.createFetchSourceArray(projections), null);
        srb.addField("ObjectID");
        if (maxHits > 0) {
            srb.setSize(maxHits);
        }
        if (highlightedFields != null) {
            for (String string : highlightedFields) {
                if (SnippetsHelper.NOT_HIGHLIGHTED_FIELDS.contains(string)) continue;
                srb.addHighlightedField(string, maxFragmentSize, maxFragmentCnt);
            }
            srb.setHighlighterOrder("score");
            srb.setHighlighterPreTags(new String[]{HIGHLIGHT_PRE_TAG});
            srb.setHighlighterPostTags(new String[]{HIGHLIGHT_POST_TAG});
        }
        if (sortBys != null) {
            for (Map.Entry entry : sortBys) {
                String sortByField = (String)entry.getKey();
                SortOrder sortOrder = ((String)entry.getValue()).equalsIgnoreCase("ASC") ? SortOrder.ASC : SortOrder.DESC;
                srb.addSort((SortBuilder)SortBuilders.fieldSort((String)(sortByField + "_raw")).order(sortOrder));
            }
        }
        logger.info("query request : " + srb.toString());
        SearchResponse scrollResponse = (SearchResponse)srb.get();
        logger.info("query response : " + scrollResponse);
        return scrollResponse;
    }

    public static Long collectionDocumentsCountElasticSearch(Client client, String indexName, String collectionID) {
        String queryString = "gDocCollectionID == " + collectionID;
        QueryStringQueryBuilder qb = QueryBuilders.queryString((String)queryString);
        Long count = ElasticSearchHelper.queryCountElasticSearch(client, indexName, (QueryBuilder)qb);
        return count;
    }

    public static Long queryCountElasticSearch(Client client, String indexName, QueryBuilder qb) {
        CountRequestBuilder countRequest = client.prepareCount(new String[]{indexName}).setQuery(qb);
        logger.info("query request : " + countRequest.request());
        CountResponse countResponse = (CountResponse)countRequest.get();
        logger.info("query response : " + countResponse);
        return countResponse.getCount();
    }

    public static SearchResponse getNextSearchResponse(Client client, SearchResponse scrollResponse) {
        scrollResponse = (SearchResponse)client.prepareSearchScroll(scrollResponse.getScrollId()).setScroll(TimeValue.timeValueMillis((long)SCROLL_TIMEOUT)).get();
        logger.info("scroll response : " + scrollResponse);
        return scrollResponse;
    }

    public static boolean deleteAllIndices(Client client) {
        logger.info("deleting all indices");
        try {
            DeleteIndexResponse delete = (DeleteIndexResponse)client.admin().indices().delete(new DeleteIndexRequest("_all")).actionGet(30L, TimeUnit.SECONDS);
            if (!delete.isAcknowledged()) {
                logger.error("Index wasn't deleted");
            }
            return delete.isAcknowledged();
        }
        catch (Exception e) {
            logger.error("error deleting all indices", (Throwable)e);
            return false;
        }
    }

    public static boolean delete(Client client, String indexName) {
        logger.info("deleting index : " + indexName);
        boolean exists = ((IndicesExistsResponse)client.admin().indices().exists(new IndicesExistsRequest(new String[]{indexName})).actionGet()).isExists();
        if (!exists) {
            logger.info("index : " + indexName + " does not exist");
            return true;
        }
        logger.info("index : " + indexName + " exists");
        DeleteIndexResponse delete = (DeleteIndexResponse)client.admin().indices().delete(new DeleteIndexRequest(indexName)).actionGet(30L, TimeUnit.SECONDS);
        if (!delete.isAcknowledged()) {
            logger.error("Index wasn't deleted");
        }
        logger.info("deleted index : " + indexName + " ? " + delete.isAcknowledged());
        return delete.isAcknowledged();
    }

    public static void deleteDocuments(Client client, String indexName, List<String> docIDs) {
        logger.info("docIds to be deleted : " + docIDs);
        for (String docID : docIDs) {
            logger.info("deleting document with gDocCollectionID : " + docID);
            DeleteByQueryRequestBuilder requestBuilder = client.prepareDeleteByQuery(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"ObjectID", (String)docID));
            logger.info("delete request : " + requestBuilder.request());
            requestBuilder.get();
        }
        ElasticSearchHelper.commit(client, indexName);
    }

    public static Boolean deleteCollections(Client client, String indexName, Collection<String> colls) {
        Boolean ret = true;
        for (String coll : colls) {
            Boolean collDelete = ElasticSearchHelper.deleteCollection(client, indexName, coll);
            if (collDelete.booleanValue()) continue;
            logger.warn("couldn't delete collection : " + coll);
            ret = false;
        }
        return ret;
    }

    public static Boolean deleteCollection(Client client, String indexName, String collID) {
        logger.info("collId to be deleted : " + collID);
        logger.info("deleting document with gDocCollectionID : " + collID);
        DeleteByQueryRequestBuilder requestBuilder = client.prepareDeleteByQuery(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"gDocCollectionID", (String)collID));
        logger.info("delete request : " + requestBuilder.request());
        DeleteByQueryResponse response = (DeleteByQueryResponse)requestBuilder.get();
        logger.info("delete response : " + response.toString());
        ElasticSearchHelper.commit(client, indexName);
        return true;
    }

    public static Boolean collectionExists(Client client, String indexName, String collID) {
        logger.info("collId to be checked : " + collID);
        logger.info("checking collection with gDocCollectionID : " + collID);
        SearchRequestBuilder requestBuilder = client.prepareSearch(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"gDocCollectionID", (String)collID));
        logger.info("search request : " + requestBuilder.request());
        SearchResponse response = (SearchResponse)requestBuilder.get();
        if (response.getHits().getTotalHits() > 0L) {
            return true;
        }
        return false;
    }

    public static Set<String> indicesOfCollection(Client client, String indexName, String collID) {
        HashSet<String> indices = new HashSet<String>();
        logger.info("collId to be checked : " + collID);
        logger.info("checking collection with gDocCollectionID : " + collID);
        SearchRequestBuilder requestBuilder = client.prepareSearch(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"gDocCollectionID", (String)collID));
        logger.info("search request : " + requestBuilder.request());
        SearchResponse response = (SearchResponse)requestBuilder.get();
        for (SearchHit hit : response.getHits().getHits()) {
            indices.add(hit.getIndex());
        }
        return indices;
    }

    public static Set<String> getIndicesOfAlias(Client client, String alias) {
        logger.info("calling aliasResponse");
        GetAliasesResponse aliasResponse = (GetAliasesResponse)client.admin().indices().prepareGetAliases(new String[]{alias}).get();
        logger.info("alias response : " + aliasResponse);
        ImmutableOpenMap aliases = aliasResponse.getAliases();
        logger.info("aliases : " + aliases);
        if (aliases == null || aliases.size() == 0) {
            return null;
        }
        HashSet indices = Sets.newHashSet((Iterator)aliases.keysIt());
        logger.info("indices of alias : " + indices);
        return indices;
    }

    public static List<MultiGetItemResponse> getMultipleDocumentsOfAlias(Client client, String alias, Collection<String> docIDs) {
        logger.info("getting multiple documents of alias for alias : " + alias + " docIDs : " + docIDs);
        Set<String> indicesOfAlias = ElasticSearchHelper.getIndicesOfAlias(client, alias);
        logger.info("indicesOfAlias : " + indicesOfAlias);
        if (indicesOfAlias == null) {
            return new ArrayList<MultiGetItemResponse>();
        }
        return ElasticSearchHelper.getMultipleDocuments(client, indicesOfAlias, docIDs);
    }

    public static List<MultiGetItemResponse> getMultipleDocuments(Client client, Set<String> indices, Collection<String> docIDs) {
        ArrayList<MultiGetItemResponse> documents = new ArrayList<MultiGetItemResponse>(docIDs.size());
        for (String index : indices) {
            MultiGetRequestBuilder grb = new MultiGetRequestBuilder(client).add(index, null, docIDs);
            MultiGetResponse mgr = (MultiGetResponse)grb.get();
            for (MultiGetItemResponse response : mgr.getResponses()) {
                if (response == null || response.getResponse() == null || !response.getResponse().isExists()) continue;
                documents.add(response);
            }
        }
        return documents;
    }

    public static Set<String> getAllCollectionsOfIndex(Client client, String indexName) {
        logger.info("getting all collections of index : " + indexName);
        HashSet<String> collections = new HashSet<String>();
        SearchRequestBuilder requestBuilder = client.prepareSearch(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).addField("gDocCollectionID");
        SearchResponse sr = (SearchResponse)requestBuilder.get();
        for (SearchHit hit : sr.getHits().getHits()) {
            String collection = ((SearchHitField)hit.getFields().get("gDocCollectionID")).getValue().toString();
            collections.add(collection);
        }
        return collections;
    }

    public static void clearIndex(Client client, String indexName, String indexTypeName) {
        logger.info("index to be deleted : ");
        DeleteByQueryResponse dr = (DeleteByQueryResponse)client.prepareDeleteByQuery(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setTypes(new String[]{indexTypeName}).get();
        logger.info("Delete response : " + dr.toString());
        ElasticSearchHelper.commit(client, indexName);
    }

    public static void insertSimple(String jsonDoc, Client indexClient, String indexName, String indexType, Set<String> allowedIndexTypes) throws ElasticSearchHelperException {
        if (!allowedIndexTypes.contains(indexType)) {
            throw new ElasticSearchHelperException("index type : " + indexType + " is not in registered index types : " + allowedIndexTypes);
        }
        IndexResponse response = (IndexResponse)indexClient.prepareIndex(indexName, indexType).setSource(jsonDoc).get();
        logger.info("indexResponse : " + response);
    }

    public static void insertBulk(BulkRequestBuilder bulkRequest, String jsonDoc, Client indexClient, String indexName, String indexType, Set<String> allowedIndexTypes) throws ElasticSearchHelperException {
        if (!allowedIndexTypes.contains(indexType + "-" + indexName)) {
            throw new ElasticSearchHelperException("index type : " + indexType + " is not in registered index types : " + allowedIndexTypes);
        }
        IndexRequestBuilder indexRequest = indexClient.prepareIndex(indexName, indexType).setSource(jsonDoc);
        bulkRequest.add(indexRequest);
        logger.info("indexRequest : " + indexRequest);
    }

    public static Boolean insertRowSet(BulkRequestBuilder bulkRequest, Client client, String indexName, FullTextIndexType idxType, Set<String> allowedIndexTypes, String rowsetXML, Set<String> securityIdentifiers) {
        logger.trace("indexName : " + indexName);
        logger.trace("idxType : " + idxType.getIndexTypeName());
        logger.trace("allowedIndexTypes : " + allowedIndexTypes);
        logger.trace("rowsetXML : " + rowsetXML);
        try {
            FullTextIndexDocument document = new FullTextIndexDocument(rowsetXML);
            Map<String, List<String>> docFields = document.getFields();
            docFields.put(SECURITY_FIELD, new ArrayList<String>(securityIdentifiers));
            ElasticSearchHelper.insertBulk(bulkRequest, ElasticSearchHelper.createJSONObject(document.getFields()).string(), client, indexName, idxType.getIndexTypeName(), allowedIndexTypes);
            return true;
        }
        catch (Exception e) {
            logger.warn("Exception while inserting documents", (Throwable)e);
            return false;
        }
    }

    public static XContentBuilder createJSONObject(Map<String, ? extends Object> keyValues) throws IOException {
        XContentBuilder xcb = XContentFactory.jsonBuilder();
        xcb = xcb.startObject();
        for (Map.Entry<String, ? extends Object> keyvalue : keyValues.entrySet()) {
            if (keyvalue.getValue() instanceof List && ((List)keyvalue.getValue()).size() == 1) {
                logger.debug("single value : " + keyvalue.getValue());
                String val = ((List)keyvalue.getValue()).get(0).toString();
                xcb = xcb.field(keyvalue.getKey(), val);
                continue;
            }
            logger.debug("multi value : " + keyvalue.getValue());
            xcb = xcb.field(keyvalue.getKey(), keyvalue.getValue());
        }
        return xcb.endObject();
    }

    static {
        try {
            URL url = Resources.getResource((String)STOPWORDS_FILENAME);
            STOPWORDS = Files.readLines((File)new File(url.toURI()), (Charset)Charsets.UTF_8);
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            logger.error("not able to load stopwords", (Throwable)e);
        }
    }
}

