package org.gcube.elasticsearch;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.gcube.indexmanagement.common.FullTextIndexType;


public class FTNodeCache implements Serializable {
	private static final long serialVersionUID = 1L;
	
	public Map<String, FullTextIndexType> cachedIndexTypes = null;
	public Map<String, Set<String>> indexTypesByCollIDs = null;
	public Map<String, List<String>> presentableFieldsPerIndexType = null;
	public Map<String, List<String>> searchableFieldsPerIndexType = null;
	public Map<String, List<String>> highlightableFieldsPerIndexType = null;
	
	public FTNodeCache() {
		this.init();
	}
	
	void init() {
		this.cachedIndexTypes = new HashMap<String, FullTextIndexType>();
		this.indexTypesByCollIDs = new HashMap<String, Set<String>>();
		this.presentableFieldsPerIndexType = new HashMap<String, List<String>>();
		this.searchableFieldsPerIndexType = new HashMap<String, List<String>>();
		this.highlightableFieldsPerIndexType = new HashMap<String, List<String>>();
	}
	
	public void invalidate() {
		this.init();
	}

	@Override
	public String toString() {
		return "FTNodeCache [cachedIndexTypes=" + this.cachedIndexTypes
				+ ", indexTypesByCollIDs=" + this.indexTypesByCollIDs
				+ ", presentableFieldsPerIndexType="
				+ this.presentableFieldsPerIndexType
				+ ", searchableFieldsPerIndexType="
				+ this.searchableFieldsPerIndexType
				+ ", highlightableFieldsPerIndexType="
				+ this.highlightableFieldsPerIndexType + "]";
	}

	
	
	
}