/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch.helpers;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.count.CountRequestBuilder;
import org.elasticsearch.action.count.CountResponse;
import org.elasticsearch.action.deletebyquery.DeleteByQueryRequestBuilder;
import org.elasticsearch.action.deletebyquery.DeleteByQueryResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.facet.FacetBuilder;
import org.elasticsearch.search.facet.FacetBuilders;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.gcube.elasticsearch.exceptions.ElasticSearchHelperException;
import org.gcube.elasticsearch.helpers.FullTextIndexDocument;
import org.gcube.elasticsearch.helpers.SnippetsHelper;
import org.gcube.indexmanagement.common.FullTextIndexType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchHelper {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchHelper.class);
    private static long SCROLL_TIMEOUT = 100000L;
    private static int MAX_RESULTS = 1000;
    private static final String HIGHLIGHT_PRE_TAG = "&lt;b&gt;";
    private static final String HIGHLIGHT_POST_TAG = "&lt;/b&gt;";
    public static final String SECURITY_FIELD = "sid";
    public static final String STOPWORDS_FILENAME = "stopwords.txt";
    private static List<String> STOPWORDS = null;
    static final String FILTER_BY_LENGTH_SCRIPT = "filter_by_length";
    static final String FREQUENT_TERMS_FACET = "frequent_terms";
    static final Integer FREQUENT_TERMS_MIN_LENGTH = 3;
    static final String ALL_COLLECTIONS_FACET_NAME = "ALL_COLLECTIONS";
    static final String ALL_LANGUAGES_PER_COLLECTION_FACET_NAME = "ALL_LANGUAGES_PER_COLLECTION";

    public static void commit(Client client, String indexName) {
        try {
            logger.info("flush request: " + indexName);
            long before = System.currentTimeMillis();
            FlushResponse flushResponse = (FlushResponse)client.admin().indices().prepareFlush(new String[]{indexName}).get();
            long after = System.currentTimeMillis();
            logger.info("Time for the flush request : " + (double)(after - before) / 1000.0 + " secs");
            logger.info("flush response  failed shards: " + flushResponse.getFailedShards());
            logger.info("refresh request : " + indexName);
            before = System.currentTimeMillis();
            RefreshResponse refreshResponse = (RefreshResponse)client.admin().indices().prepareRefresh(new String[]{indexName}).get();
            after = System.currentTimeMillis();
            logger.info("Time for the flush request : " + (double)(after - before) / 1000.0 + " secs");
            logger.info("refresh response failed shards : " + refreshResponse.getFailedShards());
        }
        catch (Exception e) {
            logger.error("Exception while commiting:", (Throwable)e);
        }
    }

    public static Map<String, Integer> termsFacetElasticSearch(Client client, String indexName, QueryBuilder qb, int maxTerms, List<String> projections) {
        try {
            SearchRequestBuilder srb = client.prepareSearch(new String[]{indexName}).setSize(0).setQuery(qb);
            srb.addFacet((FacetBuilder)FacetBuilders.termsFacet((String)FREQUENT_TERMS_FACET).fields((String[])Iterables.toArray(projections, String.class)).size(maxTerms).script(FILTER_BY_LENGTH_SCRIPT).exclude(STOPWORDS.toArray()));
            srb.setFetchSource(ElasticSearchHelper.createFetchSourceArray(projections), null);
            srb.addField("ObjectID");
            logger.trace("query request : " + srb.toString());
            logger.info("query request : " + srb.toString());
            SearchResponse response = (SearchResponse)srb.get();
            logger.info("query time : " + response.getTookInMillis());
            logger.trace("query response : " + response);
            TermsFacet facet = (TermsFacet)response.getFacets().facet(FREQUENT_TERMS_FACET);
            LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
            for (TermsFacet.Entry entry : facet) {
                if (entry.getTerm().string().length() > FREQUENT_TERMS_MIN_LENGTH) {
                    map.put(entry.getTerm().string(), entry.getCount());
                    continue;
                }
                logger.trace(entry.getTerm().string() + " longer than : " + FREQUENT_TERMS_MIN_LENGTH);
            }
            if (logger.isTraceEnabled()) {
                logger.info("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                for (Map.Entry term : map.entrySet()) {
                    logger.info(" ~> " + (String)term.getKey() + " : " + term.getValue());
                }
                logger.info("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            }
            return map;
        }
        catch (Exception e) {
            logger.warn("error while searching for terms of index : " + indexName + ". will return empty list", (Throwable)e);
            return Maps.newHashMap();
        }
    }

    public static Set<String> allCollectionsOfIndexElasticSearch(Client client, String indexName) {
        try {
            SearchRequestBuilder srb = client.prepareSearch(new String[]{indexName}).setSize(0).setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
            srb.addFacet((FacetBuilder)FacetBuilders.termsFacet((String)ALL_COLLECTIONS_FACET_NAME).fields(new String[]{"gDocCollectionID"}).size(1000));
            logger.trace("query request : " + srb.toString());
            logger.info("query request : " + srb.toString());
            SearchResponse response = (SearchResponse)srb.get();
            logger.info("query time : " + response.getTookInMillis());
            logger.trace("query response : " + response);
            TermsFacet facet = (TermsFacet)response.getFacets().facet(ALL_COLLECTIONS_FACET_NAME);
            HashSet collections = Sets.newHashSet();
            for (TermsFacet.Entry entry : facet) {
                collections.add(entry.getTerm().string());
            }
            return collections;
        }
        catch (Exception e) {
            logger.warn("error while searching for collection of index : " + indexName + ". will return empty list", (Throwable)e);
            return Sets.newHashSet();
        }
    }

    public static Set<String> allLanguagesOfIndexElasticSearch(Client client, String indexName, String collection) {
        try {
            SearchRequestBuilder srb = client.prepareSearch(new String[]{indexName}).setSize(0).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"gDocCollectionID", (String)collection));
            srb.addFacet((FacetBuilder)FacetBuilders.termsFacet((String)ALL_LANGUAGES_PER_COLLECTION_FACET_NAME).fields(new String[]{"gDocCollectionLang"}).size(1000));
            logger.trace("query request : " + srb.toString());
            logger.info("query request : " + srb.toString());
            SearchResponse response = (SearchResponse)srb.get();
            logger.info("query time : " + response.getTookInMillis());
            logger.trace("query response : " + response);
            TermsFacet facet = (TermsFacet)response.getFacets().facet(ALL_LANGUAGES_PER_COLLECTION_FACET_NAME);
            HashSet langs = Sets.newHashSet();
            for (TermsFacet.Entry entry : facet) {
                langs.add(entry.getTerm().string());
            }
            return langs;
        }
        catch (Exception e) {
            logger.warn("error while searching for languages of index : " + indexName + ". will return empty list", (Throwable)e);
            return Sets.newHashSet();
        }
    }

    public static SearchHit[] queryElasticSearch(Client client, String indexName, QueryBuilder qb, int maxHits, List<String> projections, List<AbstractMap.SimpleEntry<String, String>> sortBys) {
        return ElasticSearchHelper.queryElasticSearch(client, indexName, qb, maxHits, null, projections, 0, 0, 0, sortBys);
    }

    public static SearchHit[] queryElasticSearch(Client client, String indexName, QueryBuilder qb, int maxHits, int from, List<String> projections, List<AbstractMap.SimpleEntry<String, String>> sortBys) {
        return ElasticSearchHelper.queryElasticSearch(client, indexName, qb, maxHits, null, projections, 0, 0, from, sortBys);
    }

    public static SearchHit[] queryElasticSearch(Client client, String indexName, QueryBuilder qb, int maxHits, List<String> highlightedFields, List<String> projections, int maxFragmentSize, int maxFragmentCnt, int from, List<AbstractMap.SimpleEntry<String, String>> sortBys) {
        SearchRequestBuilder srb = client.prepareSearch(new String[]{indexName}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setSize(MAX_RESULTS).setFrom(from).setQuery(qb);
        srb.setFetchSource(ElasticSearchHelper.createFetchSourceArray(projections), null);
        srb.addField("ObjectID");
        if (highlightedFields != null) {
            for (String string : highlightedFields) {
                if (SnippetsHelper.NOT_HIGHLIGHTED_FIELDS.contains(string)) continue;
                srb.addHighlightedField(string, maxFragmentSize, maxFragmentCnt);
            }
            srb.setHighlighterOrder("score");
            srb.setHighlighterPreTags(new String[]{HIGHLIGHT_PRE_TAG});
            srb.setHighlighterPostTags(new String[]{HIGHLIGHT_POST_TAG});
        }
        if (sortBys != null) {
            for (Map.Entry entry : sortBys) {
                String sortByField = (String)entry.getKey();
                SortOrder sortOrder = ((String)entry.getValue()).equalsIgnoreCase("ASC") ? SortOrder.ASC : SortOrder.DESC;
                srb.addSort((SortBuilder)SortBuilders.fieldSort((String)(sortByField + "_raw")).order(sortOrder));
            }
        }
        if (maxHits > 0) {
            srb.setSize(maxHits);
        }
        logger.trace("query request : " + srb.toString());
        logger.info("query request : " + srb.toString());
        SearchResponse response = (SearchResponse)srb.get();
        logger.info("query time : " + response.getTookInMillis());
        if (logger.isTraceEnabled()) {
            logger.trace("query response : " + response);
        }
        return response.getHits().getHits();
    }

    public static SearchResponse queryElasticSearchScroll(Client client, String indexName, QueryBuilder qb, int maxHits, List<String> projections, List<AbstractMap.SimpleEntry<String, String>> sortBys) {
        return ElasticSearchHelper.queryElasticSearchScroll(client, indexName, qb, maxHits, null, projections, 0, 0, sortBys);
    }

    public static SearchResponse queryElasticSearchScroll(Client client, String indexName, QueryBuilder qb, int maxHits, List<String> highlightedFields, List<String> projections, int maxFragmentSize, int maxFragmentCnt, List<AbstractMap.SimpleEntry<String, String>> sortBys) {
        SearchRequestBuilder srb = client.prepareSearch(new String[]{indexName}).setTrackScores(true).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setScroll(TimeValue.timeValueMillis((long)SCROLL_TIMEOUT)).setQuery(qb);
        srb.setFetchSource(ElasticSearchHelper.createFetchSourceArray(projections), null);
        srb.addField("ObjectID");
        if (maxHits > 0) {
            srb.setSize(maxHits);
        }
        if (highlightedFields != null) {
            for (String string : highlightedFields) {
                if (SnippetsHelper.NOT_HIGHLIGHTED_FIELDS.contains(string)) continue;
                srb.addHighlightedField(string, maxFragmentSize, maxFragmentCnt);
            }
            srb.setHighlighterOrder("score");
            srb.setHighlighterPreTags(new String[]{HIGHLIGHT_PRE_TAG});
            srb.setHighlighterPostTags(new String[]{HIGHLIGHT_POST_TAG});
        }
        if (sortBys != null) {
            for (Map.Entry entry : sortBys) {
                String sortByField = (String)entry.getKey();
                SortOrder sortOrder = ((String)entry.getValue()).equalsIgnoreCase("ASC") ? SortOrder.ASC : SortOrder.DESC;
                srb.addSort((SortBuilder)SortBuilders.fieldSort((String)(sortByField + "_raw")).order(sortOrder));
            }
        }
        logger.info("query request : " + srb.toString());
        SearchResponse scrollResponse = (SearchResponse)srb.get();
        logger.info("query response : " + scrollResponse);
        return scrollResponse;
    }

    public static Long collectionDocumentsCountElasticSearch(Client client, String indexName, String collectionID) {
        String queryString = "gDocCollectionID == " + collectionID;
        QueryStringQueryBuilder qb = QueryBuilders.queryString((String)queryString);
        Long count = ElasticSearchHelper.queryCountElasticSearch(client, indexName, (QueryBuilder)qb);
        return count;
    }

    public static Long queryCountElasticSearch(Client client, String indexName, QueryBuilder qb) {
        CountRequestBuilder countRequest = client.prepareCount(new String[]{indexName}).setQuery(qb);
        logger.info("query request : " + countRequest.request());
        CountResponse countResponse = (CountResponse)countRequest.get();
        logger.info("query response : " + countResponse);
        return countResponse.getCount();
    }

    public static SearchResponse getNextSearchResponse(Client client, SearchResponse scrollResponse) {
        scrollResponse = (SearchResponse)client.prepareSearchScroll(scrollResponse.getScrollId()).setScroll(TimeValue.timeValueMillis((long)SCROLL_TIMEOUT)).get();
        logger.info("scroll response : " + scrollResponse);
        return scrollResponse;
    }

    public static boolean deleteAllIndices(Client client) {
        logger.info("deleting all indices");
        try {
            DeleteIndexResponse delete = (DeleteIndexResponse)client.admin().indices().delete(new DeleteIndexRequest("_all")).actionGet(2L, TimeUnit.MINUTES);
            if (!delete.isAcknowledged()) {
                logger.error("Index wasn't deleted");
            }
            return delete.isAcknowledged();
        }
        catch (Exception e) {
            logger.error("error deleting all indices", (Throwable)e);
            return false;
        }
    }

    public static boolean delete(Client client, String indexName) {
        logger.info("deleting index : " + indexName);
        boolean exists = ((IndicesExistsResponse)client.admin().indices().exists(new IndicesExistsRequest(new String[]{indexName})).actionGet()).isExists();
        if (!exists) {
            logger.info("index : " + indexName + " does not exist");
            return true;
        }
        try {
            logger.info("index : " + indexName + " exists");
            DeleteIndexResponse delete = (DeleteIndexResponse)client.admin().indices().delete(new DeleteIndexRequest(indexName)).actionGet(2L, TimeUnit.MINUTES);
            if (!delete.isAcknowledged()) {
                logger.error("Index wasn't deleted");
            }
            logger.info("deleted index : " + indexName + " ? " + delete.isAcknowledged());
            return delete.isAcknowledged();
        }
        catch (Exception e) {
            logger.warn("error while deleting index : " + indexName, (Throwable)e);
            return false;
        }
    }

    public static boolean exists(Client indexClient, String indexName) {
        try {
            IndicesAdminClient iac = indexClient.admin().indices();
            boolean exists = ((IndicesExistsResponse)iac.prepareExists(new String[]{indexName}).get()).isExists();
            logger.info("index : " + indexName + " exists returned : " + exists);
            return exists;
        }
        catch (Exception e) {
            logger.warn("failed to query index exist", (Throwable)e);
            return false;
        }
    }

    public static boolean deleteDocuments(Client client, String indexName, List<String> docIDs) {
        logger.info("docIds to be deleted : " + docIDs);
        boolean res = true;
        for (String docID : docIDs) {
            logger.info("deleting document with gDocCollectionID : " + docID);
            DeleteByQueryRequestBuilder requestBuilder = client.prepareDeleteByQuery(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"ObjectID", (String)docID));
            logger.info("delete request : " + requestBuilder.request());
            DeleteByQueryResponse response = (DeleteByQueryResponse)requestBuilder.get();
            if (response.status() == RestStatus.OK) continue;
            logger.warn("delete of : " + docID + " failed");
            res = false;
        }
        ElasticSearchHelper.commit(client, indexName);
        return res;
    }

    public static Boolean deleteCollections(Client client, String indexName, Collection<String> colls) {
        Boolean ret = true;
        for (String coll : colls) {
            Boolean collDelete = ElasticSearchHelper.deleteCollection(client, indexName, coll);
            if (collDelete.booleanValue()) continue;
            logger.warn("couldn't delete collection : " + coll);
            ret = false;
        }
        return ret;
    }

    public static Boolean deleteCollection(Client client, String indexName, String collID) {
        logger.info("collId to be deleted : " + collID);
        logger.info("deleting document with gDocCollectionID : " + collID);
        DeleteByQueryRequestBuilder requestBuilder = client.prepareDeleteByQuery(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"gDocCollectionID", (String)collID));
        logger.info("delete request : " + requestBuilder.request());
        DeleteByQueryResponse response = (DeleteByQueryResponse)requestBuilder.get();
        logger.info("delete response : " + response.toString());
        ElasticSearchHelper.commit(client, indexName);
        return true;
    }

    public static Boolean collectionExists(Client client, String indexName, String collID) {
        logger.info("collId to be checked : " + collID);
        logger.info("checking collection with gDocCollectionID : " + collID);
        SearchRequestBuilder requestBuilder = client.prepareSearch(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"gDocCollectionID", (String)collID));
        logger.info("search request : " + requestBuilder.request());
        SearchResponse response = (SearchResponse)requestBuilder.get();
        if (response.getHits().getTotalHits() > 0L) {
            return true;
        }
        return false;
    }

    public static Set<String> indicesOfCollection(Client client, String indexName, String collID) {
        HashSet<String> indices = new HashSet<String>();
        logger.info("collId to be checked : " + collID);
        logger.info("checking collection with gDocCollectionID : " + collID);
        SearchRequestBuilder requestBuilder = client.prepareSearch(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"gDocCollectionID", (String)collID));
        logger.info("search request : " + requestBuilder.request());
        SearchResponse response = (SearchResponse)requestBuilder.get();
        for (SearchHit hit : response.getHits().getHits()) {
            indices.add(hit.getIndex());
        }
        return indices;
    }

    public static Set<String> getIndicesOfAlias(Client client, String alias) {
        logger.info("calling aliasResponse");
        GetAliasesResponse aliasResponse = (GetAliasesResponse)client.admin().indices().prepareGetAliases(new String[]{alias}).get();
        logger.info("alias response : " + aliasResponse);
        ImmutableOpenMap aliases = aliasResponse.getAliases();
        logger.info("aliases : " + aliases);
        if (aliases == null || aliases.size() == 0) {
            return null;
        }
        HashSet indices = Sets.newHashSet((Iterator)aliases.keysIt());
        logger.info("indices of alias : " + indices);
        return indices;
    }

    public static List<MultiGetItemResponse> getMultipleDocumentsOfAlias(Client client, String alias, Collection<String> docIDs) {
        logger.info("getting multiple documents of alias for alias : " + alias + " docIDs : " + docIDs);
        Set<String> indicesOfAlias = ElasticSearchHelper.getIndicesOfAlias(client, alias);
        logger.info("indicesOfAlias : " + indicesOfAlias);
        if (indicesOfAlias == null) {
            return new ArrayList<MultiGetItemResponse>();
        }
        return ElasticSearchHelper.getMultipleDocuments(client, indicesOfAlias, docIDs);
    }

    public static List<MultiGetItemResponse> getMultipleDocuments(Client client, Set<String> indices, Collection<String> docIDs) {
        ArrayList<MultiGetItemResponse> documents = new ArrayList<MultiGetItemResponse>(docIDs.size());
        for (String index : indices) {
            MultiGetRequestBuilder grb = new MultiGetRequestBuilder(client).add(index, null, docIDs);
            MultiGetResponse mgr = (MultiGetResponse)grb.get();
            for (MultiGetItemResponse response : mgr.getResponses()) {
                if (response == null || response.getResponse() == null || !response.getResponse().isExists()) continue;
                documents.add(response);
            }
        }
        return documents;
    }

    public static Set<String> getLanguagesOfCollection(Client client, String indexName, String collection) {
        Set<String> langs = ElasticSearchHelper.allLanguagesOfIndexElasticSearch(client, indexName, collection);
        return langs;
    }

    public static Set<String> getAllCollectionsOfIndex(Client client, String indexName) {
        logger.info("getting all collections of index : " + indexName);
        return ElasticSearchHelper.allCollectionsOfIndexElasticSearch(client, indexName);
    }

    public static void clearIndex(Client client, String indexName, String indexTypeName) {
        logger.info("index to be deleted : ");
        DeleteByQueryResponse dr = (DeleteByQueryResponse)client.prepareDeleteByQuery(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setTypes(new String[]{indexTypeName}).get();
        logger.info("Delete response : " + dr.toString());
        ElasticSearchHelper.commit(client, indexName);
    }

    public static void insertSimple(String jsonDoc, Client indexClient, String indexName, String indexType, Set<String> allowedIndexTypes) throws ElasticSearchHelperException {
        if (!allowedIndexTypes.contains(indexType)) {
            throw new ElasticSearchHelperException("index type : " + indexType + " is not in registered index types : " + allowedIndexTypes);
        }
        IndexResponse response = (IndexResponse)indexClient.prepareIndex(indexName, indexType).setSource(jsonDoc).get();
        logger.info("indexResponse : " + response);
    }

    public static void insertBulk(BulkRequestBuilder bulkRequest, String jsonDoc, Client indexClient, String indexName, String indexType, Set<String> allowedIndexTypes) throws ElasticSearchHelperException {
        if (!allowedIndexTypes.contains(indexType + "-" + indexName)) {
            throw new ElasticSearchHelperException("index type : " + indexType + " is not in registered index types : " + allowedIndexTypes);
        }
        IndexRequestBuilder indexRequest = indexClient.prepareIndex(indexName, indexType).setSource(jsonDoc);
        bulkRequest.add(indexRequest);
        logger.info("indexRequest : " + indexRequest);
    }

    public static Boolean insertRowSet(BulkRequestBuilder bulkRequest, Client client, String indexName, FullTextIndexType idxType, Set<String> allowedIndexTypes, String rowsetXML, Set<String> securityIdentifiers) {
        logger.trace("indexName : " + indexName);
        logger.trace("idxType : " + idxType.getIndexTypeName());
        logger.trace("allowedIndexTypes : " + allowedIndexTypes);
        logger.trace("rowsetXML : " + rowsetXML);
        try {
            FullTextIndexDocument document = new FullTextIndexDocument(rowsetXML);
            Map<String, List<String>> docFields = document.getFields();
            if (docFields.containsKey(SECURITY_FIELD)) {
                logger.debug("document contains security field. using this (" + docFields.get(SECURITY_FIELD) + ") instead of given : (" + securityIdentifiers + ")");
            } else {
                docFields.put(SECURITY_FIELD, new ArrayList<String>(securityIdentifiers));
            }
            ElasticSearchHelper.insertBulk(bulkRequest, ElasticSearchHelper.createJSONObject(document.getFields()).string(), client, indexName, idxType.getIndexTypeName(), allowedIndexTypes);
            return true;
        }
        catch (Exception e) {
            logger.warn("Exception while inserting documents", (Throwable)e);
            return false;
        }
    }

    public static XContentBuilder createJSONObject(Map<String, ? extends Object> keyValues) throws IOException {
        XContentBuilder xcb = XContentFactory.jsonBuilder();
        xcb = xcb.startObject();
        for (Map.Entry<String, ? extends Object> keyvalue : keyValues.entrySet()) {
            if (keyvalue.getValue() instanceof List && ((List)keyvalue.getValue()).size() == 1) {
                logger.debug("single value : " + keyvalue.getValue());
                String val = ((List)keyvalue.getValue()).get(0).toString();
                xcb = xcb.field(keyvalue.getKey(), val);
                continue;
            }
            logger.debug("multi value : " + keyvalue.getValue());
            xcb = xcb.field(keyvalue.getKey(), keyvalue.getValue());
        }
        return xcb.endObject();
    }

    public static Set<String> getIndexTypesByCollectionIDNoCache(String collID, Client client, String indexName) {
        HashSet<String> indexTypes = null;
        logger.info("indexTypes for collectionID not found in cache");
        indexTypes = new HashSet<String>();
        SearchRequestBuilder srb = client.prepareSearch(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"gDocCollectionID", (String)collID)).setNoFields();
        logger.trace("query request : " + srb.toString());
        SearchResponse response = (SearchResponse)srb.execute().actionGet();
        logger.trace("query response : " + response);
        for (SearchHit hit : response.getHits().getHits()) {
            indexTypes.add(hit.getType());
        }
        logger.info("for collectionID : " + collID + " indexTypes found : " + indexTypes);
        return indexTypes;
    }

    public static Set<String> getIndexTypesByCollectionIDs(Map<String, Set<String>> indexTypesByCollIDs, Set<String> collIDs, Client client, String indexName) {
        HashSet<String> indexTypes = new HashSet<String>();
        for (String collID : collIDs) {
            indexTypes.addAll(ElasticSearchHelper.getIndexTypesByCollectionID(indexTypesByCollIDs, collID, client, indexName));
        }
        return indexTypes;
    }

    public static Set<String> getIndexTypesByCollectionID(Map<String, Set<String>> indexTypesByCollIDs, String collID, Client client, String indexName) {
        Set<String> indexTypes = null;
        if (indexTypesByCollIDs.containsKey(collID)) {
            indexTypes = indexTypesByCollIDs.get(collID);
            logger.info("indexTypes for collectionID found in cache");
        } else {
            logger.info("indexTypes for collectionID not found in cache");
            indexTypes = new HashSet<String>();
            SearchRequestBuilder srb = client.prepareSearch(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"gDocCollectionID", (String)collID)).setNoFields();
            logger.trace("query request : " + srb.toString());
            SearchResponse response = (SearchResponse)srb.execute().actionGet();
            logger.trace("query response : " + response);
            for (SearchHit hit : response.getHits().getHits()) {
                indexTypes.add(hit.getType());
            }
        }
        logger.info("for collectionID : " + collID + " indexTypes found : " + indexTypes);
        return indexTypes;
    }

    public static String[] createFetchSourceArray(List<String> projections) {
        HashSet<String> fetchSource = new HashSet<String>();
        if (projections != null && projections.size() > 0) {
            fetchSource.addAll(projections);
        }
        return fetchSource.toArray(new String[0]);
    }

    static {
        try (InputStream is = ElasticSearchHelper.class.getClassLoader().getResourceAsStream(STOPWORDS_FILENAME);){
            String stopWordsStr = CharStreams.toString((Readable)new InputStreamReader(is, Charsets.UTF_8));
            STOPWORDS = Splitter.on((CharMatcher)CharMatcher.BREAKING_WHITESPACE).trimResults().omitEmptyStrings().splitToList((CharSequence)stopWordsStr);
        }
        catch (Exception e) {
            logger.error("not able to load stopwords", (Throwable)e);
        }
        logger.info("stopwords : " + STOPWORDS);
    }
}

