/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch.parser.helpers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserHelpers {
    private static Logger logger = LoggerFactory.getLogger(ParserHelpers.class);

    public static String translateField(String fieldID, RRadaptor adaptor) {
        String fieldName;
        if (adaptor != null) {
            try {
                fieldName = adaptor.getFieldNameById(fieldID);
            }
            catch (Exception e) {
                logger.warn("Exception while translating fieldID " + fieldID);
                return fieldID;
            }
        } else {
            fieldName = fieldID;
        }
        return fieldName;
    }

    public static boolean isBoolAnd(QueryBuilder qb) {
        if (qb instanceof BoolQueryBuilder) {
            try {
                Field f = qb.getClass().getDeclaredField("shouldClauses");
                f.setAccessible(true);
                ArrayList shouldClauses = (ArrayList)f.get(qb);
                return shouldClauses.isEmpty();
            }
            catch (IllegalArgumentException e) {
                logger.error("Exception", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error("Exception", (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                logger.error("Exception", (Throwable)e);
            }
            catch (SecurityException e) {
                logger.error("Exception", (Throwable)e);
            }
        }
        return false;
    }

    public static boolean isBoolOr(QueryBuilder qb) {
        if (qb instanceof BoolQueryBuilder) {
            try {
                Field f = qb.getClass().getDeclaredField("mustClauses");
                f.setAccessible(true);
                ArrayList mustClauses = (ArrayList)f.get(qb);
                f = qb.getClass().getDeclaredField("mustNotClauses");
                f.setAccessible(true);
                ArrayList mustNotClauses = (ArrayList)f.get(qb);
                return mustClauses.isEmpty() && mustNotClauses.isEmpty();
            }
            catch (IllegalArgumentException e) {
                logger.error("Exception", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error("Exception", (Throwable)e);
            }
            catch (NoSuchFieldException e) {
                logger.error("Exception", (Throwable)e);
            }
            catch (SecurityException e) {
                logger.error("Exception", (Throwable)e);
            }
        }
        return false;
    }

    private static String getQueryString(QueryStringQueryBuilder qb) {
        try {
            Field f = qb.getClass().getDeclaredField("queryString");
            f.setAccessible(true);
            String queryString = (String)f.get(qb);
            return queryString;
        }
        catch (IllegalArgumentException e) {
            logger.error("Exception", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("Exception", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            logger.error("Exception", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error("Exception", (Throwable)e);
        }
        return null;
    }

    private static FilterBuilder getFilter(ConstantScoreQueryBuilder qb) {
        try {
            Field f = qb.getClass().getDeclaredField("filterBuilder");
            f.setAccessible(true);
            FilterBuilder fb = (FilterBuilder)f.get(qb);
            return fb;
        }
        catch (IllegalArgumentException e) {
            logger.error("Exception", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("Exception", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            logger.error("Exception", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error("Exception", (Throwable)e);
        }
        return null;
    }

    public static QueryBuilder getCombinedQuery(QueryBuilder q1, QueryBuilder q2) {
        boolean isBoolq1 = ParserHelpers.isBoolAnd(q1);
        boolean isBoolq2 = ParserHelpers.isBoolAnd(q2);
        if (q1 instanceof QueryStringQueryBuilder && q2 instanceof QueryStringQueryBuilder) {
            return QueryBuilders.queryString((String)(ParserHelpers.getQueryString((QueryStringQueryBuilder)q1) + " AND " + ParserHelpers.getQueryString((QueryStringQueryBuilder)q2)));
        }
        if (isBoolq1 && isBoolq2) {
            return ((BoolQueryBuilder)q1).must(q2);
        }
        if (isBoolq1 && q2 instanceof QueryStringQueryBuilder) {
            return ((BoolQueryBuilder)q1).must(q2);
        }
        if (isBoolq2 && q1 instanceof QueryStringQueryBuilder) {
            return ((BoolQueryBuilder)q2).must(q1);
        }
        if (q1 instanceof ConstantScoreQueryBuilder) {
            return QueryBuilders.filteredQuery((QueryBuilder)q2, (FilterBuilder)ParserHelpers.getFilter((ConstantScoreQueryBuilder)q1));
        }
        if (q2 instanceof ConstantScoreQueryBuilder) {
            return QueryBuilders.filteredQuery((QueryBuilder)q1, (FilterBuilder)ParserHelpers.getFilter((ConstantScoreQueryBuilder)q2));
        }
        return QueryBuilders.boolQuery().must(q1).must(q2);
    }

    public static QueryBuilder getCombinedOrQuery(QueryBuilder q1, QueryBuilder q2) {
        boolean isBoolOrq1 = ParserHelpers.isBoolOr(q1);
        if (isBoolOrq1) {
            return ((BoolQueryBuilder)q1).should(q2);
        }
        return QueryBuilders.boolQuery().should(q1).should(q2).minimumNumberShouldMatch(1);
    }
}

