package elasticsearchindex;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import elasticsearchindex.components.FullTextIndexType;

public class FTNodeCache {
	private static final int MAX_CACHE_ENTRIES = 100;

	public Map<String, FullTextIndexType> cachedIndexTypes = null;
	public Map<String, Set<String>> indexTypesByCollIDs = null;
	public Map<String, List<String>> presentableFieldsPerIndexType = null;
	
	public FTNodeCache() {
		this.init();
	}
	
	void init() {
		this.cachedIndexTypes = new LinkedHashMap<String, FullTextIndexType>(MAX_CACHE_ENTRIES+1, .75F, true){
			private static final long serialVersionUID = 1L;
			public boolean removeEldestEntry(Map.Entry<String, FullTextIndexType> eldest) {
				return size() > MAX_CACHE_ENTRIES;
			}
		};
		
		this.indexTypesByCollIDs = new LinkedHashMap<String, Set<String>>(MAX_CACHE_ENTRIES+1, .75F, true){
			private static final long serialVersionUID = 1L;
			public boolean removeEldestEntry(Map.Entry<String, Set<String>> eldest) {
				return size() > MAX_CACHE_ENTRIES;
			}
		};
		
		this.presentableFieldsPerIndexType = new LinkedHashMap<String, List<String>>(MAX_CACHE_ENTRIES+1, .75F, true){
			private static final long serialVersionUID = 1L;
			public boolean removeEldestEntry(Map.Entry<String, List<String>> eldest) {
				return size() > MAX_CACHE_ENTRIES;
			}
		};
	}
	
	public void invalidate() {
		this.init();
	}
}