/*
 * Decompiled with CFR 0.152.
 */
package elasticsearchindex.components;

import java.util.Vector;
import org.gcube.common.core.utils.logging.GCUBELog;

public class XMLTokenReplacer {
    private static String AMP = "&amp;";
    private static String LT = "&lt;";
    private static String GT = "&gt;";
    private static String APOS = "&apos;";
    private static String QUOT = "&quot;";
    private static String NULL = "&#x0;";
    private static String SLASH_R = "&#x0D;";
    private static char AMPReplace = (char)38;
    private static char LTReplace = (char)60;
    private static char GTReplace = (char)62;
    private static char APOSReplace = (char)39;
    private static char QUOTReplace = (char)34;
    private static char NULLReplace = '\u0000';
    private static char SLASH_RReplace = (char)13;
    private static int charBlockSize = 200000;
    private static char basicChar = (char)38;
    private static GCUBELog logger = new GCUBELog(XMLTokenReplacer.class);

    public static String XMLResolve(String str) {
        String[] entities = new String[]{LT, GT, APOS, QUOT, SLASH_R, NULL, AMP};
        char[] chars = new char[]{LTReplace, GTReplace, APOSReplace, QUOTReplace, SLASH_RReplace, NULLReplace, AMPReplace};
        int max = XMLTokenReplacer.maxLength(entities);
        Vector<String> strs = new Vector<String>();
        int lastIndex = -1;
        int start = 0;
        for (int i = 0; i < 1 + str.length() / charBlockSize; ++i) {
            if ((lastIndex += charBlockSize) + max >= str.length()) {
                strs.add(str.substring(start));
                break;
            }
            for (int j = 0; j < max; ++j) {
                if (str.charAt(lastIndex) == basicChar) {
                    --lastIndex;
                    break;
                }
                if (j >= max - 1) continue;
                ++lastIndex;
            }
            strs.add(str.substring(start, lastIndex + 1));
            start = lastIndex + 1;
        }
        str = null;
        int size = strs.size();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < entities.length; ++j) {
                strs.add(i, ((String)strs.remove(i)).replaceAll(entities[j], new Character(chars[j]).toString()));
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            String tmp = (String)strs.remove(0);
            if (tmp != null) {
                sb.append(tmp);
            }
            tmp = null;
        }
        return sb.toString();
    }

    public static String XMLUnresolve(String str) {
        String[] entities = new String[]{AMP, LT, GT, APOS, QUOT, NULL, SLASH_R};
        char[] chars = new char[]{AMPReplace, LTReplace, GTReplace, APOSReplace, QUOTReplace, NULLReplace, SLASH_RReplace};
        int max = XMLTokenReplacer.maxLength(entities);
        Vector<String> strs = new Vector<String>();
        int lastIndex = -1;
        int start = 0;
        for (int i = 0; i < 1 + str.length() / charBlockSize; ++i) {
            if ((lastIndex += charBlockSize) >= str.length()) {
                strs.add(str.substring(start));
                break;
            }
            strs.add(str.substring(start, lastIndex + 1));
            start = lastIndex + 1;
        }
        str = null;
        int size = strs.size();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < entities.length; ++j) {
                strs.add(i, ((String)strs.remove(i)).replaceAll(new Character(chars[j]).toString(), entities[j]));
            }
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            String tmp = (String)strs.remove(0);
            if (tmp != null) {
                sb.append(tmp);
            }
            tmp = null;
        }
        return sb.toString();
    }

    public static int maxLength(String[] array) {
        int max = array[0].length();
        for (int i = 1; i < array.length; ++i) {
            if (array[i].length() <= max) continue;
            max = array[i].length();
        }
        return max;
    }
}

