/*
 * Decompiled with CFR 0.152.
 */
package elasticsearchindex.components;

import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.parsers.DOMParser;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLProfileParser {
    private static GCUBELog logger = new GCUBELog(XMLProfileParser.class);
    private DOMParser parser = new DOMParser();
    private Document doc;
    private NodeList children = null;
    private Node rootNode;
    private Node currentNode = null;
    int childNextIndex = -1;

    public void readString(String XMLString, String schemaLocation) throws Exception {
        if (schemaLocation != null && !schemaLocation.equals("")) {
            String propId = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
            this.parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.parser.setProperty(propId, (Object)schemaLocation);
        } else {
            this.parser.setFeature("http://apache.org/xml/features/validation/schema", false);
        }
        this.parser.parse(new InputSource(new StringReader(XMLString)));
        this.doc = this.parser.getDocument();
    }

    public void readDoc(String filename, String schemaLocation) throws Exception {
        if (schemaLocation != null && !schemaLocation.equals("")) {
            String propId = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
            this.parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.parser.setProperty(propId, (Object)schemaLocation);
        } else {
            this.parser.setFeature("http://apache.org/xml/features/validation/schema", false);
        }
        this.parser.parse(filename);
        this.doc = this.parser.getDocument();
    }

    public void readInputStream(InputStream is, String schemaLocation) throws Exception {
        if (schemaLocation != null && !schemaLocation.equals("")) {
            String propId = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
            this.parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            this.parser.setProperty(propId, (Object)schemaLocation);
        } else {
            this.parser.setFeature("http://apache.org/xml/features/validation/schema", false);
        }
        this.parser.parse(new InputSource(is));
        this.doc = this.parser.getDocument();
    }

    public String getFieldText(String fieldname) throws Exception {
        NodeList nodes = this.doc.getElementsByTagName(fieldname);
        Node n = nodes.item(0);
        if (n == null) {
            return "error: field not found";
        }
        nodes = n.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node nn = nodes.item(i);
            if (nn.getNodeType() != 3) continue;
            return ((TextImpl)nn).getData().trim();
        }
        return "error: no TEXT_NODE found";
    }

    public String[] getFieldTextArray(String fieldname) throws Exception {
        NodeList nodes = this.doc.getElementsByTagName(fieldname);
        ArrayList<String> nodeList = new ArrayList<String>();
        Node n = nodes.item(0);
        if (n == null) {
            return null;
        }
        nodes = n.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node nn = nodes.item(i);
            if (nn.getNodeType() != 3) continue;
            nodeList.add(((TextImpl)nn).getData().trim());
        }
        return nodeList.toArray(new String[nodeList.size()]);
    }

    private void printTree() throws Exception {
        Element n = this.doc.getDocumentElement();
        this.iterate(n, "");
    }

    private void iterate(Node n, String s) {
        NodeList nodes = n.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node nn = nodes.item(i);
            if (nn.getNodeType() == 3) {
                TextImpl textImpl = (TextImpl)nn;
                String tmpString = textImpl.getData().trim();
                if (tmpString.length() <= 0) continue;
                logger.info((Object)(s + "data: " + tmpString));
                continue;
            }
            logger.info((Object)(s + "*** " + nn.getNodeName() + " ***"));
            NamedNodeMap map = nn.getAttributes();
            if (map.getNamedItem("name") != null) {
                logger.info((Object)(s + map.getNamedItem("name")));
            }
            if (map.getNamedItem("value") != null) {
                logger.info((Object)(s + map.getNamedItem("value")));
            }
            this.iterate(nn, s + "  ");
        }
    }

    public int setRootNode(String fieldname) throws Exception {
        NodeList nodes = this.doc.getElementsByTagName(fieldname);
        this.rootNode = nodes.item(0);
        if (this.rootNode == null) {
            return -1;
        }
        this.children = this.rootNode.getChildNodes();
        this.childNextIndex = 0;
        this.currentNode = this.rootNode;
        return this.children.getLength() / 2;
    }

    public int countDescendants(String elementName) {
        return this.countDescendants(this.rootNode, elementName);
    }

    private int countDescendants(Node rootNode, String elementName) {
        NodeList list = rootNode.getChildNodes();
        int count = 0;
        for (int i = 0; i < list.getLength(); ++i) {
            String name = list.item(i).getLocalName();
            if (elementName.equals(name)) {
                ++count;
            }
            count += this.countDescendants(list.item(i), elementName);
        }
        return count;
    }

    private int countDescendants(Node rootNode) {
        NodeList list = rootNode.getChildNodes();
        int count = list.getLength();
        for (int i = 0; i < list.getLength(); ++i) {
            count += this.countDescendants(list.item(i));
        }
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setNextField() throws Exception {
        if (this.children == null) {
            return false;
        }
        if (this.childNextIndex >= this.children.getLength()) return false;
        this.currentNode = this.children.item(this.childNextIndex++);
        if (this.currentNode.getNodeType() != 3) return true;
        if (this.childNextIndex >= this.children.getLength()) return false;
        this.currentNode = this.children.item(this.childNextIndex++);
        return true;
    }

    public boolean goChildElement(String elementName) {
        Node tempNode = this.getChildElement(this.currentNode, elementName);
        if (tempNode != null) {
            this.currentNode = tempNode;
            return true;
        }
        return false;
    }

    private Node getChildElement(Node parentNode, String childElementName) {
        NodeList currentChildren = parentNode.getChildNodes();
        Node returnNode = null;
        if (currentChildren == null) {
            return null;
        }
        for (int i = 0; i < currentChildren.getLength(); ++i) {
            if (childElementName.equals(currentChildren.item(i).getLocalName())) {
                return currentChildren.item(i);
            }
            returnNode = this.getChildElement(currentChildren.item(i), childElementName);
            if (returnNode == null) continue;
            return returnNode;
        }
        return null;
    }

    public boolean goSiblingElement(String elementName) {
        Node tempNode = this.getSiblingElement(this.currentNode, elementName);
        if (tempNode != null) {
            this.currentNode = tempNode;
            return true;
        }
        return false;
    }

    private Node getSiblingElement(Node node, String siblingElementName) {
        Node siblingNode = node.getNextSibling();
        if (siblingNode == null) {
            return null;
        }
        if (siblingElementName.equals(siblingNode.getLocalName())) {
            return siblingNode;
        }
        return this.getSiblingElement(siblingNode, siblingElementName);
    }

    public boolean goParentElement(String elementName) {
        Node tempNode = this.getParentElement(this.currentNode, elementName);
        if (tempNode != null) {
            this.currentNode = tempNode;
            return true;
        }
        return false;
    }

    private Node getParentElement(Node child, String parentElementName) {
        Node parentNode = child.getParentNode();
        if (parentNode == null || parentNode == this.rootNode) {
            return null;
        }
        if (parentElementName.equals(parentNode.getLocalName())) {
            return parentNode;
        }
        return this.getParentElement(parentNode, parentElementName);
    }

    public boolean hasDescendant(String elementName) {
        return this.hasDescendant(this.currentNode, elementName);
    }

    private boolean hasDescendant(Node parentNode, String childElementName) {
        NodeList currentChildren = parentNode.getChildNodes();
        if (currentChildren == null) {
            return false;
        }
        for (int i = 0; i < currentChildren.getLength(); ++i) {
            if (childElementName.equals(currentChildren.item(i).getLocalName())) {
                return true;
            }
            if (!this.hasDescendant(currentChildren.item(i), childElementName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasSibling(String elementName) {
        return this.currentNode.getNextSibling() != null;
    }

    public String getFieldByValue(String elementName) throws Exception {
        if (this.currentNode.getNodeType() != 3) {
            Node attr;
            NamedNodeMap attributes = this.currentNode.getAttributes();
            if (attributes != null && (attr = attributes.getNamedItem(elementName)) != null) {
                return attr.getNodeValue();
            }
            NodeList nodes = this.currentNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node nn = nodes.item(i);
                if (!nn.getNodeName().equals(elementName)) continue;
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                StringWriter sw = new StringWriter();
                StreamResult result = new StreamResult(sw);
                DOMSource source = new DOMSource(nn);
                transformer.transform(source, result);
                String sValue = sw.getBuffer().toString();
                sValue = sValue.substring(sValue.indexOf(62) + 1);
                return sValue.substring(0, sValue.lastIndexOf(60));
            }
        }
        return "";
    }

    public String[][] getSubFields() throws Exception {
        if (this.currentNode.getNodeType() == 3) {
            logger.error((Object)"getFieldByValue got a Text Node");
            return null;
        }
        NodeList nodes = this.currentNode.getChildNodes();
        int elementCount = 0;
        for (int i = 0; i < nodes.getLength(); ++i) {
            if (nodes.item(i).getNodeType() != 1) continue;
            ++elementCount;
        }
        String[][] ret = new String[2][elementCount];
        elementCount = 0;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node nn = nodes.item(i);
            if (nn.getNodeType() != 1) continue;
            NamedNodeMap map = nn.getAttributes();
            if (map.getNamedItem("name") != null) {
                Node nnn = map.getNamedItem("name");
                ret[0][elementCount] = nnn.getNodeValue();
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            DOMSource source = new DOMSource(nn);
            transformer.transform(source, result);
            String sValue = sw.getBuffer().toString();
            sValue = sValue.substring(sValue.indexOf(62) + 1);
            ret[1][elementCount] = sValue.substring(0, sValue.lastIndexOf(60));
            ++elementCount;
        }
        return ret;
    }

    public static String escapeForXML(String text) {
        StringBuffer xmlText = new StringBuffer();
        int length = text.length();
        block7: for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '>': {
                    xmlText.append("&gt;");
                    continue block7;
                }
                case '<': {
                    xmlText.append("&lt;");
                    continue block7;
                }
                case '&': {
                    xmlText.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    xmlText.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    xmlText.append("&quot;");
                    continue block7;
                }
                default: {
                    xmlText.append(ch);
                }
            }
        }
        return xmlText.toString();
    }
}

