/*
 * Decompiled with CFR 0.152.
 */
package elasticsearchindex.helpers;

import elasticsearchindex.FTNodeCache;
import elasticsearchindex.components.FullTextIndexType;
import elasticsearchindex.components.IndexException;
import elasticsearchindex.components.IndexField;
import elasticsearchindex.components.XMLProfileParser;
import elasticsearchindex.helpers.SnippetsHelper;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.gcube.common.core.scope.GCUBEScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParser {
    private static final Logger logger = LoggerFactory.getLogger(QueryParser.class);
    private static String regexCollID = "gDocCollectionID:\"(\\S+)\"";
    private static Pattern patternCollID = Pattern.compile(regexCollID);

    private static Set<String> getIndexTypesByCollectionID(Map<String, Set<String>> indexTypesByCollIDs, String collID, Client client, String indexName) {
        Set<String> indexTypes = null;
        if (indexTypesByCollIDs.containsKey(collID)) {
            indexTypes = indexTypesByCollIDs.get(collID);
            logger.info("indexTypes for collectionID found in cache");
        } else {
            logger.info("indexTypes for collectionID not found in cache");
            indexTypes = new HashSet<String>();
            SearchRequestBuilder srb = client.prepareSearch(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"gDocCollectionID", (String)collID)).setNoFields();
            logger.info("query request : " + srb.toString());
            SearchResponse response = (SearchResponse)srb.execute().actionGet();
            logger.info("query response : " + response);
            for (SearchHit hit : response.getHits().getHits()) {
                indexTypes.add(hit.getType());
            }
        }
        logger.info("for collectionID : " + collID + " indexTypes found : " + indexTypes);
        return indexTypes;
    }

    public static Set<String> getIndexTypesByCollectionIDs(Map<String, Set<String>> indexTypesByCollIDs, List<String> collIDs, Client client, String indexName) {
        HashSet<String> indexTypes = new HashSet<String>();
        for (String collID : collIDs) {
            indexTypes.addAll(QueryParser.getIndexTypesByCollectionID(indexTypesByCollIDs, collID, client, indexName));
        }
        return indexTypes;
    }

    public static List<String> createPresentableForIndexTypes(Map<String, List<String>> presentableFieldsPerIndexType, Set<String> indexTypes) {
        ArrayList<String> presentables = new ArrayList<String>();
        for (String idxType : indexTypes) {
            presentables.addAll((Collection)presentableFieldsPerIndexType.get(idxType));
        }
        logger.info("for indexTypes : " + indexTypes + " presentables found : " + presentables);
        return presentables;
    }

    public static List<String> getCollectionsIDFromQuery(String queryString) {
        ArrayList<String> matches = new ArrayList<String>();
        Matcher m = patternCollID.matcher(queryString);
        while (m.find()) {
            matches.add(m.group(1).trim());
        }
        return matches;
    }

    public static String getLuceneQueryFromQueryString(String queryString) {
        String[] s = queryString.split(" project ");
        if (s.length == 2) {
            return s[0].replace("\"", "");
        }
        return null;
    }

    public static List<String> getProjectionsQueryFromQueryString(String queryString) {
        String[] s = queryString.split(" project ");
        if (s.length == 2) {
            return Arrays.asList(s[1].split("\\s+"));
        }
        return null;
    }

    public static FieldDefinition[] createFieldDefinition(List<String> presentable, List<String> projections) throws Exception {
        ArrayList<StringFieldDefinition> fieldDef = new ArrayList<StringFieldDefinition>();
        fieldDef.add(new StringFieldDefinition("rank"));
        fieldDef.add(new StringFieldDefinition("ObjectID"));
        FieldDefinition[] fd = null;
        if (projections == null || projections.size() == 0) {
            fd = fieldDef.toArray(new FieldDefinition[fieldDef.size()]);
            logger.info("No projections found");
        } else if (projections.contains("*")) {
            for (String fieldName : presentable) {
                if (fieldName.equalsIgnoreCase("ObjectID") || fieldName.equalsIgnoreCase("fullpayload")) continue;
                fieldDef.add(new StringFieldDefinition(fieldName));
            }
        } else {
            for (String current : projections) {
                fieldDef.add(new StringFieldDefinition(current));
            }
        }
        fd = fieldDef.toArray(new FieldDefinition[fieldDef.size()]);
        return fd;
    }

    public static boolean isDescendant(String descendantFieldName, IndexField parentField) {
        for (IndexField childField : parentField.childrenFields) {
            if (childField.name.equalsIgnoreCase(descendantFieldName)) {
                return true;
            }
            if (!QueryParser.isDescendant(descendantFieldName, childField)) continue;
            return true;
        }
        return false;
    }

    public static String createIndexTypekey(String indexType, String scope) {
        return indexType + "_" + scope;
    }

    public static FullTextIndexType retrieveIndexType(String indexTypeStr, String scope, FTNodeCache cache) {
        GCUBEScope gcubeScope = GCUBEScope.getScope((String)scope);
        logger.info("gcubeScope : " + gcubeScope);
        return QueryParser.retrieveIndexType(indexTypeStr, gcubeScope, cache);
    }

    public static FullTextIndexType retrieveIndexType(String indexTypeStr, GCUBEScope gcubeScope, FTNodeCache cache) {
        FullTextIndexType indexType = null;
        String scope = gcubeScope.toString();
        logger.info("Retrieving index type for : " + indexTypeStr);
        if (cache.cachedIndexTypes.containsKey(QueryParser.createIndexTypekey(indexTypeStr, scope))) {
            logger.info("Index type : " + indexTypeStr + " found in cache");
            indexType = cache.cachedIndexTypes.get(QueryParser.createIndexTypekey(indexTypeStr, scope));
        } else {
            logger.info("Index type : " + indexTypeStr + " NOT found in cache");
            indexType = new FullTextIndexType(indexTypeStr, gcubeScope);
            logger.info("Retrieved from IS indextype : " + indexType);
            QueryParser.addFullTextIndexTypeIntoCache(indexTypeStr, scope, indexType, cache);
        }
        return indexType;
    }

    public static FullTextIndexType addFullTextIndexTypeIntoCache(String indexTypeStr, String scope, FullTextIndexType indexType, FTNodeCache cache) {
        if (cache.cachedIndexTypes.containsKey(QueryParser.createIndexTypekey(indexTypeStr, scope))) {
            return indexType;
        }
        logger.info("Index type : " + indexTypeStr + "adding into cache");
        cache.cachedIndexTypes.put(QueryParser.createIndexTypekey(indexTypeStr, scope), indexType);
        logger.info("Cache : " + cache.cachedIndexTypes);
        return indexType;
    }

    public static boolean writeSearchHitInResultSet(SearchHit hit, RecordWriter<GenericRecord> rsWriter, List<String> projections, List<String> presentables, int maxFragmentCount, long rsTimeout) throws GRS2WriterException {
        if (rsWriter.getStatus() != IBuffer.Status.Open) {
            return false;
        }
        GenericRecord rec = new GenericRecord();
        ArrayList<StringField> fields = new ArrayList<StringField>();
        Map docMap = hit.getSource();
        logger.info("Hit from index : ");
        logger.info("-------------------------------------");
        if (logger.isInfoEnabled()) {
            for (Map.Entry f : docMap.entrySet()) {
                logger.info((String)f.getKey() + ":" + f.getValue());
            }
        }
        logger.info("-------------------------------------");
        logger.info("Adding score field with value : " + hit.getScore());
        fields.add(new StringField(String.valueOf(hit.getScore())));
        String fieldContentDocID = docMap.containsKey("ObjectID".toLowerCase()) ? docMap.get("ObjectID".toLowerCase()).toString() : "NoMetaId";
        logger.info("Adding " + "ObjectID".toLowerCase() + " field with value : " + fieldContentDocID);
        fields.add(new StringField(fieldContentDocID));
        if (projections != null && projections.size() > 0) {
            List<String> returnFields = null;
            returnFields = projections.contains("*") ? presentables : projections;
            logger.info("returnFields : " + returnFields);
            for (String fieldName : returnFields) {
                if (fieldName.equalsIgnoreCase("ObjectID") || fieldName.equalsIgnoreCase("fullpayload")) continue;
                String fieldContent = null;
                fieldContent = fieldName.equals("S") ? SnippetsHelper.createSnippetString(hit, maxFragmentCount) : (docMap.containsKey(fieldName) ? docMap.get(fieldName).toString() : "");
                fieldContent = XMLProfileParser.escapeForXML(fieldContent);
                logger.info("adding field : " + fieldName + " with value : " + fieldContent);
                fields.add(new StringField(fieldContent));
            }
        }
        if (rsWriter.getStatus() != IBuffer.Status.Open) {
            return false;
        }
        rec.setFields(fields.toArray(new Field[fields.size()]));
        while (!rsWriter.put((Record)rec, rsTimeout, TimeUnit.SECONDS) && rsWriter.getStatus() == IBuffer.Status.Open) {
        }
        return true;
    }

    public static RecordWriter<GenericRecord> initRSWriterForSearchHits(List<String> presentables, List<String> projections) throws IndexException, GRS2WriterException {
        logger.info("Initializing gRS2 writer");
        logger.info("(1/3) getting field definitions");
        FieldDefinition[] fieldDef = null;
        try {
            fieldDef = QueryParser.createFieldDefinition(presentables, projections);
        }
        catch (Exception e) {
            logger.error("Could not create field definition: ", (Throwable)e);
            throw new IndexException(e);
        }
        logger.info("(2/3) creating record definitions");
        RecordDefinition[] definition = new RecordDefinition[]{new GenericRecordDefinition(fieldDef)};
        logger.info("(3/3) creating rsWriter");
        return new RecordWriter((IWriterProxy)new TCPWriterProxy(), definition);
    }
}

