package org.gcube.fulltextindexnode.client.library.beans;

import java.util.List;


import javax.xml.bind.annotation.XmlElement;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public class Types {
	// REQUEST AND RESPONSE ELEMENTS

	public static class StringArray
	{
		@XmlElement(name = "array")
		public List<String> array;
	}
	
	public static class Query
	{
		@XmlElement(name = "query")
		public String query;
		
		@XmlElement(name = "sids")
		public StringArray sids;
	}
	
	public static class QueryLimited
	{
		@XmlElement(name = "query")
		public String query;
		
		@XmlElement(name = "count")
		public Integer count;
		
		@XmlElement(name = "from")
		public Integer from;
		
		@XmlElement(name = "sids")
		public StringArray sids;
	}
	
	
	public static class FeedLocator
	{
		@XmlElement(name = "resultSetLocation")
		public String resultSetLocation;
		
		@XmlElement(name = "indexName")
		public String indexName;
		
		@XmlElement(name = "activate")
		public Boolean activate;
		
		@XmlElement(name = "sids")
		public StringArray sids;
	}
	
	public static class FeedLocatorUnit
	{
		@XmlElement(name = "resultSetLocation")
		public String resultSetLocation;
		
		@XmlElement(name = "indexName")
		public String indexName;
		
		@XmlElement(name = "activate")
		public Boolean activate;
		
		@XmlElement(name = "sids")
		public StringArray sids;
	}
	
	public static class GetIndexInformationResponse
	{
		@XmlElement(name = "IndexID")
		public String IndexID;
		
		@XmlElement(name = "CollectionID")
		public StringArray CollectionID;
		
		@XmlElement(name = "Fields")
		public StringArray Fields;
	}
	
	public static class SetCollections
	{
		@XmlElement(name = "setCollections")
		public StringArray setCollections;
	}
	
	public static class SetFields
	{
		@XmlElement(name = "setFields")
		public StringArray setFields;
	}
	
	public static class CreateResource
	{
		@XmlElement(name = "IndexTypeID")
		public String IndexTypeID;
		
		@XmlElement(name = "IndexID")
		public String IndexID;
		
		@XmlElement(name = "CollectionID")
		public String[] CollectionID;
		
		@XmlElement(name = "ContentType")
		public String ContentType;
		
		@XmlElement(name = "ClusterID")
		public String ClusterID;
	}
	
	public static class CreateResourceResponse
	{
		@XmlElement(name = "EndpointReference", namespace="http://schemas.xmlsoap.org/ws/2004/03/addressing")
		public W3CEndpointReference EndpointReference;
		
		@XmlElement(name = "IndexID")
		public String IndexID;
	}
	
	public static class Destroy{}
	
}
