package org.gcube.fulltextindexnode.client.library.stubs;

import static org.gcube.fulltextindexnode.client.library.utils.FullTextIndexNodeCLConstants.*;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.gcube.fulltextindexnode.client.library.beans.Types.Destroy;
import org.gcube.fulltextindexnode.client.library.beans.Types.FeedLocator;
import org.gcube.fulltextindexnode.client.library.beans.Types.FeedLocatorUnit;
import org.gcube.fulltextindexnode.client.library.beans.Types.GetIndexInformationResponse;
import org.gcube.fulltextindexnode.client.library.beans.Types.QueryLimited;
import org.gcube.fulltextindexnode.client.library.beans.Types.Query;
import org.gcube.fulltextindexnode.client.library.beans.Types.StringArray;

@WebService(name = porttypeLN, targetNamespace = porttypeNS)
public interface FullTextIndexNodeStub {

	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean feedLocator(FeedLocator feedLocator);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean feedLocatorUnit(FeedLocatorUnit feedLocator);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean activateIndex(String indexName);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean deleteIndex(String indexName);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean feedLocatorUnit(String feedLocator);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	StringArray getCollectionsOfIndex(String indexName);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	StringArray getIndicesOfCollection(String collectionID);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Long collectionCount(String collectionID);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean flush(Empty empty);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	String query(Query query);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	String queryLimited(QueryLimited queryLimited);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean shutdown(String shutdown);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean deleteCollection(String collectionID);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean destroyNode(Empty empty);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean refresh(Empty empty);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean rebuildMetaIndex(Empty empty);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	GetIndexInformationResponse getIndexInformation(Empty empty);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean setCollections(StringArray collections);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Boolean setFields(StringArray fields);
	
	@WebMethod(operationName = "Destroy")
	@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
	public void destroy(@WebParam(name = "Destroy", targetNamespace = "http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ResourceLifetime-1.2-draft-01.xsd") Destroy destroy);

}
