package org.gcube.index.fulltextindexnode;

import static org.gcube.resources.discovery.icclient.ICFactory.clientFor;
import static org.gcube.resources.discovery.icclient.ICFactory.queryFor;

import java.net.URI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.rpc.ServiceException;

import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI.MalformedURIException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.types.VOID;
import org.gcube.common.resources.gcore.ServiceInstance;
import org.gcube.common.scope.api.ScopeProvider;
import org.globus.wsrf.ResourceException;
import org.oasis.wsrf.lifetime.Destroy;

import elasticsearchindex.*;

import org.gcube.index.fulltextindexnode.stubs.CreateResourceResponse;
import org.gcube.index.fulltextindexnode.stubs.FullTextIndexNodeFactoryPortType;
import org.gcube.index.fulltextindexnode.stubs.FullTextIndexNodePortType;
import org.gcube.index.fulltextindexnode.stubs.StringArray;
import org.gcube.index.fulltextindexnode.stubs.GetIndexInformationResponse;
import org.gcube.index.fulltextindexnode.stubs.service.FullTextIndexNodeFactoryServiceAddressingLocator;
import org.gcube.index.fulltextindexnode.stubs.service.FullTextIndexNodeServiceAddressingLocator;
import org.gcube.indexmanagement.common.FullTextIndexType;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTextIndexNode extends GCUBEPortType {

	protected static final String FACTORY = "Factory";
	protected static final String SERVICE_NAME = "FullTextIndexNode";
	protected static final String SERVICE_CLASS = "Index";
	private static final String USE_CLUSTER_ID = "useClusterId";
	protected static final int TIMEOUT = 700000;

	private static final Logger logger = LoggerFactory.getLogger(FullTextIndexNode.class);

	private String clusterID = null;
	
	@Override
	protected void onReady() throws Exception {
		super.onReady();
	}

	/** {@inheritDoc} */
	protected ServiceContext getServiceContext() {
		return ServiceContext.getContext();
	}

	public synchronized GetIndexInformationResponse getIndexInformation(VOID request) throws GCUBEFault {
		try {
			Resource managementResource = getResource();

			if (managementResource.isInitializing())
				throw new Exception("Resource is not initialized yet");

			GetIndexInformationResponse response = new GetIndexInformationResponse();
			response.setIndexID(managementResource.getIndexID());

			StringArray colStringArray = new StringArray();
			colStringArray.setArray(managementResource.getCollectionID());
			response.setCollectionID(colStringArray);

			StringArray fieldStringArray = new StringArray();
			fieldStringArray.setArray(managementResource.getFields());
			response.setFields(fieldStringArray);

			return response;
		} catch (Exception e) {
			logger.error("Exception", e);
			throw new GCUBEFault(e.getMessage());
		}
	}

	private void initializeClusterID()
	{
		if(clusterID==null)
		{
			try {
				logger.info("clusterID was null");
				clusterID = (String) getResource().getResourcePropertySet().get(Resource.RP_CLUSTER_ID).get(0);
				logger.info("after get resource clusterID is : " + clusterID);
			} catch (ResourceException e) {
				logger.error("Error while initializing cluster id",e);
			}
		}
		StatefulContext pctx = (StatefulContext) StatefulContext.getContext();
		boolean useClusterID = (Boolean) pctx.getProperty(USE_CLUSTER_ID);
		if (!useClusterID)
			clusterID = ServiceContext.getContext().getScope().toString();

	}
	
	public boolean feedLocator(String resultSetLocation) {
		initializeClusterID();
		final String fResultSetLocation = resultSetLocation;
		
		final String key = getResouceKey();
		
		logger.info("resource key in feeding : " + key);
		
		new Thread() {
			@Override
			public void run() {
				try {
					final HashMap<String, FullTextIndexType> colForField = new HashMap<String, FullTextIndexType>();
					boolean result = FullTextNodeClient.getInstance(clusterID, key).getClient(key).feedLocator(fResultSetLocation, colForField);
					logger.info("Feeding completed, result was: " + result);
					if (result)
						updateManagerProperties(key);
					logger.info("Properties updating completed");
				} catch (Exception e) {
					logger.error("Exception", e);
				}
			}
		}.start();
		return true;
	}

	public String query(String queryString) {
		initializeClusterID();
		try {
			return FullTextNodeClient.getInstance(clusterID, getResouceKey()).getClient(getResouceKey()).query(queryString);
		} catch (Exception e) {
			logger.error("Exception", e);
			return "Caught Exception " + e.getMessage();
		}
	}

	public boolean shutdown(String nothing) {
		initializeClusterID();
		try {
			if (nothing != null && nothing.trim().equalsIgnoreCase("DELETE")) {
				FullTextNodeClient.getInstance(clusterID, getResouceKey()).getClient(getResouceKey()).delete();
			}
			FullTextNodeClient.getInstance(clusterID, getResouceKey()).getClient(getResouceKey()).close();
			
			return true;
		} catch (Exception e) {
			logger.error("Exception", e);
			return false;
		}
	}
	
	public boolean destroyNode(VOID voidType)  {
		initializeClusterID();
		
		boolean hasFailed = false;
		HashMap<String, Set<String>> endpoints = discoverFulltextIndexNodes(Arrays.asList(FullTextNodeClient.getInstance(clusterID, getResouceKey()).getScope(getResouceKey())), clusterID);
		
		logger.info("Found endpoints to shutdown " + endpoints);
		
		logger.info("Deleting indices...");
		FullTextNodeClient.getInstance(clusterID, getResouceKey()).getClient(getResouceKey()).delete();
		logger.info("Deleting indices DONE");
		
		for (String endpoint : endpoints.keySet()) {
			for (String key : endpoints.get(endpoint)) {
				logger.info("Destoying resource " + endpoint + " " + key);
				try {
					EndpointReferenceType factoryEPR = new EndpointReferenceType(new AttributedURI(endpoint + FACTORY));
					FullTextIndexNodeFactoryPortType fpt = new FullTextIndexNodeFactoryServiceAddressingLocator()
							.getFullTextIndexNodeFactoryPortTypePort(factoryEPR);
					fpt = GCUBERemotePortTypeContext.getProxy(fpt, GCUBEScope.getScope(FullTextNodeClient.getInstance(clusterID, getResouceKey()).getScope(getResouceKey())));

					org.gcube.index.fulltextindexnode.stubs.CreateResource cr = new org.gcube.index.fulltextindexnode.stubs.CreateResource();
					cr.setIndexID(key);
					CreateResourceResponse crr = fpt.createResource(cr);
					logger.info("created resource at endpoint " + crr.getEndpointReference());
					FullTextIndexNodePortType pt = new FullTextIndexNodeServiceAddressingLocator().getFullTextIndexNodePortTypePort(crr.getEndpointReference());
					pt = GCUBERemotePortTypeContext.getProxy(pt, GCUBEScope.getScope(FullTextNodeClient.getInstance(clusterID, getResouceKey()).getScope(getResouceKey())), TIMEOUT);
					
					if (pt.shutdown("") == false) { //will not do delete
						logger.error("error deleting index at : " + endpoint);
						hasFailed = true;
					} else {
						logger.info("Destroying of discovered resource...");
						pt.destroy(new Destroy());
						logger.info("Destroying of discovered resource...OK");
					}
				} catch (MalformedURIException e) {
					logger.error("Exception", e);
					hasFailed = true;
				} catch (ServiceException e) {
					logger.error("Exception", e);
					hasFailed = true;
				} catch (RemoteException e) {
					logger.error("Exception", e);
					hasFailed = true;
				} catch (Exception e) {
					logger.error("Exception", e);
					hasFailed = true;
				}
			}
		}
		
		//Delete this resource
		
		
		return !(hasFailed);
	}

	public boolean refresh(VOID voidType) {
		initializeClusterID();
		try {
			FullTextNodeClient.getInstance(clusterID, getResouceKey()).getClient(getResouceKey()).invalidateCache();
			FullTextNodeClient.getInstance(clusterID, getResouceKey()).getClient(getResouceKey()).refreshIndexTypesOfIndex();
		} catch (Exception e) {
			logger.error("Exception ", e);
			return false;
		}
		return true;
	}

	public boolean rebuildMetaIndex(VOID voidType) {
		initializeClusterID();
		try {
			Resource managementResource = getResource();

			if (managementResource.isInitializing())
				throw new Exception("Resource is not initialized yet");

			String[] collectionIds = managementResource.getCollectionID();
			String[] fields = managementResource.getFields();

			logger.info("Adding collectionsIDs: " + Arrays.toString(collectionIds));
			logger.info("Adding fields: " + Arrays.toString(fields));
			FullTextNodeClient.getInstance(clusterID, getResouceKey()).getClient(getResouceKey()).rebuildMetaIndex(collectionIds, fields);

		} catch (Exception e) {
			logger.error("Exception", e);
			return false;
		}
		return true;
	}

	public boolean setCollections(StringArray collectionIDs) throws GCUBEFault {
		try {
			Resource resource = getResource();
			resource.setCollectionID(collectionIDs.getArray());
			resource.store();
		} catch (RemoteException re) {
			throw new GCUBEFault(re.getMessage());
		} catch (Exception e) {
			logger.error("Exception", e);
		}
		return true;
	}

	public boolean setFields(StringArray fields) throws GCUBEFault {
		try {
			Resource resource = getResource();
			resource.setFields(fields.getArray());
			resource.store();
		} catch (RemoteException re) {
			throw new GCUBEFault(re.getMessage());
		} catch (Exception e) {
			logger.error("Exception", e);
		}
		return true;
	}

	@SuppressWarnings("unchecked")
	private boolean updateManagerProperties(String resourceKey) throws GCUBEFault {
		initializeClusterID();
		Map<String, Object> result = null;
		try {
			SearchResponse response = FullTextNodeClient.getInstance(clusterID, resourceKey).getClient(resourceKey).getIndexClient().prepareSearch(FullTextNode.META_INDEX)
					.setQuery(QueryBuilders.matchAllQuery()).execute().actionGet();
			for (SearchHit hit : response.getHits().getHits()) {
				result = hit.getSource();
			}

		} catch (Exception e) {
			logger.warn("Meta Index missing");
		}
		ArrayList<String> collectionIdsToBeAdded;
		ArrayList<String> fieldsToBeAdded;
		if (result != null) {
			collectionIdsToBeAdded = (ArrayList<String>) result.get("collectionIDs");
			fieldsToBeAdded = (ArrayList<String>) result.get("fields");
		} else {
			throw new RuntimeException("no meta-index document found");
		}

		logger.info("fields to be added: " + fieldsToBeAdded);
		logger.info("Collections to be added: " + collectionIdsToBeAdded);

		HashMap<String, Set<String>> endpoints = discoverFulltextIndexNodes(Arrays.asList(FullTextNodeClient.getInstance(clusterID, resourceKey).getScope(resourceKey)), clusterID);

		for (String endpoint : endpoints.keySet()) {
			for (String key : endpoints.get(endpoint)) {
				logger.info("Recreating resource " + endpoint + " " + key);
				try {
					EndpointReferenceType factoryEPR = new EndpointReferenceType(new AttributedURI(endpoint + FACTORY));
					FullTextIndexNodeFactoryPortType fpt = new FullTextIndexNodeFactoryServiceAddressingLocator()
							.getFullTextIndexNodeFactoryPortTypePort(factoryEPR);
					String scope = FullTextNodeClient.getInstance(clusterID, resourceKey).getScope(resourceKey);
					fpt = GCUBERemotePortTypeContext.getProxy(fpt, GCUBEScope.getScope(scope));

					org.gcube.index.fulltextindexnode.stubs.CreateResource cr = new org.gcube.index.fulltextindexnode.stubs.CreateResource();
					cr.setIndexID(key);
					CreateResourceResponse crr = fpt.createResource(cr);
					logger.info("created resource at endpoint " + crr.getEndpointReference());
					FullTextIndexNodePortType pt = new FullTextIndexNodeServiceAddressingLocator().getFullTextIndexNodePortTypePort(crr.getEndpointReference());
					pt = GCUBERemotePortTypeContext.getProxy(pt, GCUBEScope.getScope(FullTextNodeClient.getInstance(clusterID, resourceKey).getScope(resourceKey)), TIMEOUT);
					StringArray sac = new StringArray();
					sac.setArray(Arrays.copyOf(collectionIdsToBeAdded.toArray(), collectionIdsToBeAdded.toArray().length, String[].class));
					pt.setCollections(sac);
					StringArray saf = new StringArray();
					saf.setArray(Arrays.copyOf(fieldsToBeAdded.toArray(), fieldsToBeAdded.toArray().length, String[].class));
					pt.setFields(saf);
				} catch (MalformedURIException e) {
					logger.error("Exception", e);
				} catch (ServiceException e) {
					logger.error("Exception", e);
				} catch (RemoteException e) {
					logger.error("Exception", e);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
			}

		}

		return true;
	}

	public static HashMap<String, Set<String>> discover(String serviceName, String serviceClass, List<String> scopes, String clusterID) {
		logger.info("Discovering : serviceName " + serviceName + " serviceClass, " + serviceClass + " scopes : " + scopes + " clusterID : " + clusterID);
		
		HashMap<String, Set<String>> endpoints = new HashMap<String, Set<String>>();

		for (String scope : scopes) {
			ScopeProvider.instance.set(scope);

			SimpleQuery query = queryFor(ServiceInstance.class);
			query.addNamespace("ns1",URI.create("http://gcube-system.org/namespaces/index/FullTextIndexNode/service"))
				.addCondition("$resource/Data/gcube:ServiceClass/text() eq '" + serviceClass +"'")
				.addCondition("$resource/Data/gcube:ServiceName/text() eq '" + serviceName + "'")
				.addCondition("$resource/Data/ns1:ClusterID/text() eq '" + clusterID + "'");

			DiscoveryClient<ServiceInstance> client = clientFor(ServiceInstance.class);
			List<ServiceInstance> resources = client.submit(query);

			for (ServiceInstance se : resources) {
				String endpoint = se.endpoint().toString();
				if (endpoints.containsKey(endpoint)) {
					Set<String> wsr = endpoints.get(endpoint);
					wsr.add(se.key());
					endpoints.put(endpoint, wsr);
				} else {
					Set<String> wsr = new HashSet<String>();
					wsr.add(se.key());
					endpoints.put(endpoint, wsr);
				}

			}
		}
		return endpoints;
	}

	public static HashMap<String, Set<String>> discoverFulltextIndexNodes(List<String> scopes, String clusterID) {
		return discover(SERVICE_NAME, SERVICE_CLASS, scopes, clusterID);
	}

	private Resource getResource() throws ResourceException {
		return (Resource) StatefulContext.getContext().getWSHome().find();
	}
	
	private String getResouceKey() {
		try {
			String resourceKey = this.getResource().getResourceKey();
			
			//String resourceKey = (String) getResource().getResourcePropertySet().get(Resource.RP_INDEX_ID).get(0);
			logger.info("getResouceKey : " + resourceKey);
			return resourceKey;
		} catch (Exception e) {
			logger.error("Exception", e);
			return null;
		}
	}

}