/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.index.fulltextindexnode;

import elasticsearchindex.FullTextNode;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.index.fulltextindexnode.FullTextNodeClient;
import org.gcube.index.fulltextindexnode.ServiceContext;
import org.gcube.index.fulltextindexnode.StatefulContext;
import org.gcube.indexmanagement.common.IndexWSResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource
extends IndexWSResource {
    private static final Logger logger = LoggerFactory.getLogger(Resource.class);
    public static final String EQUALS = "=";
    public static final String RP_CONTENT_TYPE = "ContentType";
    public static final String RP_INDEX_FORMAT = "IndexFormat";
    public static final String RP_SUPPORTED_RELATIONS = "SupportedRelations";
    public static final String RP_CLUSTER_ID = "ClusterID";
    private static final String USE_CLUSTER_ID = "useClusterId";
    private String resourceKey = null;
    protected static String[] RPNames = new String[]{"ContentType", "IndexFormat"};

    public String getResourceKey() {
        return this.resourceKey;
    }

    protected void initialise(Object ... args) throws Exception {
        ArrayList fieldsToBeAdded;
        ArrayList collectionIdsToBeAdded;
        StatefulContext pctx;
        boolean useClusterID;
        if (args == null) {
            throw new IllegalArgumentException();
        }
        this.setIsInitializing(true);
        GCUBEWSResourceKey key = (GCUBEWSResourceKey)args[0];
        String indexID = (String)args[1];
        String clusterID = (String)args[6];
        logger.info("ClusterID : " + clusterID);
        if (indexID == null || indexID.trim().length() == 0) {
            logger.debug("No indexID given, assigning a new one: " + key.getValue().toString());
            indexID = key.getValue().toString();
        }
        if (!(useClusterID = ((Boolean)(pctx = (StatefulContext)StatefulContext.getContext()).getProperty(USE_CLUSTER_ID, new boolean[0])).booleanValue())) {
            clusterID = ServiceContext.getContext().getScope().toString();
        }
        if (clusterID == null) {
            clusterID = indexID;
        }
        this.resourceKey = key.getValue().toString();
        logger.info("resource key : " + this.resourceKey);
        Map result = null;
        try {
            SearchResponse response = (SearchResponse)FullTextNodeClient.getInstance(clusterID, this.resourceKey).getClient(this.resourceKey).getIndexClient().prepareSearch(new String[]{FullTextNode.META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
            for (SearchHit hit : response.getHits().getHits()) {
                result = hit.getSource();
            }
        }
        catch (Exception e) {
            logger.warn("No meta-index yet");
        }
        if (result != null) {
            collectionIdsToBeAdded = (ArrayList)result.get("collectionIDs");
            fieldsToBeAdded = (ArrayList)result.get("fields");
        } else {
            collectionIdsToBeAdded = new ArrayList();
            fieldsToBeAdded = new ArrayList();
        }
        String[] collectionIds = collectionIdsToBeAdded.toArray(new String[collectionIdsToBeAdded.size()]);
        super.initialise(StatefulContext.getContext().getNamespace(), indexID, null, collectionIds);
        for (int i = 0; i < fieldsToBeAdded.size(); ++i) {
            this.getResourcePropertySet().get("Fields").add(fieldsToBeAdded.get(i));
        }
        ArrayList<String> supportedRelations = new ArrayList<String>();
        for (SupportedRelations relation : SupportedRelations.values()) {
            supportedRelations.add(relation.toString());
        }
        supportedRelations.add(EQUALS);
        this.createProperty(RP_SUPPORTED_RELATIONS);
        this.setSupportedRelations(supportedRelations.toArray(new String[supportedRelations.size()]));
        this.createProperty(RP_CLUSTER_ID);
        this.getResourcePropertySet().get(RP_CLUSTER_ID).add((Object)clusterID);
        logger.info("Initialized FullTextIndexNode Resource with key:" + key.getValue().toString());
        this.setIsInitializing(false);
    }

    public void onLoad(ObjectInputStream ois, boolean firstLoad) throws Exception {
        logger.info("Inside onLoad");
        this.setIsInitializing(true);
        super.onLoad(ois, firstLoad);
        this.createProperty(RP_CLUSTER_ID);
        this.getResourcePropertySet().get(RP_CLUSTER_ID).add((Object)((String)ois.readObject()));
        this.resourceKey = (String)this.getResourcePropertySet().get("IndexID").get(0);
        logger.info("resource key : " + this.resourceKey);
        FullTextNodeClient.getInstance((String)this.getResourcePropertySet().get(RP_CLUSTER_ID).get(0), this.resourceKey);
        String[] fields = this.getFields();
        HashMap<String, HashSet<String>> defaultPresentFields = new HashMap<String, HashSet<String>>();
        for (String field : fields) {
            String[] params = field.split(":");
            String collectionID = params[0];
            String language = params[1];
            HashSet<String> langs = (HashSet<String>)defaultPresentFields.get(collectionID);
            if (langs == null) {
                langs = new HashSet<String>();
                defaultPresentFields.put(collectionID, langs);
            }
            langs.add(language);
        }
        for (Map.Entry current : defaultPresentFields.entrySet()) {
            String collectionID = (String)current.getKey();
            HashSet langs = (HashSet)current.getValue();
            for (String lang : langs) {
                this.addField(collectionID + ":" + lang + ":" + "p" + ":" + "S");
            }
        }
        ArrayList<String> supportedRelations = new ArrayList<String>();
        for (SupportedRelations relation : SupportedRelations.values()) {
            supportedRelations.add(relation.toString());
        }
        supportedRelations.add(EQUALS);
        this.createProperty(RP_SUPPORTED_RELATIONS);
        this.setSupportedRelations(supportedRelations.toArray(new String[supportedRelations.size()]));
        this.setIsInitializing(false);
    }

    public void onStore(ObjectOutputStream oos) throws Exception {
        logger.info("Inside onStore");
        super.onStore(oos);
        oos.writeObject((String)this.getResourcePropertySet().get(RP_CLUSTER_ID).get(0));
    }

    public synchronized void setSupportedRelations(String[] relations) throws Exception {
        int size = relations.length;
        this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).clear();
        for (int i = 0; i < size; ++i) {
            logger.info("Adding Supported relation " + relations[i]);
            this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).add((Object)relations[i]);
        }
    }

    public String getClusterID() {
        return this.getResourcePropertySet().get(RP_CLUSTER_ID).toString();
    }

    public static enum SupportedRelations {
        adj,
        fuzzy,
        proximity,
        within;

    }
}

