package org.gcube.geoindexlookup.client.library.proxies;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.geoindexlookup.client.library.beans.Types.CreateResource;
import org.gcube.geoindexlookup.client.library.beans.Types.CreateResourceResponse;
import org.gcube.geoindexlookup.client.library.exceptions.GeoIndexLookupException;
import org.gcube.geoindexlookup.client.library.stubs.GeoIndexLookupFactoryStub;

public class GeoIndexLookupFactoryCLDefaultProxy implements GeoIndexLookupFactoryCLProxyI {

	private final ProxyDelegate<GeoIndexLookupFactoryStub> delegate;

	public GeoIndexLookupFactoryCLDefaultProxy(ProxyDelegate<GeoIndexLookupFactoryStub> config) {
		this.delegate = config;
	}

	@Override
	public CreateResourceResponse createResource(final CreateResource createResource) throws GeoIndexLookupException {
		Call<GeoIndexLookupFactoryStub, CreateResourceResponse> call = new Call<GeoIndexLookupFactoryStub, CreateResourceResponse>() {
			@Override
			public CreateResourceResponse call(GeoIndexLookupFactoryStub endpoint) throws Exception {
				return endpoint.createResource(createResource);
			}
		};
		try {
			CreateResourceResponse response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new GeoIndexLookupException(e);
		}
	}
}
