package org.gcube.geoindexlookup.client.library.proxies;

import java.net.URI;

import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.geoindexlookup.client.library.utils.GeoIndexLookupCLConstants;

public class SourceQueryBuilder {

	private final StatefulQuery query;
	
	private String indexID;
	
	public SourceQueryBuilder(StatefulQuery query) {
		query.addNamespace("ns1",URI.create(GeoIndexLookupCLConstants.NAMESPACE));
		this.query=query;
	}

	public SourceQueryBuilder withIndexID(String indexID) {
		this.indexID = indexID;
		return this;
	}

	public StatefulQuery build() {
		if (indexID!=null)
			query.addCondition("$resource/Data/ns1:IndexID/text() eq '" + indexID + "'");
		return query;
		
		
	}

}
