package org.gcube.geoindexlookup.client.library.utils;

import static org.gcube.common.clients.stubs.jaxws.GCoreServiceBuilder.*;

import java.util.concurrent.TimeUnit;

import org.gcube.common.clients.stubs.jaxws.GCoreService;
import org.gcube.geoindexlookup.client.library.stubs.GeoIndexLookupFactoryStub;
import org.gcube.geoindexlookup.client.library.stubs.GeoIndexLookupStub;

import javax.xml.namespace.QName;

public class GeoIndexLookupCLConstants {
	public static final int DEFAULT_TIMEOUT= (int) TimeUnit.SECONDS.toMillis(600000);

	public static final String NAMESPACE = "http://gcube-system.org/namespaces/indexmanagement/GeoIndexLookupService";
	public static final String NAME = "gcube/indexmanagement/geoindexmanagement/GeoIndexLookup";
	public static final String FACTORYNAME = "gcube/indexmanagement/geoindexmanagement/GeoIndexLookupFactory";
	public static final QName name = new QName("http://gcube-system.org/namespaces/indexmanagement/GeoIndexLookupService/service", "GeoIndexLookupService");
	public static final QName factoryname = new QName("http://gcube-system.org/namespaces/indexmanagement/GeoIndexLookupFactoryService/service", "GeoIndexLookupFactoryService");
	public static final String porttypeNS = "http://gcube-system.org/namespaces/indexmanagement/GeoIndexLookupService";
	public static final String porttypeLN = "GeoIndexLookupPortType";
	public static final String factoryporttypeNS = "http://gcube-system.org/namespaces/indexmanagement/GeoIndexLookupFactoryService";
	public static final String factoryporttypeLN = "GeoIndexLookupFactoryPortType";
	
	public static final String gcubeClass = "Index";
	public static final String gcubeName = "GeoIndexLookup";
	public static final GCoreService<GeoIndexLookupStub> gil = service().withName(name)
            .coordinates(gcubeClass,gcubeName)
                .andInterface(GeoIndexLookupStub.class);
	
	public static final GCoreService<GeoIndexLookupFactoryStub> gilf = service().withName(factoryname)
            .coordinates(gcubeClass,gcubeName)
                .andInterface(GeoIndexLookupFactoryStub.class);

}