package org.gcube.geoindexmanagement.client.library.plugins;

import javax.xml.ws.EndpointReference;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.common.clients.stubs.jaxws.StubFactory;
import org.gcube.geoindexmanagement.client.library.proxies.GeoIndexManagementFactoryCLDefaultProxy;
import org.gcube.geoindexmanagement.client.library.proxies.GeoIndexManagementFactoryCLProxyI;
import org.gcube.geoindexmanagement.client.library.stubs.GeoIndexManagementFactoryStub;
import org.gcube.geoindexmanagement.client.library.utils.GeoIndexManagementCLConstants;

/**
 * DTS Client Library plugin exposes information that allows CL Framework
 * components to act on behalf of DTS CL. 
 * 
 * @author john.gerbesiotis - DI NKUA
 * 
 */
public class GeoIndexManagementFactoryCLPlugin implements Plugin<GeoIndexManagementFactoryStub, GeoIndexManagementFactoryCLProxyI> {

	@Override
	public String name() {
		return GeoIndexManagementCLConstants.FACTORYNAME;
	}

	@Override
	public String namespace() {
		return GeoIndexManagementCLConstants.NAMESPACE;
	}

	@Override
	public String serviceClass() {
		return GeoIndexManagementCLConstants.gcubeClass;
	}

	@Override
	public String serviceName() {
		return GeoIndexManagementCLConstants.gcubeName;
	}
	
	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public GeoIndexManagementFactoryStub resolve(EndpointReference reference, ProxyConfig<?, ?> proxyConfig) throws Exception {
		return StubFactory.stubFor(GeoIndexManagementCLConstants.gimf).at(reference);
	}

	@Override
	public GeoIndexManagementFactoryCLProxyI newProxy(ProxyDelegate<GeoIndexManagementFactoryStub> delegate) {
		return new GeoIndexManagementFactoryCLDefaultProxy(delegate);
	}

}
