/**
 * 
 */
package src.IndexManagement;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

/**
 * @author Spyros Boutsis, NKUA
 *
 */
public class VOInfoManager {

	private Properties props;
	private List<CollectionInfo> colInfo;
	
	public VOInfoManager(String propFile) throws Exception {
		try {
			props = new Properties();            
			props.load(new FileInputStream(propFile));            
		} catch (FileNotFoundException ex) {
			System.out.println(" *** File not found *** " + propFile);
			throw ex;
		}
		catch (IOException ex) {
			System.out.println(" *** Properties not loaded *** " + propFile);
			throw ex;
		}
		
		colInfo = new LinkedList<CollectionInfo>();
		int i = 1;
		while (true) {
			try {
				colInfo.add(new CollectionInfo(props, i));
				i++;
			} catch (Exception e) {
				break;
			}
		}
	}

	public String getMetadataBrokerURI() {
		return props.getProperty("MetadataBrokerURI");
	}
	
	public String getForwardIndexManagementFactoryURI() {
		return props.getProperty("ForwardIndexManagementFactoryURI");
	}
	
	public String getForwardIndexUpdaterFactoryURI() {
		return props.getProperty("ForwardIndexUpdaterFactoryURI");
	}
	
	public String getForwardIndexLookupFactoryURI() {
		return props.getProperty("ForwardIndexLookupFactoryURI");
	}
	
	public String getGeoIndexManagementFactoryURI() {
		return props.getProperty("GeoIndexManagementFactoryURI");
	}
	
	public String getGeoIndexUpdaterFactoryURI() {
		return props.getProperty("GeoIndexUpdaterFactoryURI");
	}
	
	public String getGeoIndexLookupFactoryURI() {
		return props.getProperty("GeoIndexLookupFactoryURI");
	}
	
	public String getFullTextIndexManagementFactoryURI() {
		return props.getProperty("FullTextIndexManagementFactoryURI");
	}
	
	public String getFullTextIndexUpdaterFactoryURI() {
		return props.getProperty("FullTextIndexUpdaterFactoryURI");
	}
	
	public String getFullTextIndexLookupFactoryURI() {
		return props.getProperty("FullTextIndexLookupFactoryURI");
	}
	
	public List<CollectionInfo> getCollections() {
		return colInfo;
	}
	
	public CollectionInfo findCollectionByName(String name) {
		for (CollectionInfo c : colInfo) {
			if (c.getColName().equals(name))
				return c;
		}
		return null;
	}

	
	public class CollectionInfo {
		private String colName;
		private String colID;
		private List<MetadataCollectionInfo> mcols;
		
		CollectionInfo(Properties props, int colIndex) throws Exception {			
			colName = props.getProperty("Collection." + colIndex + ".name");
			colID = props.getProperty("Collection." + colIndex + ".CID");			
			if (colName==null || colID==null)
				throw new Exception("Collection " + colIndex + " not found in the properties set.");
			
			String mcSchema = null;
			String mcLang = null;
			String mcID = null;
			int i = 1;
			mcols = new LinkedList<MetadataCollectionInfo>();
			while (true) {
				mcSchema = props.getProperty("Collection." + colIndex + ".MC." + i + ".schema");
				mcLang = props.getProperty("Collection." + colIndex + ".MC." + i + ".language");
				mcID = props.getProperty("Collection." + colIndex + ".MC." + i + ".MCID");
				if (mcSchema==null || mcLang==null || mcID==null)
					break;

				mcols.add(new MetadataCollectionInfo(mcSchema, mcLang, mcID));
				i++;
			}
		}
		
		public String getColName() {
			return colName;
		}
		
		public String getColID() {
			return colID;
		}
		
		public List<MetadataCollectionInfo> getMetadataCollections() {
			return mcols;
		}
		
		public MetadataCollectionInfo findMetadataCollection(String schema, String language) {
			for (MetadataCollectionInfo mc : mcols) {
				if (mc.getSchema().equals(schema) && mc.getLanguage().equals(language))
					return mc;
			}
			return null;
		}

	}
	
	public class MetadataCollectionInfo {
		private String schema;
		private String language;
		private String ID;
		
		public MetadataCollectionInfo(String schema, String language, String ID) {
			this.schema = schema;
			this.language = language;
			this.ID = ID;
		}
		
		public String getSchema() {
			return schema;
		}
		
		public String getLanguage() {
			return language;
		}
		
		public String getID() {
			return ID;	
		}
	}
}
